/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import jp.jurassicsaga.client.base.renderer.model.vanilla.JSBoatModel;
import jp.jurassicsaga.client.base.renderer.model.vanilla.JSChestBoatModel;
import jp.jurassicsaga.server.base.entity.obj.vanilla.JSBoatEntity;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class JSBoatRenderer
extends EntityRenderer<JSBoatEntity> {
    private final Map<JSBoatEntity.CustomType, Pair<ResourceLocation, ListModel<JSBoatEntity>>> boatResources;

    public JSBoatRenderer(EntityRendererProvider.Context pContext, boolean pChestBoat) {
        super(pContext);
        this.shadowRadius = 0.8f;
        this.boatResources = (Map)Stream.of(JSBoatEntity.CustomType.values()).collect(ImmutableMap.toImmutableMap(p_173938_ -> p_173938_, modType -> Pair.of((Object)ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)JSBoatRenderer.getTextureLocation(modType, pChestBoat)), this.createBoatModel(pContext, (JSBoatEntity.CustomType)((Object)modType), pChestBoat))));
    }

    private ListModel<JSBoatEntity> createBoatModel(EntityRendererProvider.Context pContext, JSBoatEntity.CustomType pType, boolean pChestBoat) {
        ModelLayerLocation modellayerlocation = pChestBoat ? JSBoatRenderer.createChestBoatModelName(pType) : JSBoatRenderer.createBoatModelName(pType);
        ModelPart modelpart = pContext.bakeLayer(modellayerlocation);
        return pChestBoat ? new JSChestBoatModel(modelpart) : new JSBoatModel(modelpart);
    }

    public static ModelLayerLocation createChestBoatModelName(JSBoatEntity.CustomType pType) {
        return JSBoatRenderer.createLocation("boat/chest" + pType.getName());
    }

    public static ModelLayerLocation createBoatModelName(JSBoatEntity.CustomType pType) {
        return JSBoatRenderer.createLocation("boat/" + pType.getName());
    }

    private static ModelLayerLocation createLocation(String pPath) {
        return new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)pPath), "main");
    }

    private static String getTextureLocation(JSBoatEntity.CustomType pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/boat/chest/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    public void render(JSBoatEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        float f2;
        pMatrixStack.pushPose();
        pMatrixStack.translate(0.0f, 0.375f, 0.0f);
        pMatrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - pEntityYaw));
        float f = (float)pEntity.getHurtTime() - pPartialTicks;
        float f1 = pEntity.getDamage() - pPartialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            pMatrixStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * (float)pEntity.getHurtDir()));
        }
        if (!Mth.equal((float)(f2 = pEntity.getBubbleAngle(pPartialTicks)), (float)0.0f)) {
            pMatrixStack.mulPose(new Quaternionf().setAngleAxis(pEntity.getBubbleAngle(pPartialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<JSBoatEntity>> pair = this.getModelWithLocation(pEntity);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        ListModel listmodel = (ListModel)pair.getSecond();
        pMatrixStack.scale(-1.0f, -1.0f, 1.0f);
        pMatrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        listmodel.setupAnim((Entity)pEntity, pPartialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.getBuffer(listmodel.renderType(resourcelocation));
        listmodel.renderToBuffer(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, -1);
        if (!pEntity.isUnderWater()) {
            VertexConsumer vertexconsumer1 = pBuffer.getBuffer(RenderType.waterMask());
            if (listmodel instanceof WaterPatchModel) {
                WaterPatchModel waterpatchmodel = (WaterPatchModel)listmodel;
                waterpatchmodel.waterPatch().render(pMatrixStack, vertexconsumer1, pPackedLight, OverlayTexture.NO_OVERLAY);
            }
        }
        pMatrixStack.popPose();
        super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull JSBoatEntity pEntity) {
        return (ResourceLocation)this.getModelWithLocation(pEntity).getFirst();
    }

    public Pair<ResourceLocation, ListModel<JSBoatEntity>> getModelWithLocation(JSBoatEntity boat) {
        return this.boatResources.get((Object)boat.getNWBoatEntityType());
    }
}

