/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.renderer.entity;

import java.util.Optional;
import java.util.UUID;
import jp.jurassicsaga.server.base.entity.obj.other.vehicle.JSVehicleEntity;
import mod.azure.azurelib.common.animation.AzAnimator;
import mod.azure.azurelib.common.animation.AzAnimatorConfig;
import mod.azure.azurelib.common.animation.controller.AzAnimationController;
import mod.azure.azurelib.common.animation.controller.AzAnimationControllerContainer;
import mod.azure.azurelib.common.animation.impl.AzEntityAnimator;
import mod.azure.azurelib.common.model.AzBakedModel;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.entity.AzEntityRenderer;
import mod.azure.azurelib.common.render.entity.AzEntityRendererConfig;
import mod.azure.azurelib.common.render.entity.AzEntityRendererPipeline;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class VehicleRenderer
extends AzEntityRenderer<JSVehicleEntity> {
    public VehicleRenderer(EntityRendererProvider.Context renderManager, String vehicleName) {
        super(AzEntityRendererConfig.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)("geo/vehicle/" + vehicleName + ".geo.json")), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)("textures/entity/vehicle/" + vehicleName + ".png"))).setAnimatorProvider(() -> new Animator(vehicleName)).build(), renderManager);
    }

    public AzEntityRendererPipeline<JSVehicleEntity> createPipeline(AzEntityRendererConfig<JSVehicleEntity> config) {
        return new Pipeline(config, this);
    }

    public static class Pipeline
    extends AzEntityRendererPipeline<JSVehicleEntity> {
        public Pipeline(AzEntityRendererConfig<JSVehicleEntity> config, AzEntityRenderer<JSVehicleEntity> entityRenderer) {
            super(config, entityRenderer);
        }

        public void preRender(AzRendererPipelineContext<UUID, JSVehicleEntity> context, boolean isReRender) {
            super.preRender(context, isReRender);
        }
    }

    public static class Animator
    extends AzEntityAnimator<JSVehicleEntity> {
        private final ResourceLocation loc;

        public Animator(String vehicleName) {
            super(AzAnimatorConfig.builder().build());
            this.loc = ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)("animations/vehicle/" + vehicleName + ".animation.json"));
        }

        public void registerControllers(AzAnimationControllerContainer<JSVehicleEntity> azAnimationControllerContainer) {
            azAnimationControllerContainer.add(AzAnimationController.builder((AzAnimator)this, (String)"base_controller").build(), new AzAnimationController[0]);
        }

        public void setCustomAnimations(JSVehicleEntity animatable, float partialTicks) {
            Optional frontRightWheelHolder;
            Optional frontLeftWheelHolder;
            AzBakedModel bakedModel = this.context().boneCache().getBakedModel();
            Optional root = bakedModel.getBone("root");
            if (root.isPresent()) {
                float rot = Mth.rotLerp((float)partialTicks, (float)animatable.getYHeadRotO(), (float)animatable.getYHeadRot()) * ((float)Math.PI / 180);
                ((AzBone)root.get()).setRotY(rot);
            }
            Optional rearAxleHolder = bakedModel.getBone("rodRear");
            double deltaX = animatable.getX() - animatable.xo;
            double deltaZ = animatable.getZ() - animatable.zo;
            double deltaDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            if (rearAxleHolder.isPresent()) {
                AzBone rearAxle = (AzBone)rearAxleHolder.get();
                if (deltaDistance != 0.0) {
                    float deltaRotation = (float)(deltaDistance / 4.0);
                    float rotX = rearAxle.getRotX();
                    rotX += deltaRotation;
                    rotX = Mth.wrapDegrees((float)rotX);
                    rearAxle.setRotX(rotX);
                }
            }
            if ((frontLeftWheelHolder = bakedModel.getBone("wheelFrontLeft")).isPresent()) {
                AzBone frontLeftWheel = (AzBone)frontLeftWheelHolder.get();
                if (deltaDistance != 0.0) {
                    float deltaRotation = (float)(deltaDistance / 4.0);
                    float rotX = frontLeftWheel.getRotX();
                    rotX += deltaRotation;
                    rotX = Mth.wrapDegrees((float)rotX);
                    frontLeftWheel.setRotX(rotX);
                }
            }
            if ((frontRightWheelHolder = bakedModel.getBone("wheelFrontRight")).isPresent()) {
                AzBone frontRightWheel = (AzBone)frontRightWheelHolder.get();
                if (deltaDistance != 0.0) {
                    float deltaRotation = (float)(deltaDistance / 4.0);
                    float rotX = frontRightWheel.getRotX();
                    rotX += deltaRotation;
                    rotX = Mth.wrapDegrees((float)rotX);
                    frontRightWheel.setRotX(rotX);
                }
            }
        }

        @NotNull
        public ResourceLocation getAnimationLocation(JSVehicleEntity block) {
            return this.loc;
        }
    }
}

