/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.client.base.renderer.JSRenderers;
import jp.jurassicsaga.client.base.renderer.model.VenomSpitModel;
import jp.jurassicsaga.server.base.entity.obj.other.VenomSpit;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class VenomSpitRenderer
extends EntityRenderer<VenomSpit> {
    private static final ResourceLocation LLAMA_SPIT_LOCATION = JSCommon.createId("textures/generic/venom_spit.png");
    private final VenomSpitModel<VenomSpit> model;

    public VenomSpitRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new VenomSpitModel(context.bakeLayer(JSRenderers.VENOM_SPIT));
    }

    public void render(VenomSpit entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.15f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot())));
        this.model.setupAnim(entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.getBuffer(this.model.renderType(LLAMA_SPIT_LOCATION));
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(VenomSpit entity) {
        return LLAMA_SPIT_LOCATION;
    }
}

