/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.renderer.layer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import mod.azure.azurelib.common.cache.texture.AutoGlowingTexture;
import mod.azure.azurelib.common.cache.texture.AzAbstractTexture;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.render.AzRendererPipeline;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.layer.AzRenderLayer;
import mod.azure.azurelib.common.util.client.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;

public class GlowLayer
implements AzRenderLayer<UUID, SmartAnimalBase> {
    public void preRender(AzRendererPipelineContext<UUID, SmartAnimalBase> context) {
    }

    public void render(AzRendererPipelineContext<UUID, SmartAnimalBase> context) {
        Object object = context.animatable();
        if (object instanceof JSAnimalBase) {
            JSAnimalBase base = (JSAnimalBase)((Object)object);
            if (!base.getModules().getGeneticModule().getGeneData().getVariant().shouldGlow() && !base.getAnimal().getAnimalAttributes().getMiscProperties().isRequiresGlow()) {
                return;
            }
            if (base.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT) {
                return;
            }
            SmartAnimalBase animatable = (SmartAnimalBase)context.animatable();
            AzRendererPipeline renderPipeline = context.rendererPipeline();
            ResourceLocation textureLocation = renderPipeline.config().textureLocation((Object)animatable);
            RenderType renderType = AzAbstractTexture.getRenderType((ResourceLocation)textureLocation);
            Object object2 = context.animatable();
            if (object2 instanceof Entity) {
                Entity entity = (Entity)object2;
                boolean isInvisibleButVisibleToPlayer = entity.isInvisible() && !entity.isInvisibleTo(ClientUtils.getClientPlayer());
                boolean shouldAppearGlowing = Minecraft.getInstance().shouldEntityAppearGlowing(entity);
                if (isInvisibleButVisibleToPlayer) {
                    renderType = RenderType.outline((ResourceLocation)textureLocation);
                } else if (shouldAppearGlowing) {
                    renderType = AzAbstractTexture.getOutlineRenderType((ResourceLocation)textureLocation);
                }
            }
            if (context.renderType() != null) {
                RenderType prevRenderType = context.renderType();
                int prevPackedLight = context.packedLight();
                VertexConsumer prevVertexConsumer = context.vertexConsumer();
                context.setRenderType(renderType);
                context.setPackedLight(0xF00000);
                context.setVertexConsumer(context.multiBufferSource().getBuffer(renderType));
                renderPipeline.reRender(context);
                context.setRenderType(prevRenderType);
                context.setPackedLight(prevPackedLight);
                context.setVertexConsumer(prevVertexConsumer);
            }
        }
    }

    public void renderForBone(AzRendererPipelineContext<UUID, SmartAnimalBase> azRendererPipelineContext, AzBone azBone) {
    }

    protected RenderType getRenderType(JSAnimalBase animatable, @Nullable MultiBufferSource bufferSource) {
        if (animatable instanceof JSAnimalBase) {
            JSAnimalBase entity = animatable;
            if (entity.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT) {
                return AutoGlowingTexture.getRenderType((ResourceLocation)animatable.getAnimal().getAnimalAttributes().getEntityBaseProperties().getLocator().getTextureLocation((SmartAnimalBase)animatable));
            }
            return RenderType.translucent();
        }
        return RenderType.translucent();
    }
}

