/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.screen.obj;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.JSTheme;
import jp.jurassicsaga.client.base.screen.obj.widget.EmptyButton;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.entity.obj.other.PaddockSignEntity;
import jp.jurassicsaga.server.base.generic.networking.obj.UpdatePaddockSign;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.StringUtils;
import travelers.client.TravelersClient;
import travelers.server.animal.obj.misc.AnimalType;
import travelers.util.helper.TravelersPacketDistributor;

public class PaddockSignScreen
extends Screen {
    private static final String BASE_BG = "textures/gui/container/paddock_sign";
    private static final String BASE_ITEM = "textures/gui/sprites/paddock_sign_item";
    private static final String BASE_ITEM_SELECTED = "textures/gui/sprites/paddock_sign_item_selected";
    private static final String BASE_SCROLL = "textures/gui/sprites/scrollbar";
    private static final int BG_W = 256;
    private static final int BG_H = 121;
    private final List<AbstractWidget> paddockSignButtons = Lists.newArrayList();
    private final ResourceLocation levelLoc;
    private final int entityId;
    private int scrollOffset = 0;
    private int sliderYOffset = 0;
    private String currentSearch = "";
    private Entity entity;
    private JSAnimal<?> previewAnimal;
    private final JSTheme theme;

    public PaddockSignScreen(ResourceLocation levelLoc, int entityId) {
        super((Component)Component.translatable((String)"js.screen.empty"));
        this.levelLoc = levelLoc;
        this.entityId = entityId;
        this.theme = JSCommon.config.theme;
    }

    private static ResourceLocation tex(String path, boolean jp) {
        return ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)(path + (jp ? "_jp" : "") + ".png"));
    }

    private static ResourceLocation item(boolean jp, boolean selected) {
        return PaddockSignScreen.tex(selected ? BASE_ITEM_SELECTED : BASE_ITEM, jp);
    }

    private static ResourceLocation scrollbar() {
        return ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)(BASE_SCROLL + (JSCommon.config.theme == JSTheme.JP ? "_jp" : "") + ".png"));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259) {
            if (this.currentSearch.isEmpty()) {
                return false;
            }
            this.currentSearch = this.currentSearch.substring(0, this.currentSearch.length() - 1);
            this.scrollOffset = 0;
            this.sliderYOffset = 0;
            this.init();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (StringUtil.isAllowedChatCharacter((char)codePoint) && this.currentSearch.length() < 15) {
            this.currentSearch = this.currentSearch + codePoint;
            this.scrollOffset = 0;
            this.sliderYOffset = 0;
            this.init();
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    protected void init() {
        int cx = this.width / 2;
        int cy = this.height / 2;
        this.paddockSignButtons.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.paddockSignButtons.clear();
        int yOffset = 0;
        int skip = this.scrollOffset;
        int count = 0;
        ArrayList<JSAnimal<?>> sort = JSAnimals.getAnimals();
        sort.sort(Comparator.comparing(jsAnimal -> jsAnimal.getAnimalAttributes().getAnimalName()));
        for (JSAnimal<?> jsAnimal2 : sort) {
            if (!jsAnimal2.getAnimalAttributes().getMiscProperties().isExtinct() || !this.currentSearch.isEmpty() && !jsAnimal2.getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT).contains(this.currentSearch.toLowerCase(Locale.ROOT)) || skip-- > 0) continue;
            if (count > 3) break;
            this.addButton((AbstractWidget)new EmptyButton(cx - 99, cy - 48 + yOffset, 111, 20, (Component)Component.empty(), press -> {
                if (this.entity instanceof PaddockSignEntity) {
                    this.previewAnimal = jsAnimal2;
                }
            }));
            yOffset += 21;
            ++count;
        }
        this.addButton((AbstractWidget)new EmptyButton(cx + 33, cy + 40, 82, 10, (Component)Component.empty(), press -> {
            Entity patt0$temp = this.entity;
            if (patt0$temp instanceof PaddockSignEntity) {
                PaddockSignEntity e = (PaddockSignEntity)patt0$temp;
                if (this.previewAnimal != null) {
                    TravelersPacketDistributor.sendToServer((CustomPacketPayload)new UpdatePaddockSign(this.levelLoc, this.previewAnimal.getAnimalAttributes().getAnimalName(), this.entityId));
                    e.setAnimal(this.previewAnimal.getAnimalAttributes().getAnimalName());
                    Minecraft.getInstance().setScreen(null);
                }
            }
        }));
    }

    private void addButton(AbstractWidget button) {
        this.addRenderableWidget((GuiEventListener)button);
        this.paddockSignButtons.add(button);
    }

    public void renderBackground(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        boolean jp = this.theme == JSTheme.JP;
        int cx = this.width / 2;
        int cy = this.height / 2;
        Entity entity = this.entity;
        if (!(entity instanceof PaddockSignEntity)) {
            this.entity = this.minecraft.player.level().getEntity(this.entityId);
        } else {
            PaddockSignEntity paddockSignEntity = (PaddockSignEntity)entity;
            g.blit(PaddockSignScreen.tex(BASE_BG, jp), cx - 120, cy - 64, 0.0f, 0.0f, 256, 121, 256, 256);
            g.blit(PaddockSignScreen.scrollbar(), cx + 14, cy - 48 + this.sliderYOffset, 0.0f, 0.0f, 5, 14, 5, 14);
            if (this.previewAnimal == null) {
                this.previewAnimal = paddockSignEntity.getAnimal();
            }
            if (this.previewAnimal != null && this.previewAnimal.getAnimalAttributes().getMiscProperties().isExtinct()) {
                g.blit(JSCommon.createId("textures/block/manmade/other/paddock_sign/" + this.previewAnimal.getAnimalAttributes().getAnimalName() + ".png"), cx + 31, cy - 49, 0.0f, 0.0f, 86, 86, 86, 86);
            }
            int yOffset = 0;
            int skip = this.scrollOffset;
            int count = 0;
            ArrayList<JSAnimal<?>> sort = JSAnimals.getAnimals();
            sort.sort(Comparator.comparing(jsAnimal -> jsAnimal.getAnimalAttributes().getAnimalName()));
            for (JSAnimal<?> jsAnimal2 : sort) {
                if (!jsAnimal2.getAnimalAttributes().getMiscProperties().isExtinct() || !this.currentSearch.isEmpty() && !jsAnimal2.getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT).contains(this.currentSearch.toLowerCase(Locale.ROOT)) || skip-- > 0) continue;
                if (count > 3) break;
                g.blit(PaddockSignScreen.item(jp, this.previewAnimal != null && jsAnimal2 == this.previewAnimal), cx - 99, cy - 48 + yOffset, 0.0f, 0.0f, 111, 20, 111, 20);
                AnimalType type = jsAnimal2.getAnimalAttributes().getEntityBaseProperties().getAnimalType();
                boolean useAnimalType = switch (type) {
                    case AnimalType.FISH, AnimalType.BIRD, AnimalType.AMPHIBIAN, AnimalType.INSECT -> true;
                    default -> false;
                };
                g.blit(JSCommon.createId("textures/item/natural/entity/default_coins/coin_" + (useAnimalType ? jsAnimal2.getAnimalAttributes().getEntityBaseProperties().getAnimalType().getName() : jsAnimal2.getAnimalAttributes().getMetabolismProperties().getDietType().getName()) + ".png"), cx - 96, cy - 45 + yOffset, 0.0f, 0.0f, 14, 14, 14, 14);
                String name = jsAnimal2.getAnimalAttributes().getAnimalName();
                String version = PaddockSignScreen.getVersion(jsAnimal2);
                g.blit(JSCommon.createId("textures/item/natural/entity/animal/" + version + "/extinct/" + name + "/" + name + "_coin.png"), cx - 96, cy - 45 + yOffset, 0.0f, 0.0f, 14, 14, 14, 14);
                String trans = Component.translatable((String)("entity.jurassicsaga." + name)).getString();
                if (trans.length() > 15) {
                    trans = StringUtils.capitalize((String)name.substring(0, 15));
                }
                g.drawString(this.font, trans, cx - 80, cy - 42 + yOffset, this.theme.getColor(), true);
                yOffset += 21;
                ++count;
            }
            if (!this.currentSearch.isEmpty()) {
                Object text = this.currentSearch;
                if (TravelersClient.clientTicks % 12 > 6 && this.currentSearch.length() < 14) {
                    text = (String)text + "_";
                }
                g.drawString(this.font, (String)text, cx - 87, cy + 41, this.theme.getColor(), true);
            } else if (TravelersClient.clientTicks % 12 > 6) {
                g.drawString(this.font, "_", cx - 87, cy + 41, this.theme.getColor(), true);
            }
            g.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.jurassicsaga.confirm"), cx + 74, cy + 41, this.theme.getColor());
        }
    }

    private static String getVersion(JSAnimal<? extends JSAnimalBase> jsAnimal) {
        float v = jsAnimal.getAnimalAttributes().getMiscProperties().getVersion();
        String version = v % 1.0f == 0.0f ? "v" + (int)v : "v" + String.valueOf(v).replaceAll("\\.?0+$", "");
        return version;
    }

    public boolean mouseScrolled(double x, double y, double sx, double sy) {
        int maxScroll = (int)JSAnimals.getAnimals().stream().filter(a -> a.getAnimalAttributes().getMiscProperties().isExtinct() && (this.currentSearch.isEmpty() || a.getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT).contains(this.currentSearch.toLowerCase(Locale.ROOT)))).count() - 4;
        if (sy < 0.0 && this.scrollOffset + 1 <= maxScroll) {
            ++this.scrollOffset;
        } else if (sy > 0.0 && this.scrollOffset - 1 >= 0) {
            --this.scrollOffset;
        }
        this.sliderYOffset = (int)Mth.lerp((float)((float)this.scrollOffset / (float)Math.max(1, maxScroll)), (float)0.0f, (float)70.0f);
        this.init();
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void renderBlurredBackground(float partialTick) {
    }
}

