/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.screen.obj.guidebook;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.JSTheme;
import jp.jurassicsaga.client.base.screen.obj.guidebook.GuidebookPage;
import jp.jurassicsaga.client.base.screen.obj.guidebook.obj.EntityInspectPage;
import jp.jurassicsaga.client.base.screen.obj.guidebook.obj.JournalPage;
import jp.jurassicsaga.client.base.screen.obj.widget.GuidebookTab;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GuidebookScreen
extends Screen {
    protected final JSTheme theme;
    private final int entityId;
    private String pageName = "journal";
    private static final String BASE_BG = "textures/gui/guidebook/background";
    private static final int WIDTH = 347;
    private static final int HEIGHT = 246;
    private static final Map<String, GuidebookPage> PAGES = new HashMap<String, GuidebookPage>();
    private final List<AbstractWidget> buttons = new ArrayList<AbstractWidget>();

    public GuidebookScreen(int id) {
        super((Component)Component.translatable((String)"js.screen.empty"));
        this.theme = JSCommon.config.theme;
        this.entityId = id;
        if (id != -1) {
            this.pageName = "entityInspect";
        }
        PAGES.put("entityInspect", new EntityInspectPage(this));
        PAGES.put("journal", new JournalPage(this));
        PAGES.put("help", new JournalPage(this));
    }

    private static ResourceLocation tex(boolean jp) {
        return ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)(BASE_BG + (jp ? "_jp" : "") + ".png"));
    }

    public void init() {
        super.init();
        int cx = this.width / 2;
        int cy = this.height / 2;
        this.buttons.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.buttons.clear();
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.init();
        }
        if (this.pageName.equals("entityInspect")) {
            this.addButton((AbstractWidget)new GuidebookTab(false, cx - 208, cy + 97, 25, 12, (Component)Component.empty(), press -> {
                this.pageName = "journal";
                this.init();
            }, JSCommon.createId("container/guidebook/arrow_left_hover" + (this.theme == JSTheme.JP ? "_jp" : "")), JSCommon.createId("container/guidebook/arrow_left" + (this.theme == JSTheme.JP ? "_jp" : ""))));
        } else {
            if (this.entityId != -1) {
                this.addButton((AbstractWidget)new GuidebookTab(false, cx - 208, cy - 103, 25, 12, (Component)Component.empty(), press -> {
                    this.pageName = "entityInspect";
                    this.init();
                }, JSCommon.createId("container/guidebook/arrow_right_hover" + (this.theme == JSTheme.JP ? "_jp" : "")), JSCommon.createId("container/guidebook/arrow_right" + (this.theme == JSTheme.JP ? "_jp" : ""))));
            }
            this.addButton((AbstractWidget)new GuidebookTab(false, cx - 205, cy + 94, 18, 18, (Component)Component.empty(), press -> {
                this.pageName = "help";
                this.init();
            }, JSCommon.createId("container/guidebook/search" + (this.theme == JSTheme.JP ? "_jp" : "")), JSCommon.createId("container/guidebook/search" + (this.theme == JSTheme.JP ? "_jp" : ""))));
        }
    }

    public void renderBackground(GuiGraphics g, int mouseX, int mouseY, float delta) {
        boolean jp = this.theme == JSTheme.JP;
        int cx = this.width / 2;
        int cy = this.height / 2;
        g.blit(GuidebookScreen.tex(jp), cx - 173, cy - 123, 0.0f, 0.0f, 347, 246, 347, 246);
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.render(cx, cy, g, mouseX, mouseY, delta);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void tick() {
        super.tick();
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.tick();
        }
    }

    public void setPage(String name) {
        this.pageName = name;
        this.init();
    }

    public boolean mouseScrolled(double x, double y, double sx, double sy) {
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.mouseScrolled(x, y, sx, sy);
        }
        return super.mouseScrolled(x, y, sx, sy);
    }

    public boolean keyPressed(int key, int scan, int mod) {
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.keyPressed(key, scan, mod);
        }
        return super.keyPressed(key, scan, mod);
    }

    public boolean keyReleased(int key, int scan, int mod) {
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.keyReleased(key, scan, mod);
        }
        return super.keyReleased(key, scan, mod);
    }

    public boolean charTyped(char code, int mod) {
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.charTyped(code, mod);
        }
        return super.charTyped(code, mod);
    }

    public Font getFont() {
        return this.font;
    }

    public void addButton(AbstractWidget button) {
        this.addRenderableWidget((GuiEventListener)button);
        this.buttons.add(button);
    }

    public JSTheme getTheme() {
        return this.theme;
    }

    public int getEntityId() {
        return this.entityId;
    }
}

