/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.screen.obj.guidebook.obj;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.JSTheme;
import jp.jurassicsaga.client.base.screen.obj.guidebook.GuidebookPage;
import jp.jurassicsaga.client.base.screen.obj.guidebook.GuidebookScreen;
import jp.jurassicsaga.client.base.screen.obj.guidebook.obj.JournalSubPage;
import jp.jurassicsaga.client.base.screen.obj.widget.NoClickHoverClickButton;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diet;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

public class JournalPage
extends GuidebookPage {
    private int size = 0;
    private JournalSubPage currentSubPage;
    private final ArrayList<JSAnimal<?>> animals;
    private int currentPageId = 0;
    private List<ItemStack> stacks = null;
    private int scrollOffset = 0;
    private int scrollTicker = 0;

    public JournalPage(GuidebookScreen holder) {
        super(holder);
        for (JSAnimal<?> animal : JSAnimals.getAnimals()) {
            if (!animal.getAnimalAttributes().getMiscProperties().isShowInGuidebook()) continue;
            ++this.size;
        }
        this.animals = JSAnimals.getAnimals();
    }

    @Override
    public void init() {
        int i = this.holder.width / 2;
        int j = this.holder.height / 2;
        if (this.currentPageId + 1 < this.size + 1) {
            this.holder.addButton((AbstractWidget)new NoClickHoverClickButton(i - 8 + 148, j - 8 + 105, 25, 12, (Component)Component.empty(), press -> {
                if (this.currentSubPage != null) {
                    this.currentSubPage = null;
                }
                ++this.currentPageId;
                this.holder.init();
            }, JSCommon.createId("container/guidebook/arrow_right_hover" + (this.theme == JSTheme.JP ? "_jp" : "")), JSCommon.createId("container/guidebook/arrow_right" + (this.theme == JSTheme.JP ? "_jp" : ""))));
        }
        if (this.currentPageId - 1 >= 0) {
            this.holder.addButton((AbstractWidget)new NoClickHoverClickButton(i - 8 - 157, j - 8 + 105, 25, 12, (Component)Component.empty(), press -> {
                if (this.currentSubPage != null) {
                    this.currentSubPage = null;
                }
                --this.currentPageId;
                this.holder.init();
            }, JSCommon.createId("container/guidebook/arrow_left_hover" + (this.theme == JSTheme.JP ? "_jp" : "")), JSCommon.createId("container/guidebook/arrow_left" + (this.theme == JSTheme.JP ? "_jp" : ""))));
        }
        if (this.currentSubPage != null) {
            this.currentSubPage.init();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.currentPageId != 0 && this.stacks != null) {
            this.tickHorizontalScrolling();
        }
    }

    private void tickHorizontalScrolling() {
        int cols = 8;
        int rows = 3;
        int visibleCount = cols * rows;
        int maxOffset = Math.max(0, this.stacks.size() - visibleCount);
        ++this.scrollTicker;
        if (this.scrollTicker > 20) {
            this.scrollTicker = 0;
            ++this.scrollOffset;
            if (this.scrollOffset > maxOffset) {
                this.scrollOffset = 0;
            }
        }
    }

    @Override
    public void render(int i, int j, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.currentPageId == 0) {
            Font font = this.holder.getFont();
            guiGraphics.drawString(font, (Component)Component.translatable((String)"guidebook.jurassicsaga.page_home"), i - 153, j - 102, 6980223);
            guiGraphics.drawWordWrap(font, (FormattedText)Component.translatable((String)"guidebook.jurassicsaga.home"), i - 155, j - 80, 142, 6980223);
        } else {
            if (this.currentSubPage == null) {
                JSAnimal animal = this.animals.stream().filter(jsAnimal -> jsAnimal.getAnimalAttributes().getMiscProperties().isShowInGuidebook()).toList().get(this.currentPageId - 1);
                this.currentSubPage = new JournalSubPage(this.holder, animal);
                Supplier<Diet> dietSupplier = animal.getAnimalAttributes().getMetabolismProperties().getDietSupplier();
                if (dietSupplier != Diets.EMPTY) {
                    Diet diet = dietSupplier.get();
                    this.stacks = diet.getAllItems().stream().sorted(Comparator.comparing(item -> item.getItem().getName(item).getString())).toList();
                } else {
                    this.stacks = null;
                }
                this.init();
            }
            this.currentSubPage.render(i, j, guiGraphics, mouseX, mouseY, partialTick);
            if (this.stacks != null) {
                guiGraphics.drawString(this.holder.getFont(), (Component)Component.translatable((String)"guidebook.jurassicsaga.edible_items"), i + 21, j + 35, 6980223);
                this.renderWrappedItems(guiGraphics, i + 20, j + 45, mouseX, mouseY);
            }
        }
    }

    private void renderWrappedItems(GuiGraphics guiGraphics, int startX, int startY, int mouseX, int mouseY) {
        int itemSize = 16;
        int cols = 8;
        int rows = 3;
        int visibleCount = cols * rows;
        int maxOffset = Math.max(0, this.stacks.size() - visibleCount);
        if (this.scrollOffset > maxOffset) {
            this.scrollOffset = maxOffset;
        }
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int index = this.scrollOffset + col + row * cols;
                if (index >= this.stacks.size()) {
                    return;
                }
                int x = startX + col * itemSize;
                int y = startY + row * itemSize;
                ItemStack stack = this.stacks.get(index);
                guiGraphics.renderItem(stack, x, y);
                guiGraphics.renderItemDecorations(this.holder.getFont(), stack, x, y);
                if (mouseX < x || mouseX >= x + itemSize || mouseY < y || mouseY >= y + itemSize) continue;
                guiGraphics.renderTooltip(this.holder.getFont(), stack, mouseX, mouseY);
            }
        }
    }
}

