/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.screen.obj.guidebook.obj;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.client.base.screen.obj.guidebook.GuidebookPage;
import jp.jurassicsaga.client.base.screen.obj.guidebook.GuidebookScreen;
import jp.jurassicsaga.client.base.screen.obj.widget.EmptyButton;
import jp.jurassicsaga.client.base.screen.obj.widget.NoClickHoverClickButton;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.JSCosmeticGene;
import mod.azure.azurelib.common.animation.dispatch.command.AzCommand;
import mod.azure.azurelib.common.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelib.common.animation.play_behavior.AzPlayBehaviors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import travelers.server.animal.obj.TravelersAnimalAttributes;

public class JournalSubPage
extends GuidebookPage {
    private final JSAnimal<?> animal;
    private final boolean shouldHaveBaby;
    private JSAnimalBase entity;
    private JSAnimalBase entity_baby;

    public JournalSubPage(GuidebookScreen holder, JSAnimal<?> animal) {
        super(holder);
        this.animal = animal;
        this.shouldHaveBaby = animal.getAnimalAttributes().getMiscProperties().isHasBabyGuidebook();
    }

    @Override
    public void init() {
        int i = this.holder.width / 2;
        int j = this.holder.height / 2;
        this.holder.addButton((AbstractWidget)new NoClickHoverClickButton(i - 8 - 133, j - 22, 18, 18, (Component)Component.empty(), press -> {
            this.entity.getModules().getGeneticModule().setMale(true);
            this.holder.init();
        }, JSCommon.createId("container/guidebook/male"), JSCommon.createId("container/guidebook/male")));
        this.holder.addButton((AbstractWidget)new NoClickHoverClickButton(i - 8 - 148, j - 22, 18, 18, (Component)Component.empty(), press -> {
            this.entity.getModules().getGeneticModule().setMale(false);
            this.holder.init();
        }, JSCommon.createId("container/guidebook/female"), JSCommon.createId("container/guidebook/female")));
        if (this.entity == null || this.entity.getModules() == null) {
            return;
        }
        if (!((String)this.entity.getEntityData().get(JSEntityDataHolder.textureVariant)).equals(JSVariants.NONE.getName())) {
            this.holder.addButton((AbstractWidget)new NoClickHoverClickButton(i - 8 - 115, j - 22, 18, 18, (Component)Component.empty(), press -> {
                this.entity.getEntityData().set(JSEntityDataHolder.textureVariant, (Object)JSVariants.NONE.getName());
                this.holder.init();
            }, JSCommon.createId("container/guidebook/x_symbol"), JSCommon.createId("container/guidebook/x_symbol")));
        }
        int offsetX = 0;
        int offsetY = 0;
        for (JSGene supportedGene : this.animal.getAnimalAttributes().getGeneticProperties().getSupportedGenes()) {
            if (!(supportedGene instanceof JSCosmeticGene)) continue;
            JSCosmeticGene cosmeticGene = (JSCosmeticGene)supportedGene;
            this.holder.addButton((AbstractWidget)new EmptyButton(i - 150 + offsetX, j + offsetY, 16, 16, (Component)Component.empty(), a -> {
                this.entity.getEntityData().set(JSEntityDataHolder.textureVariant, (Object)cosmeticGene.getVariant().getName());
                this.holder.init();
            }));
            if ((offsetX += 20) < 140) continue;
            offsetX = 0;
            offsetY += 20;
        }
    }

    @Override
    public void render(int i, int j, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.entity == null || this.entity_baby == null && this.shouldHaveBaby) {
            this.entity = (JSAnimalBase)((EntityType)this.animal.getEntityType().get()).create((Level)Minecraft.getInstance().level);
            this.entity_baby = this.shouldHaveBaby ? (JSAnimalBase)((EntityType)this.animal.getEntityType().get()).create((Level)Minecraft.getInstance().level) : null;
            this.holder.init();
            return;
        }
        try {
            AzCommand.createRoot((String)"animation.guidebook_pose", (AzPlayBehavior)AzPlayBehaviors.HOLD_ON_LAST_FRAME, (float)99.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (boolean)false).sendForEntity((Entity)this.entity);
            if (this.shouldHaveBaby) {
                if (!this.animal.getAnimalAttributes().getMiscProperties().isBabyAnimations()) {
                    AzCommand.createRoot((String)"animation.guidebook_baby_pose", (AzPlayBehavior)AzPlayBehaviors.HOLD_ON_LAST_FRAME, (float)99.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (boolean)false).sendForEntity((Entity)this.entity_baby);
                } else {
                    AzCommand.createRoot((String)"animation.guidebook_pose", (AzPlayBehavior)AzPlayBehaviors.HOLD_ON_LAST_FRAME, (float)99.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (boolean)false).sendForEntity((Entity)this.entity_baby);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TravelersAnimalAttributes attributes = this.animal.getAnimalAttributes();
        this.entity.getModules().getGrowthStageModule().setMax();
        if (this.shouldHaveBaby) {
            this.entity_baby.getModules().getGrowthStageModule().setGrowthStage(AnimalGrowthStage.BABY);
        }
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        PoseStack poseStack = guiGraphics.pose();
        float scale_baby = attributes.getMiscProperties().getGuidebookScaling()[0];
        float scale = attributes.getMiscProperties().getGuidebookScaling()[1];
        float offset_baby_z = attributes.getMiscProperties().getGuidebookOffset()[0].x;
        float offset_baby_y = attributes.getMiscProperties().getGuidebookOffset()[0].y;
        float offset_z = attributes.getMiscProperties().getGuidebookOffset()[1].x;
        float offset_y = attributes.getMiscProperties().getGuidebookOffset()[1].y;
        if (this.shouldHaveBaby) {
            poseStack.pushPose();
            poseStack.translate((float)(i - 65), (float)(j - 20), 100.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            poseStack.scale(21.0f * scale_baby, -21.0f * scale_baby, 21.0f * scale_baby);
            poseStack.translate(1.0f, offset_baby_y, offset_baby_z);
            Minecraft.getInstance().getEntityRenderDispatcher().render((Entity)this.entity_baby, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, (MultiBufferSource)buffer, 0xF000F0);
            poseStack.popPose();
        }
        poseStack.pushPose();
        poseStack.translate((float)(i - 65), (float)(j - 20), 100.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.scale(21.0f * scale, -21.0f * scale, 21.0f * scale);
        poseStack.translate(0.0f, offset_y, offset_z);
        Minecraft.getInstance().getEntityRenderDispatcher().render((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, (MultiBufferSource)buffer, 0xF000F0);
        poseStack.popPose();
        buffer.endBatch();
        Font font = this.holder.getFont();
        guiGraphics.drawString(font, (Component)Component.translatable((String)("entity." + attributes.getModId() + "." + attributes.getAnimalName())), i - 153, j - 102, 6980223);
        guiGraphics.drawString(font, (Component)Component.translatable((String)("guidebook." + attributes.getModId() + "." + attributes.getAnimalName() + ".scientific_name")), i + 21, j - 102, 6980223);
        guiGraphics.drawString(font, (Component)Component.translatable((String)("guidebook." + attributes.getModId() + "." + attributes.getAnimalName() + ".source")), i + 21, j + 102, 6980223);
        guiGraphics.drawWordWrap(font, (FormattedText)Component.translatable((String)("guidebook." + attributes.getModId() + "." + attributes.getAnimalName() + ".description")), i + 21, j - 80, 134, 6980223);
        this.renderVariantShowcase(i, j, guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderVariantShowcase(int i, int j, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int offsetX = 0;
        int offsetY = 0;
        for (JSGene supportedGene : this.animal.getAnimalAttributes().getGeneticProperties().getSupportedGenes()) {
            if (!(supportedGene instanceof JSCosmeticGene)) continue;
            JSCosmeticGene gene = (JSCosmeticGene)supportedGene;
            Supplier<Item> item = JSGenetics.GENE_ITEMS.get(gene);
            int x = i - 150 + offsetX;
            int y = j + offsetY;
            guiGraphics.renderItem(((Item)item.get()).getDefaultInstance(), x, y);
            guiGraphics.renderItemDecorations(this.holder.getFont(), ((Item)item.get()).getDefaultInstance(), x, y);
            if (mouseX > x && mouseX < x + 16 && mouseY > y && mouseY < y + 16) {
                guiGraphics.renderTooltip(this.holder.getFont(), ((Item)item.get()).getDefaultInstance(), mouseX, mouseY);
            }
            if ((offsetX += 20) < 140) continue;
            offsetX = 0;
            offsetY += 20;
        }
    }

    public JSAnimal<?> getAnimal() {
        return this.animal;
    }
}

