/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.screen.obj.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SliderButton
extends Button {
    private final double minValue;
    private final double maxValue;
    private double currentValue;
    private boolean dragging;
    private final ResourceLocation sliderIcon;
    private static final int HANDLE_WIDTH = 4;
    private static final int HANDLE_HEIGHT = 8;
    private final Button.OnPress updatePos;

    public SliderButton(Button.OnPress updatePos, int x, int y, int width, int height, double minValue, double maxValue, double initial, Component message, ResourceLocation sliderIcon, Button.OnPress onPress) {
        super(x, y, width, height, message, onPress, DEFAULT_NARRATION);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.currentValue = initial;
        this.sliderIcon = sliderIcon;
        this.updatePos = updatePos;
    }

    public double getValue() {
        return this.currentValue;
    }

    private void updateValue(double mouseX) {
        double relativeX = mouseX - (double)this.getX() - 2.0;
        double effectiveWidth = this.width - 4;
        double percent = relativeX / effectiveWidth;
        percent = Math.max(0.0, Math.min(1.0, percent));
        this.currentValue = this.minValue + (this.maxValue - this.minValue) * percent;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        double percent = (this.currentValue - this.minValue) / (this.maxValue - this.minValue);
        int handleX = (int)((double)this.getX() + percent * (double)(this.width - 4));
        int handleY = this.getY() + (this.height - 8) / 2;
        guiGraphics.blit(this.sliderIcon, handleX, handleY, 0.0f, 0.0f, 4, 8, 4, 8);
        if (this.dragging) {
            this.updateValue(mouseX);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.active && this.visible && mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)(this.getX() + this.width) && mouseY < (double)(this.getY() + this.height)) {
            this.dragging = true;
            this.updateValue(mouseX);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.dragging = false;
        this.updatePos.onPress((Button)this);
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging) {
            this.updateValue(mouseX);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }
}

