/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.v1.animation;

import java.util.Objects;
import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import mod.azure.azurelib.common.animation.AzAnimator;
import mod.azure.azurelib.common.animation.AzAnimatorAccessor;
import mod.azure.azurelib.common.animation.controller.AzAnimationController;
import mod.azure.azurelib.common.animation.primitive.AzQueuedAnimation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.client.render.animation.entity.TravelersAnimationData;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.animation.TravelersAnimationDefinition;

public class JSAnimationData
extends TravelersAnimationData {
    private AzAnimator<?, ?> animatorCache;
    @Nullable
    private AzAnimationController<?> controllerCache;
    private String lastAnimationName;
    protected boolean canFace;
    protected Vec3 prevVel = Vec3.ZERO;
    protected float tiltPitch = 0.0f;
    protected float tiltRoll = 0.0f;
    protected float targetPitch = 0.0f;
    protected float targetRoll = 0.0f;
    protected float lastYaw;

    protected void updateAnimatorStatus(SmartAnimalBase base) {
        if (this.animatorCache == null) {
            this.animatorCache = AzAnimatorAccessor.getOrNull((Object)base);
        }
        if (this.animatorCache == null) {
            return;
        }
        if (this.controllerCache == null) {
            this.controllerCache = this.animatorCache.getAnimationControllerContainer().getOrNull("base_controller");
        }
        if (this.controllerCache == null) {
            return;
        }
        AzQueuedAnimation current = this.controllerCache.currentAnimation();
        if (current == null || current.animation() == null) {
            return;
        }
        String name = current.animation().name();
        if (Objects.equals(name, this.lastAnimationName)) {
            return;
        }
        this.lastAnimationName = name;
        TravelersAnimationDefinition def = JSAnimations.getAnimation(name);
        if (def != null) {
            this.canFace = def.isCanLook();
            this.physicsEnabled = def.isPhysicsEnabled();
        }
    }
}

