/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.v1.screen.machine;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import jp.jurassicsaga.JSTheme;
import jp.jurassicsaga.client.base.screen.obj.machine.GenericScreen;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import jp.jurassicsaga.server.base.item.obj.egg.GenderSpawnEgg;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import jp.jurassicsaga.server.v1.menu.obj.machine.DnaModifierMachineMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DnaModifierMachineScreen
extends GenericScreen<DnaModifierMachineMenu> {
    private static final String BASE_CONTAINER = "textures/gui/container/machine/dna_combinator_gui";
    private static final String BASE_SPRITE = "textures/gui/sprites/machine/dna_modifier/";
    private static final int STEP1_END = 3250;
    private static final int STEP2_END = 6500;
    private static final int FINAL_STEP_END = 6500;
    private float smoothProgress = 0.0f;
    private Entity entity;
    private ItemStack coin;
    private JSGeneData curData;
    private float animalScale = 1.0f;
    private AbstractClientPlayer playerScale;

    public DnaModifierMachineScreen(DnaModifierMachineMenu menu, Inventory inv, Component title) {
        super(menu, inv, title);
        this.titleLabelY = 4;
        this.inventoryLabelY = -5000;
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType clickType) {
        super.slotClicked(slot, slotId, mouseButton, clickType);
    }

    private ResourceLocation tex(String path, boolean jp) {
        return ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)(path + (jp ? "_jp" : "") + ".png"));
    }

    protected void renderBg(GuiGraphics g, float partialTick, int mouseX, int mouseY) {
        boolean jp = this.theme == JSTheme.JP;
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        g.blit(this.tex(BASE_CONTAINER, jp), x - 33, y - 28, 0, 0, 240, 194);
        int realProgress = ((DnaModifierMachineMenu)this.menu).getData().get(0);
        this.smoothProgress = this.lerp(this.smoothProgress, realProgress, 0.2f);
        if (realProgress <= 0) {
            this.renderPreview(g, partialTick, mouseX, mouseY);
            return;
        }
        g.blit(this.tex("textures/gui/sprites/machine/dna_modifier/step_1", jp), x + 3, y + 5, 0.0f, 0.0f, 12, this.getScaled(this.smoothProgress, 0, 3250, 11), 12, 11);
        g.blit(this.tex("textures/gui/sprites/machine/dna_modifier/step_2", jp), x + 3, y + 36, 0.0f, 0.0f, 12, this.getScaled(this.smoothProgress, 3250, 6500, 11), 12, 11);
    }

    private void renderPreview(GuiGraphics g, float partialTick, int mouseX, int mouseY) {
        LivingEntity living;
        Minecraft mc;
        block16: {
            block15: {
                GenderSpawnEgg egg;
                JSGeneData coinData;
                ItemStack currentCoin;
                mc = Minecraft.getInstance();
                ClientLevel level = mc.level;
                if (level == null) {
                    return;
                }
                if (this.coin == null) {
                    this.coin = (ItemStack)((DnaModifierMachineMenu)this.menu).getItems().getFirst();
                    return;
                }
                if (this.curData == null) {
                    this.curData = JSGeneUtil.readFromStack(this.coin);
                }
                if ((currentCoin = (ItemStack)((DnaModifierMachineMenu)this.menu).getItems().getFirst()) != null && !this.curData.isSameAs(coinData = JSGeneUtil.readFromStack(currentCoin))) {
                    this.coin = currentCoin;
                    this.entity = null;
                    this.curData = coinData;
                }
                EntityType type = null;
                Item item = this.coin.getItem();
                if (item instanceof DnaItem) {
                    DnaItem dna = (DnaItem)item;
                    type = (EntityType)dna.getAnimal().getEntityType().get();
                } else {
                    item = this.coin.getItem();
                    if (item instanceof GenderSpawnEgg) {
                        egg = (GenderSpawnEgg)item;
                        type = (EntityType)egg.getAnimal().getEntityType().get();
                    }
                }
                if (type == null) {
                    this.entity = null;
                    return;
                }
                if (this.entity == null || this.entity.getType() != type) {
                    this.entity = type.create((Level)level);
                    egg = this.entity;
                    if (egg instanceof JSAnimalBase) {
                        JSAnimalBase base = (JSAnimalBase)((Object)egg);
                        base.getModules().getGeneticModule().setGeneData(JSGeneUtil.fromCompound((CompoundTag)this.coin.getOrDefault((DataComponentType)JSDataComponents.GENE_DATA.get(), (Object)new CompoundTag())));
                        base.getModules().getGrowthStageModule().setMax();
                        base.setBoundingBox(base.getModules().getGrowthStageModule().makeBoundingBox((JSAnimal<?>)base.getAnimal()));
                        this.animalScale = base.getAnimal().getAnimalAttributes().getMiscProperties().getMachineScale();
                    }
                }
                if (this.playerScale == null) {
                    GameProfile info = new GameProfile(mc.player.getUUID(), mc.player.getName().getString());
                    this.playerScale = new RemotePlayer(level, info);
                }
                if (!((egg = this.entity) instanceof LivingEntity)) break block15;
                living = (LivingEntity)egg;
                if (this.playerScale != null) break block16;
            }
            return;
        }
        float rot = 180.0f;
        for (LivingEntity e : new LivingEntity[]{this.playerScale, living}) {
            e.setYRot(rot);
            e.yBodyRot = rot;
            e.yHeadRot = rot;
        }
        float playerH = this.playerScale.getBbHeight();
        float entityH = living.getBbHeight();
        float maxH = Math.max(playerH, entityH);
        float scale = 35.0f / maxH;
        scale *= this.animalScale;
        PoseStack pose = g.pose();
        MultiBufferSource.BufferSource buf = mc.renderBuffers().bufferSource();
        int left = (this.width - this.imageWidth) / 2;
        int top = (this.height - this.imageHeight) / 2;
        int boxX = left + 28;
        int boxY = top - 23;
        int boxW = 123;
        int boxH = 96;
        double guiScale = mc.getWindow().getGuiScale();
        int sx = (int)((double)boxX * guiScale);
        int sy = (int)((double)(mc.getWindow().getGuiScaledHeight() - (boxY + boxH)) * guiScale);
        int sw = (int)((double)boxW * guiScale);
        int sh = (int)((double)boxH * guiScale);
        RenderSystem.enableScissor((int)sx, (int)sy, (int)sw, (int)sh);
        int centerXLeft = boxX + boxW / 3;
        int centerXRight = boxX + 2 * boxW / 3;
        int groundY = boxY + boxH;
        pose.pushPose();
        pose.translate((float)centerXLeft, (float)groundY, 100.0f);
        pose.mulPose(Axis.YP.rotationDegrees(90.0f));
        pose.scale(scale, -scale, scale);
        mc.getEntityRenderDispatcher().render((Entity)this.playerScale, 0.0, 0.0, 0.0, 0.0f, 0.0f, pose, (MultiBufferSource)buf, 0xF000F0);
        pose.popPose();
        pose.pushPose();
        pose.translate((float)centerXRight, (float)groundY, 100.0f);
        pose.mulPose(Axis.YN.rotationDegrees(90.0f));
        pose.scale(scale, -scale, scale);
        mc.getEntityRenderDispatcher().render((Entity)living, 0.0, 0.0, 0.0, 0.0f, 0.0f, pose, (MultiBufferSource)buf, 0xF000F0);
        pose.popPose();
        buf.endBatch();
        RenderSystem.disableScissor();
    }

    private int getScaled(float progress, int start, int end, int size) {
        if (progress <= (float)start) {
            return 0;
        }
        if (progress >= (float)end) {
            return size;
        }
        return (int)((progress - (float)start) * (float)size / (float)(end - start));
    }

    private float lerp(float a, float b, float alpha) {
        return a + (b - a) * alpha;
    }

    @Override
    public void render(GuiGraphics g, int mouseX, int mouseY, float delta) {
        super.render(g, mouseX, mouseY, delta);
        this.renderTooltip(g, mouseX, mouseY);
    }
}

