/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.v1.screen.machine;

import jp.jurassicsaga.JSTheme;
import jp.jurassicsaga.client.base.screen.obj.machine.GenericScreen;
import jp.jurassicsaga.server.v1.menu.obj.machine.IncubatorMachineMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class IncubatorMachineScreen
extends GenericScreen<IncubatorMachineMenu> {
    private static final String BASE_CONTAINER = "textures/gui/container/machine/incubator_gui";
    private static final int WIDTH = 177;
    private static final int HEIGHT = 193;

    public IncubatorMachineScreen(IncubatorMachineMenu menu, Inventory inv, Component title) {
        super(menu, inv, title);
    }

    private static ResourceLocation tex(boolean jp) {
        return ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)(BASE_CONTAINER + (jp ? "_jp" : "") + ".png"));
    }

    protected void renderBg(GuiGraphics g, float partialTick, int mouseX, int mouseY) {
        boolean jp = this.theme == JSTheme.JP;
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        g.blit(IncubatorMachineScreen.tex(jp), x - 1, y, 0, 0, 177, 193);
        this.drawProgress(g, 1, x + 81, y + 12);
        this.drawProgress(g, 2, x + 117, y + 64);
        this.drawProgress(g, 3, x + 45, y + 64);
        this.drawProgress(g, 4, x + 43, y + 18);
        this.drawProgress(g, 5, x + 119, y + 18);
    }

    private void drawProgress(GuiGraphics g, int index, int x, int y) {
        int progress = ((IncubatorMachineMenu)this.menu).getData().get(index);
        int max = ((IncubatorMachineMenu)this.menu).getData().get(0);
        if (progress <= 0 || max <= 0) {
            return;
        }
        int percent = (int)(100.0 * (double)progress / (double)max);
        g.drawString(this.font, (Component)Component.literal((String)(percent + "%")), x, y, 0xFFFFFF);
    }

    @Override
    public void render(GuiGraphics g, int mouseX, int mouseY, float delta) {
        super.render(g, mouseX, mouseY, delta);
        this.renderTooltip(g, mouseX, mouseY);
    }
}

