/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.v2.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import jp.jurassicsaga.server.v2.block.entity.obj.WireBlockEntity;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WireBlockEntityRenderer
implements BlockEntityRenderer<WireBlockEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)"textures/block/cable.png");

    public WireBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(WireBlockEntity wire, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (wire.getConnectionCenters().isEmpty()) {
            return;
        }
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE));
        Vec3 start = Vec3.atCenterOf((Vec3i)wire.getBlockPos());
        for (Vec3 end : wire.getConnectionCenters()) {
            Vec3 dir = end.subtract(start);
            this.renderCableSegment(poseStack, vertexConsumer, dir, packedLight);
        }
    }

    private void renderCableSegment(PoseStack poseStack, VertexConsumer vertexConsumer, Vec3 dir, int packedLight) {
        float radius = 0.05f;
        float len = (float)dir.length();
        Vec3 norm = dir.normalize();
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        Vector3f axis = new Vector3f((float)norm.x, (float)norm.y, (float)norm.z);
        Quaternionf rotation = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)axis);
        poseStack.mulPose(rotation);
        PoseStack.Pose mat = poseStack.last();
        int blockLight = LightTexture.block((int)packedLight);
        int skyLight = LightTexture.sky((int)packedLight);
        this.addFace(vertexConsumer, mat, -radius, 0.0f, -radius, radius, 0.0f, -radius, radius, len, -radius, -radius, len, -radius, blockLight, skyLight, new Vector3f(0.0f, 0.0f, -1.0f));
        this.addFace(vertexConsumer, mat, radius, 0.0f, radius, -radius, 0.0f, radius, -radius, len, radius, radius, len, radius, blockLight, skyLight, new Vector3f(0.0f, 0.0f, 1.0f));
        this.addFace(vertexConsumer, mat, -radius, 0.0f, radius, -radius, 0.0f, -radius, -radius, len, -radius, -radius, len, radius, blockLight, skyLight, new Vector3f(-1.0f, 0.0f, 0.0f));
        this.addFace(vertexConsumer, mat, radius, 0.0f, -radius, radius, 0.0f, radius, radius, len, radius, radius, len, -radius, blockLight, skyLight, new Vector3f(1.0f, 0.0f, 0.0f));
        this.addFace(vertexConsumer, mat, -radius, len, -radius, radius, len, -radius, radius, len, radius, -radius, len, radius, blockLight, skyLight, new Vector3f(0.0f, 1.0f, 0.0f));
        this.addFace(vertexConsumer, mat, -radius, 0.0f, radius, radius, 0.0f, radius, radius, 0.0f, -radius, -radius, 0.0f, -radius, blockLight, skyLight, new Vector3f(0.0f, -1.0f, 0.0f));
        poseStack.popPose();
    }

    private void addFace(VertexConsumer v, PoseStack.Pose m, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, int blockLight, int skyLight, Vector3f normal) {
        int color = -1;
        v.addVertex(m, x1, y1, z1).setColor(color).setUv(0.0f, 0.0f).setUv1(0, 0).setUv2(blockLight, skyLight).setNormal(m, normal.x(), normal.y(), normal.z());
        v.addVertex(m, x2, y2, z2).setColor(color).setUv(1.0f, 0.0f).setUv1(0, 0).setUv2(blockLight, skyLight).setNormal(m, normal.x(), normal.y(), normal.z());
        v.addVertex(m, x3, y3, z3).setColor(color).setUv(1.0f, 1.0f).setUv1(0, 0).setUv2(blockLight, skyLight).setNormal(m, normal.x(), normal.y(), normal.z());
        v.addVertex(m, x4, y4, z4).setColor(color).setUv(0.0f, 1.0f).setUv1(0, 0).setUv2(blockLight, skyLight).setNormal(m, normal.x(), normal.y(), normal.z());
    }
}

