/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.v2.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.client.v2.model.BasicWireModel;
import jp.jurassicsaga.server.v2.entity.obj.FenceCable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CableRenderer
extends EntityRenderer<FenceCable> {
    private static final ResourceLocation TEXTURE = JSCommon.createId("textures/entity/fence_cable.png");
    protected EntityModel<FenceCable> actualModel;

    public CableRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.actualModel = new BasicWireModel(context.bakeLayer(BasicWireModel.LAYER_LOCATION));
    }

    public void render(FenceCable entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        BlockPos b1 = entity.getLink1();
        BlockPos b2 = entity.getLink2();
        if (b1 == null || b2 == null) {
            return;
        }
        Vec3 start = b1.getCenter();
        Vec3 end = b2.getCenter();
        Vec3 diff = end.subtract(start);
        float distance = (float)diff.length();
        if (distance < 1.0E-4f) {
            return;
        }
        float MODEL_Z_UNITS = 8.0f;
        float modelBaseLenBlocks = 0.5f;
        float scaleZ = distance / 0.5f;
        poseStack.pushPose();
        poseStack.translate(0.0, 0.15, 0.0);
        poseStack.translate(0.0f, -0.03125f, 0.0f);
        float yaw = (float)(Math.atan2(diff.x, diff.z) * 57.2957763671875);
        float pitch = (float)(-Math.asin(diff.y / (double)distance) * 57.2957763671875);
        poseStack.mulPose(Axis.YP.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.translate(0.0f, 0.0f, -distance / 2.0f);
        poseStack.scale(1.0f, 1.0f, scaleZ);
        VertexConsumer vc = buffer.getBuffer(RenderType.entitySolid((ResourceLocation)TEXTURE));
        this.actualModel.renderToBuffer(poseStack, vc, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull FenceCable entity) {
        return TEXTURE;
    }
}

