/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.mixin.client.gui;

import java.util.Optional;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementTab;
import net.minecraft.client.gui.screens.advancements.AdvancementWidget;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AdvancementTab.class})
public class AdvancementGuiMixin {
    @Shadow
    private boolean centered;
    @Shadow
    private double scrollX;
    @Shadow
    private double scrollY;
    @Shadow
    private int maxX;
    @Shadow
    private int minY;
    @Shadow
    @Final
    private DisplayInfo display;
    @Shadow
    @Final
    private AdvancementWidget root;
    @Shadow
    private int minX;
    @Shadow
    private int maxY;

    @Inject(at={@At(value="HEAD")}, method={"drawContents"}, cancellable=true)
    public void drawContents(GuiGraphics guiGraphics, int x, int y, CallbackInfo ci) {
        Optional bg = this.display.getBackground();
        if (bg.isPresent() && ((ResourceLocation)bg.get()).getNamespace().equalsIgnoreCase("jurassicsaga")) {
            if (!this.centered) {
                this.scrollX = 117.0 - (double)(this.maxX + this.minX) / 2.0;
                this.scrollY = 56.0 - (double)(this.maxY + this.minY) / 2.0;
                this.centered = true;
            }
            guiGraphics.enableScissor(x, y, x + 234, y + 113);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)x, (float)y, 0.0f);
            ResourceLocation resourcelocation = this.display.getBackground().orElse(TextureManager.INTENTIONAL_MISSING_TEXTURE);
            int i = Mth.floor((double)this.scrollX);
            int j = Mth.floor((double)this.scrollY);
            guiGraphics.blit(resourcelocation, 0, 0, 0.0f, 0.0f, 234, 113, 234, 113);
            this.root.drawConnectivity(guiGraphics, i, j, true);
            this.root.drawConnectivity(guiGraphics, i, j, false);
            this.root.draw(guiGraphics, i, j);
            guiGraphics.pose().popPose();
            guiGraphics.disableScissor();
            ci.cancel();
        }
    }
}

