/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.neo.data.GatherData;
import jp.jurassicsaga.neo.server.JSNeoMenus;
import jp.jurassicsaga.neo.server.JSNeoTreeGrowers;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSHerdModule;
import jp.jurassicsaga.server.base.entity.JSEntities;
import jp.jurassicsaga.server.base.entity.obj.egg.EggEntity;
import jp.jurassicsaga.server.base.generic.networking.JSNetworking;
import jp.jurassicsaga.server.base.item.obj.egg.BasicSpawnEgg;
import jp.jurassicsaga.server.base.item.obj.egg.GenderSpawnEgg;
import jp.jurassicsaga.server.base.world.terrablender.JSTerrablender;
import jp.jurassicsaga.server.v1.animal.JSV1Animals;
import jp.jurassicsaga.server.v1.animal.entity.extant.AlligatorEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.BasiliskEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.BonitoEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.MosquitoEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.ReedFrogEntity;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;
import travelers.server.packet.TravelersPackets;
import travelers.util.helper.PlatformHelper;

@Mod(value="jurassicsaga")
public class JSMod {
    public JSMod(IEventBus modEventBus, ModContainer modContainer) {
        JSCommon.init();
        modEventBus.addListener(GatherData::gatherData);
    }

    @EventBusSubscriber(modid="jurassicsaga", bus=EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                GenderSpawnEgg.registerDispense();
                BasicSpawnEgg.registerDispense();
                JSV1Blocks.ARAUCARIOXYLON.init();
                JSV1Blocks.GORDONPTERIS.init();
                JSV1Blocks.LEPIDODENDRON.init();
                JSV1Blocks.SPINIFRUCTUS.init();
                JSV2Blocks.DOG_WOOD.init();
                if (PlatformHelper.properties.isModLoaded("terrablender")) {
                    JSTerrablender.init();
                }
            });
        }

        @SubscribeEvent
        public static void registerPayloadHandlersEvent(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            for (TravelersPackets.TravelerPacket travelerPacket : JSNetworking.PACKET_HOLDER) {
                registrar.commonBidirectional(travelerPacket.type(), travelerPacket.reader(), (IPayloadHandler)new DirectionalPayloadHandler((packetPayload, iPayloadContext) -> travelerPacket.packetsHandler().clientPacket(packetPayload), (packetPayload, iPayloadContext) -> travelerPacket.packetsHandler().serverPacket(packetPayload)));
            }
        }

        @SubscribeEvent
        public static void registerSpawns(@NotNull RegisterSpawnPlacementsEvent event) {
            event.register((EntityType)JSV1Animals.ALLIGATOR.getEntityType().get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.OCEAN_FLOOR, AlligatorEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
            event.register((EntityType)JSV1Animals.MOSQUITO.getEntityType().get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MosquitoEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
            event.register((EntityType)JSV1Animals.BONITO.getEntityType().get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.OCEAN_FLOOR, BonitoEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
            event.register((EntityType)JSV1Animals.REED_FROG.getEntityType().get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.OCEAN_FLOOR, ReedFrogEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
            event.register((EntityType)JSV1Animals.BASILISK.getEntityType().get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, BasiliskEntity::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
            event.register((EntityType)JSV1Animals.GOAT.getEntityType().get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GoatEntity::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
            event.register((EntityType)JSV1Animals.OSTRICH.getEntityType().get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, OstrichEntity::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        }

        @SubscribeEvent
        public static void registerEvent(RegisterEvent registerEvent) {
            Registry registry = registerEvent.getRegistry();
            if (registry == BuiltInRegistries.MENU) {
                JSNeoMenus.init(registerEvent);
            }
            if (registry == BuiltInRegistries.TRUNK_PLACER_TYPE) {
                JSNeoTreeGrowers.init(registerEvent);
            }
        }

        @SubscribeEvent
        public static void registerAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)JSEntities.EGG.get(), EggEntity.createLivingAttributes().build());
        }
    }

    @EventBusSubscriber(modid="jurassicsaga", bus=EventBusSubscriber.Bus.GAME)
    public static class GameEvents {
        @SubscribeEvent
        public static void onLivingDrops(LivingDropsEvent event) {
            DamageSource source = event.getSource();
            Entity entity = source.getEntity();
            if (entity instanceof JSAnimalBase) {
                JSAnimalBase base = (JSAnimalBase)entity;
                event.getDrops().removeIf(drop -> GameEvents.isFoodItem(base, event.getEntity(), drop.getItem()));
            }
        }

        private static boolean isFoodItem(JSAnimalBase base, LivingEntity entity, ItemStack stack) {
            boolean ateItem = base.getModules().getMetabolismModule().getDiet().canEatItem(stack);
            if (ateItem) {
                JSHerdModule herdModule = base.getModules().getHerdModule();
                if (herdModule.isFollower() || herdModule.isLeader()) {
                    if (herdModule.isLeader()) {
                        for (JSAnimalBase follower : herdModule.getFollowers()) {
                            if (!((double)follower.distanceTo((Entity)entity) < 12.5)) continue;
                            follower.getModules().getMetabolismModule().eatItem(stack);
                        }
                        base.getModules().getMetabolismModule().eatItem(stack);
                    } else {
                        JSAnimalBase trueLeader = herdModule.getTrueLeader();
                        for (JSAnimalBase follower : trueLeader.getModules().getHerdModule().getFollowers()) {
                            if (!((double)follower.distanceTo((Entity)entity) < 12.5)) continue;
                            follower.getModules().getMetabolismModule().eatItem(stack);
                        }
                        trueLeader.getModules().getMetabolismModule().eatItem(stack);
                    }
                } else {
                    base.getModules().getMetabolismModule().eatItem(stack);
                }
            }
            return ateItem;
        }
    }
}

