/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo.data.client;

import java.util.ArrayList;
import java.util.function.Supplier;
import jp.jurassicsaga.neo.data.JSData;
import jp.jurassicsaga.neo.data.obj.Data;
import jp.jurassicsaga.neo.data.obj.SignDataObject;
import jp.jurassicsaga.neo.data.obj.SimpleDataObject;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class JSLanguageProvider
extends LanguageProvider {
    private final ArrayList<String> translations = new ArrayList();
    boolean firstRun;

    public JSLanguageProvider(PackOutput output) {
        super(output, "jurassicsaga", "en_us");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addTranslations() {
        if (!this.firstRun) {
            JSData.getDATA().forEach((supplier, data) -> this.accept((Supplier<?>)supplier, (Data)data));
            for (Data data2 : JSData.getDATA_ARRAY().stream().filter(data -> data instanceof SimpleDataObject).toList()) {
                String translation;
                String translationKey;
                if (!(data2 instanceof SimpleDataObject)) continue;
                SimpleDataObject simpleDataObject = (SimpleDataObject)data2;
                try {
                    String string;
                    translationKey = string = simpleDataObject.translationKey();
                    translation = string = simpleDataObject.translation();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                this.add(translationKey, translation);
            }
        }
        this.firstRun = true;
    }

    private void accept(Supplier<?> deferredHolder, Data translationObject) {
        if (translationObject instanceof SignDataObject) {
            return;
        }
        if (translationObject.translation() == null) {
            return;
        }
        if (deferredHolder == null) {
            return;
        }
        Object result = deferredHolder.get();
        if (result instanceof Block) {
            Block block = (Block)result;
            if (this.translations.contains(block.getDescriptionId())) {
                return;
            }
            this.add(block, translationObject.translation());
            this.translations.add(block.getDescriptionId());
        } else if (result instanceof Item) {
            Item item = (Item)result;
            if (this.translations.contains(item.getDescriptionId())) {
                return;
            }
            this.add(item, translationObject.translation());
            this.translations.add(item.getDescriptionId());
        } else if (result instanceof EntityType) {
            EntityType entity = (EntityType)result;
            if (this.translations.contains(entity.getDescriptionId())) {
                return;
            }
            this.addEntityType(deferredHolder, translationObject.translation());
            this.translations.add(entity.getDescriptionId());
        } else {
            Object obj = deferredHolder.get();
            if (obj instanceof TagKey) {
                ResourceKey registry;
                ResourceKey resourceKey;
                TagKey tagKey = (TagKey)obj;
                try {
                    registry = resourceKey = tagKey.registry();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                ResourceKey location = resourceKey = tagKey.location();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("tag.");
                ResourceLocation registryIdentifier = registry.location();
                stringBuilder.append(registryIdentifier.toShortLanguageKey().replace("/", ".")).append(".").append(location.getNamespace()).append(".").append(location.getPath().replace("/", ".").replace(":", "."));
                if (this.translations.contains(stringBuilder.toString())) {
                    return;
                }
                this.addTag(deferredHolder, translationObject.translation());
                this.translations.add(stringBuilder.toString());
            }
        }
    }
}

