/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo.data.server;

import com.google.common.base.Supplier;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.block.obj.group.BasicBlockSetRegistries;
import jp.jurassicsaga.server.base.block.obj.group.ColoredRegistries;
import jp.jurassicsaga.server.base.block.obj.group.StoneRegistries;
import jp.jurassicsaga.server.base.item.JSItems;
import jp.jurassicsaga.server.base.tag.JSItemTags;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import org.jetbrains.annotations.NotNull;

public class JSCraftingProvider
extends RecipeProvider
implements IConditionBuilder {
    public JSCraftingProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@NotNull RecipeOutput out) {
        this.buildAnimalRecipes(out);
        this.shapeless(out, RecipeCategory.TOOLS, (ItemLike)JSItems.GUIDEBOOK.get(), 1, List.of(Items.BOOK, JSItemTags.FOSSIL), (ItemLike)Items.BOOK);
        this.shapeless(out, RecipeCategory.BREWING, (ItemLike)JSV1Items.SYRINGE.get(), 16, List.of(Items.GLASS, Items.IRON_INGOT), (ItemLike)Items.IRON_INGOT);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.THATCH.get(), 2, Map.of(Items.SHORT_GRASS, 4, Items.SUGAR_CANE, 4, Items.STICK, 1), (ItemLike)Items.SHORT_GRASS);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.IRON_PILLAR.get(), 2, Map.of(Items.IRON_BLOCK, 2), (ItemLike)Items.IRON_BLOCK);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.ROOF_TILES.get(), 2, Map.of(Items.BRICKS, 3, Items.IRON_INGOT, 1), (ItemLike)Items.BRICKS);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.CAMO_NET.get(), 8, Map.of(Items.STICK, 5), (ItemLike)Items.STICK, List.of(Ingredient.of((TagKey)ItemTags.LEAVES)));
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.REINFORCED_GLASS.get(), 2, Map.of(((Block)JSV1Blocks.CLEAR_GLASS.get()).asItem(), 1, Items.IRON_INGOT, 1), (ItemLike)((Block)JSV1Blocks.CLEAR_GLASS.get()).asItem());
        JSCraftingProvider.stairBuilder((ItemLike)((ItemLike)JSV1Blocks.ROOF_TILES_STAIR.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.ROOF_TILES.get()})).unlockedBy("has_roof_tiles", JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.ROOF_TILES.get()))).save(out);
        JSCraftingProvider.slab((RecipeOutput)out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JSV1Blocks.ROOF_TILES_SLAB.get()), (ItemLike)((ItemLike)JSV1Blocks.ROOF_TILES.get()));
        this.stairSlabColoredGroup(out, JSV1Blocks.COLORED_ROOF_TILES_STAIRS, JSV1Blocks.COLORED_ROOF_TILES_SLAB, JSV1Blocks.COLORED_ROOF_TILES);
        this.colorGroup(out, JSV1Blocks.COLORED_ROOF_TILES, (Block)JSV1Blocks.ROOF_TILES.get());
        JSCraftingProvider.stairBuilder((ItemLike)((ItemLike)JSV1Blocks.CORRUGATED_IRON_STAIR.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.CORRUGATED_IRON.get()})).unlockedBy("has_corrugated_iron", JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.CORRUGATED_IRON.get()))).save(out);
        JSCraftingProvider.slab((RecipeOutput)out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JSV1Blocks.CORRUGATED_IRON_SLAB.get()), (ItemLike)((ItemLike)JSV1Blocks.CORRUGATED_IRON.get()));
        this.colorGroup(out, JSV1Blocks.COLORED_CORRUGATED_IRONS, (Block)JSV1Blocks.CORRUGATED_IRON.get());
        this.stairSlabColoredGroup(out, JSV1Blocks.COLORED_CORRUGATED_IRONS_STAIR, JSV1Blocks.COLORED_CORRUGATED_IRONS_SLAB, JSV1Blocks.COLORED_CORRUGATED_IRONS);
        this.colorGroup(out, JSV1Blocks.COLORED_GLASS_DOORS, (Block)JSV1Blocks.GLASS_DOOR.get());
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.BIG_TILE.get(), 3, new String[]{"CS", "SC"}, Map.of(Character.valueOf('C'), Items.COBBLESTONE, Character.valueOf('S'), Items.SAND), (ItemLike)Items.SAND);
        JSCraftingProvider.stairBuilder((ItemLike)((ItemLike)JSV1Blocks.BIG_TILE_STAIR.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.BIG_TILE.get()})).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.BIG_TILE.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.BIG_TILE.get()))).save(out);
        JSCraftingProvider.slab((RecipeOutput)out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JSV1Blocks.BIG_TILE_SLAB.get()), (ItemLike)((ItemLike)JSV1Blocks.BIG_TILE.get()));
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get(), 8, new String[]{"CCC", "CBC", "CCC"}, Map.of(Character.valueOf('C'), JSItemTags.CONCRETE, Character.valueOf('B'), Items.IRON_BARS), (ItemLike)Items.IRON_BARS);
        this.basicFamily(out, JSV1Blocks.FACILITY_CONCRETE);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE_BRICKS.BLOCK.get(), 8, new String[]{"CC", "CC"}, Map.of(Character.valueOf('C'), JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).asItem());
        this.basicFamily(out, JSV1Blocks.FACILITY_CONCRETE_BRICKS);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE_CRACKED.BLOCK.get(), 1, Map.of(((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).asItem(), 1), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).asItem());
        this.basicFamily(out, JSV1Blocks.FACILITY_CONCRETE_CRACKED);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE_BRICKS_CRACKED.BLOCK.get(), 1, Map.of(((Block)JSV1Blocks.FACILITY_CONCRETE_BRICKS.BLOCK.get()).asItem(), 1), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE_BRICKS.BLOCK.get()).asItem());
        this.basicFamily(out, JSV1Blocks.FACILITY_CONCRETE_BRICKS_CRACKED);
        this.mossifyBasic(out, JSV1Blocks.FACILITY_CONCRETE_BRICKS, JSV1Blocks.FACILITY_CONCRETE_BRICKS_MOSSY);
        this.mossifyBasic(out, JSV1Blocks.FACILITY_CONCRETE, JSV1Blocks.FACILITY_CONCRETE_MOSSY);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE_PANEL_MOSSY.BLOCK.get(), 2, Map.of(((Block)JSV1Blocks.FACILITY_CONCRETE_PANEL.BLOCK.get()).asItem(), 8), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE_PANEL.BLOCK.get()).asItem(), List.of(Ingredient.of(JSItemTags.MOSS)));
        this.basicFamily(out, JSV1Blocks.FACILITY_CONCRETE_PANEL_MOSSY);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE_PANEL.BLOCK.get(), 2, Map.of(((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).asItem(), 2), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).asItem());
        this.basicFamily(out, JSV1Blocks.FACILITY_CONCRETE_PANEL);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get(), 3, new String[]{"C", "C", "C"}, Map.of(Character.valueOf('C'), JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).asItem());
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE_PILLAR_CRACKED.get(), 1, Map.of(((Block)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get()).asItem(), 1), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get()).asItem());
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE_PILLAR_MOSSY.get(), 8, Map.of(((Block)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get()).asItem(), 8), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get()).asItem(), List.of(Ingredient.of(JSItemTags.MOSS)));
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.MIXED_PATH.get(), 3, new String[]{"CS", "SC"}, Map.of(Character.valueOf('C'), Items.COBBLESTONE, Character.valueOf('S'), Items.DIRT), (ItemLike)Items.COBBLESTONE);
        JSCraftingProvider.stairBuilder((ItemLike)((ItemLike)JSV1Blocks.MIXED_PATH_STAIR.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.MIXED_PATH.get()})).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.MIXED_PATH.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.MIXED_PATH.get()))).save(out);
        JSCraftingProvider.slab((RecipeOutput)out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JSV1Blocks.MIXED_PATH_SLAB.get()), (ItemLike)((ItemLike)JSV1Blocks.MIXED_PATH.get()));
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.CORRUGATED_IRON.get(), 8, new String[]{"CS", "SC"}, Map.of(Character.valueOf('C'), Items.COBBLESTONE, Character.valueOf('S'), Items.IRON_INGOT), (ItemLike)Items.COBBLESTONE);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.HEAVY_DUTY_GRID.get(), 3, new String[]{"CS", "SC"}, Map.of(Character.valueOf('C'), Items.IRON_NUGGET, Character.valueOf('S'), Items.IRON_BARS), (ItemLike)Items.IRON_BARS);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.HEAVY_DUTY_BARS.get(), 3, new String[]{"SS", "SS"}, Map.of(Character.valueOf('S'), Items.IRON_BARS), (ItemLike)Items.IRON_BARS);
        JSCraftingProvider.stairBuilder((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_BARS_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.HEAVY_DUTY_BARS.get()})).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_BARS.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_BARS.get()))).save(out);
        JSCraftingProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_BARS_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.HEAVY_DUTY_BARS.get()})).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_BARS.get())) + "_slab", JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_BARS.get()))).save(out);
        JSCraftingProvider.stairBuilder((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_GRID_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.HEAVY_DUTY_GRID.get()})).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_GRID.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_GRID.get()))).save(out);
        JSCraftingProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_GRID_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.HEAVY_DUTY_GRID.get()})).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_GRID.get())) + "_slab", JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_GRID.get()))).save(out);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.CLEAR_GLASS.get(), 3, new String[]{"GG", "GG"}, Map.of(Character.valueOf('G'), Items.GLASS), (ItemLike)Items.GLASS);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.GLASS_DOOR.get(), 3, new String[]{"#GG", "#GG", "#GG"}, Map.of(Character.valueOf('#'), ItemTags.PLANKS, Character.valueOf('G'), Items.GLASS_PANE), (ItemLike)Items.GLASS_PANE);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.GRID_DOOR.get(), 2, new String[]{"#", "#", "#"}, Map.of(Character.valueOf('#'), Items.IRON_BARS), (ItemLike)Items.IRON_BARS);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.SECURE_GRID_DOOR.get(), 1, Map.of(((Block)JSV1Blocks.GRID_DOOR.get()).asItem(), 1, Items.IRON_INGOT, 2), (ItemLike)Items.IRON_INGOT);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.LAB_DOOR.get(), 2, new String[]{"P", "#", "#"}, Map.of(Character.valueOf('#'), Items.IRON_INGOT, Character.valueOf('P'), Items.GLASS_PANE), (ItemLike)Items.IRON_BARS);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.HIGH_SECURITY_DOOR.get(), 1, Map.of(Blocks.IRON_DOOR.asItem(), 1, Items.IRON_INGOT, 4), (ItemLike)Items.IRON_INGOT);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.AMBER_BLOCK.get(), 4, new String[]{"CCC", "CCC", "CCC"}, Map.of(Character.valueOf('C'), JSItemTags.AMBER), (ItemLike)Items.COBBLESTONE);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.THATCH_SLAB.get(), 6, new String[]{"###"}, Map.of(Character.valueOf('#'), JSV1Blocks.THATCH.get()), (ItemLike)((Block)JSV1Blocks.THATCH.get()).asItem());
        JSCraftingProvider.stairBuilder((ItemLike)((ItemLike)JSV1Blocks.THATCH_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.THATCH.get()})).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)JSV1Blocks.THATCH.get())), JSCraftingProvider.has((ItemLike)((ItemLike)JSV1Blocks.THATCH.get()))).save(out);
        this.shaped(out, RecipeCategory.BREWING, (ItemLike)JSV1Items.EMPTY_TEST_TUBE.get(), 16, new String[]{"#", "#"}, Map.of(Character.valueOf('#'), Items.GLASS), (ItemLike)Items.GLASS);
        this.shaped(out, RecipeCategory.BREWING, (ItemLike)JSV1Blocks.GENETIC_ANALYZER.get(), 1, new String[]{"PBE", "GAL", "IIL"}, Map.of(Character.valueOf('P'), ItemTags.WOODEN_PRESSURE_PLATES, Character.valueOf('B'), Items.BUCKET, Character.valueOf('E'), JSV1Items.SYRINGE.get(), Character.valueOf('G'), Items.GLASS_PANE, Character.valueOf('A'), Items.IRON_BARS, Character.valueOf('L'), Items.LEVER, Character.valueOf('I'), Items.IRON_INGOT), (ItemLike)Items.IRON_INGOT);
        this.shaped(out, RecipeCategory.BREWING, (ItemLike)JSV1Blocks.GENE_EXTRACTOR.get(), 1, new String[]{"CPI", "LBG", "RSS"}, Map.of(Character.valueOf('C'), Items.GREEN_DYE, Character.valueOf('P'), Items.PISTON, Character.valueOf('I'), Items.IRON_INGOT, Character.valueOf('L'), Items.LAPIS_LAZULI, Character.valueOf('B'), Items.IRON_BLOCK, Character.valueOf('G'), Items.GLASS_PANE, Character.valueOf('R'), Items.REDSTONE, Character.valueOf('S'), Items.STONE_BUTTON), (ItemLike)Items.IRON_INGOT);
        this.shaped(out, RecipeCategory.BREWING, (ItemLike)JSV1Blocks.DNA_MODIFIER.get(), 1, new String[]{"CII", "LBG", "RSS"}, Map.of(Character.valueOf('C'), Items.GREEN_DYE, Character.valueOf('I'), Items.IRON_INGOT, Character.valueOf('L'), Items.LAPIS_LAZULI, Character.valueOf('B'), Items.IRON_BLOCK, Character.valueOf('G'), Items.GLASS_PANE, Character.valueOf('R'), Items.REDSTONE, Character.valueOf('S'), Items.STONE_BUTTON), (ItemLike)Items.IRON_INGOT);
        this.shaped(out, RecipeCategory.BREWING, (ItemLike)JSV1Blocks.INCUBATOR.get(), 1, new String[]{"NGI", "LGP", "LBR"}, Map.of(Character.valueOf('N'), Items.IRON_NUGGET, Character.valueOf('I'), Items.IRON_INGOT, Character.valueOf('L'), Items.LEVER, Character.valueOf('B'), Items.IRON_BLOCK, Character.valueOf('P'), Items.PISTON, Character.valueOf('G'), Items.GLASS, Character.valueOf('R'), Items.REDSTONE), (ItemLike)Items.IRON_INGOT);
        this.shaped(out, RecipeCategory.BREWING, (ItemLike)JSV1Blocks.CULTIVATOR.get(), 1, new String[]{"IDR", "IPS", "IIS"}, Map.of(Character.valueOf('I'), Items.IRON_INGOT, Character.valueOf('D'), Items.GLOWSTONE_DUST, Character.valueOf('R'), Items.REDSTONE, Character.valueOf('P'), Items.GLASS_PANE, Character.valueOf('S'), Items.STONE_BUTTON), (ItemLike)Items.IRON_INGOT);
        this.shaped(out, RecipeCategory.MISC, (ItemLike)JSV1Blocks.BUG_ZAPPER.get(), 1, new String[]{" C ", "IFI", " I "}, Map.of(Character.valueOf('I'), Items.IRON_INGOT, Character.valueOf('C'), Items.CHAIN, Character.valueOf('F'), Items.SOUL_TORCH), (ItemLike)Items.IRON_INGOT);
        this.shaped(out, RecipeCategory.MISC, (ItemLike)JSV1Blocks.HERBIVORE_FEEDER.get(), 1, new String[]{"FPF", "ICI", "FPF"}, Map.of(Character.valueOf('I'), Items.IRON_INGOT, Character.valueOf('C'), Items.CHEST, Character.valueOf('F'), JSV1Blocks.FACILITY_CONCRETE.BLOCK.get(), Character.valueOf('P'), Items.PISTON), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).asItem());
        this.shaped(out, RecipeCategory.MISC, (ItemLike)JSV1Blocks.CARNIVORE_FEEDER.get(), 1, new String[]{"IFI", "PCP", "IFI"}, Map.of(Character.valueOf('I'), Items.IRON_INGOT, Character.valueOf('C'), Items.CHEST, Character.valueOf('F'), JSV1Blocks.FACILITY_CONCRETE.BLOCK.get(), Character.valueOf('P'), Items.PISTON), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).asItem());
        this.shaped(out, RecipeCategory.MISC, (ItemLike)JSV1Blocks.AQUATIC_FEEDER.get(), 1, new String[]{"IDI", "FCF", "PDP"}, Map.of(Character.valueOf('I'), Items.IRON_INGOT, Character.valueOf('C'), Items.CHEST, Character.valueOf('F'), JSV1Blocks.FACILITY_CONCRETE.BLOCK.get(), Character.valueOf('P'), Items.PISTON, Character.valueOf('D'), Items.COBBLED_DEEPSLATE), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).asItem());
        List<StoneRegistries> v2Stones = List.of(JSV2Blocks.SHALE, JSV2Blocks.POLISHED_SHALE, JSV2Blocks.MOSSY_POLISHED_SHALE, JSV2Blocks.SHALE_BRICKS, JSV2Blocks.MOSSY_SHALE_BRICKS, JSV2Blocks.INTRICATE_SHALE_BRICKS, JSV2Blocks.MOSSY_INTRICATE_SHALE_BRICKS, JSV2Blocks.RHYOLITE, JSV2Blocks.POLISHED_RHYOLITE, JSV2Blocks.MOSSY_POLISHED_RHYOLITE, JSV2Blocks.RHYOLITE_BRICKS, JSV2Blocks.MOSSY_RHYOLITE_BRICKS, JSV2Blocks.INTRICATE_RHYOLITE_BRICKS, JSV2Blocks.MOSSY_INTRICATE_RHYOLITE_BRICKS);
        v2Stones.forEach(s -> this.completeStoneGroup(out, (StoneRegistries)s));
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.SHALE_BRICKS.BLOCK.get(), 8, new String[]{"CC", "CC"}, Map.of(Character.valueOf('C'), JSV2Blocks.SHALE.BLOCK.get()), (ItemLike)((Block)JSV2Blocks.SHALE.BLOCK.get()).asItem());
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.INTRICATE_SHALE_BRICKS.BLOCK.get(), 10, new String[]{"CCC", "CCC", "CCC"}, Map.of(Character.valueOf('C'), JSV2Blocks.SHALE_BRICKS.BLOCK.get()), (ItemLike)((Block)JSV2Blocks.SHALE_BRICKS.BLOCK.get()).asItem());
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.POLISHED_SHALE.BLOCK.get(), 4, new String[]{"CC", "CC"}, Map.of(Character.valueOf('C'), JSV2Blocks.SHALE_BRICKS.BLOCK.get()), (ItemLike)((Block)JSV2Blocks.SHALE_BRICKS.BLOCK.get()).asItem());
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.RHYOLITE_BRICKS.BLOCK.get(), 8, new String[]{"CC", "CC"}, Map.of(Character.valueOf('C'), JSV2Blocks.RHYOLITE.BLOCK.get()), (ItemLike)((Block)JSV2Blocks.RHYOLITE.BLOCK.get()).asItem());
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.INTRICATE_RHYOLITE_BRICKS.BLOCK.get(), 10, new String[]{"CCC", "CCC", "CCC"}, Map.of(Character.valueOf('C'), JSV2Blocks.RHYOLITE_BRICKS.BLOCK.get()), (ItemLike)((Block)JSV2Blocks.RHYOLITE_BRICKS.BLOCK.get()).asItem());
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.POLISHED_RHYOLITE.BLOCK.get(), 4, new String[]{"CC", "CC"}, Map.of(Character.valueOf('C'), JSV2Blocks.RHYOLITE_BRICKS.BLOCK.get()), (ItemLike)((Block)JSV2Blocks.RHYOLITE_BRICKS.BLOCK.get()).asItem());
        this.mossySwap(out, JSV2Blocks.INTRICATE_SHALE_BRICKS, JSV2Blocks.MOSSY_INTRICATE_SHALE_BRICKS);
        this.mossySwap(out, JSV2Blocks.SHALE_BRICKS, JSV2Blocks.MOSSY_SHALE_BRICKS);
        this.mossySwap(out, JSV2Blocks.POLISHED_SHALE, JSV2Blocks.MOSSY_POLISHED_SHALE);
        this.mossySwap(out, JSV2Blocks.INTRICATE_RHYOLITE_BRICKS, JSV2Blocks.MOSSY_INTRICATE_RHYOLITE_BRICKS);
        this.mossySwap(out, JSV2Blocks.RHYOLITE_BRICKS, JSV2Blocks.MOSSY_RHYOLITE_BRICKS);
        this.mossySwap(out, JSV2Blocks.POLISHED_RHYOLITE, JSV2Blocks.MOSSY_POLISHED_RHYOLITE);
    }

    private void buildAnimalRecipes(@NotNull RecipeOutput out) {
        this.addCooking(out, ((Item)JSV1Items.SQUID.get()).getDefaultInstance(), ((Item)JSV1Items.SQUID_COOKED.get()).getDefaultInstance(), 600);
        for (JSAnimal<?> a : JSAnimals.getAnimals()) {
            JSItemProperties props = a.getAnimalAttributes().getItemProperties();
            if (!props.isHasDrops() || !props.isHasMeat()) continue;
            this.addCooking(out, ((Item)a.getItems().getRawMeat().get()).getDefaultInstance(), ((Item)a.getItems().getCookedMeat().get()).getDefaultInstance(), 600);
        }
    }

    private void addCooking(RecipeOutput out, ItemStack in, ItemStack cooked, int time) {
        this.cooking(out, SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{in}), (RecipeCategory)RecipeCategory.FOOD, (ItemStack)cooked, (float)0.5f, (int)(time / 2)), in, cooked, "_smelt");
        this.cooking(out, SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{in}), (RecipeCategory)RecipeCategory.FOOD, (ItemStack)cooked, (float)0.5f, (int)(time / 2 - time / 2 / 5)), in, cooked, "_smoke");
        this.cooking(out, SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{in}), (RecipeCategory)RecipeCategory.FOOD, (ItemStack)cooked, (float)0.5f, (int)time), in, cooked, "_campfire");
    }

    private void cooking(RecipeOutput out, SimpleCookingRecipeBuilder b, ItemStack in, ItemStack cooked, String suffix) {
        b.unlockedBy(JSCraftingProvider.getHasName((ItemLike)in.getItem()), JSCraftingProvider.has((ItemLike)in.getItem())).unlockedBy(JSCraftingProvider.getHasName((ItemLike)cooked.getItem()), JSCraftingProvider.has((ItemLike)cooked.getItem())).save(out, String.valueOf(RecipeBuilder.getDefaultRecipeId((ItemLike)cooked.getItem())) + suffix);
    }

    private void shaped(RecipeOutput out, RecipeCategory cat, Supplier<? extends ItemLike> result, int count, String[] pattern, Map<Character, Object> keys, ItemLike unlock) {
        this.shaped(out, cat, (ItemLike)result.get(), count, pattern, keys, unlock);
    }

    private void shaped(RecipeOutput out, RecipeCategory cat, ItemLike result, int count, String[] pattern, Map<Character, Object> keys, ItemLike unlock) {
        ShapedRecipeBuilder b = ShapedRecipeBuilder.shaped((RecipeCategory)cat, (ItemLike)result, (int)count);
        for (String line : pattern) {
            b.pattern(line);
        }
        keys.forEach((ch, obj) -> {
            if (obj instanceof ItemLike) {
                ItemLike il = (ItemLike)obj;
                b.define(ch, il);
            } else if (obj instanceof Block) {
                Block bl = (Block)obj;
                b.define(ch, (ItemLike)bl);
            } else if (obj instanceof TagKey) {
                TagKey tag = (TagKey)obj;
                b.define(ch, tag);
            } else {
                throw new IllegalArgumentException("Unsupported key type: " + String.valueOf(obj));
            }
        });
        b.unlockedBy(JSCraftingProvider.getHasName((ItemLike)unlock), JSCraftingProvider.has((ItemLike)unlock)).save(out);
    }

    private void shapeless(RecipeOutput out, RecipeCategory cat, ItemLike result, int count, List<?> inputs, ItemLike unlock) {
        ShapelessRecipeBuilder b = ShapelessRecipeBuilder.shapeless((RecipeCategory)cat, (ItemLike)result, (int)count);
        for (Object in : inputs) {
            if (in instanceof ItemLike) {
                ItemLike il = (ItemLike)in;
                b.requires(il);
                continue;
            }
            if (in instanceof Ingredient) {
                Ingredient ing = (Ingredient)in;
                b.requires(ing);
                continue;
            }
            if (in instanceof TagKey) {
                TagKey tag = (TagKey)in;
                b.requires(Ingredient.of((TagKey)tag));
                continue;
            }
            throw new IllegalArgumentException("Unsupported shapeless input: " + String.valueOf(in));
        }
        b.unlockedBy(JSCraftingProvider.getHasName((ItemLike)unlock), JSCraftingProvider.has((ItemLike)unlock)).save(out);
    }

    private void shapelessCounts(RecipeOutput out, RecipeCategory cat, ItemLike result, int count, Map<ItemLike, Integer> withCounts, ItemLike unlock) {
        this.shapelessCounts(out, cat, result, count, withCounts, unlock, List.of());
    }

    private void shapelessCounts(RecipeOutput out, RecipeCategory cat, ItemLike result, int count, Map<ItemLike, Integer> withCounts, ItemLike unlock, List<Ingredient> extraIngredients) {
        ShapelessRecipeBuilder b = ShapelessRecipeBuilder.shapeless((RecipeCategory)cat, (ItemLike)result, (int)count);
        withCounts.forEach((il, c) -> b.requires(il, c.intValue()));
        extraIngredients.forEach(arg_0 -> ((ShapelessRecipeBuilder)b).requires(arg_0));
        b.unlockedBy(JSCraftingProvider.getHasName((ItemLike)unlock), JSCraftingProvider.has((ItemLike)unlock)).save(out);
    }

    private void colorGroup(@NotNull RecipeOutput out, ColoredRegistries color, Block base) {
        Map<Supplier, Item> map = Map.ofEntries(Map.entry(color.BLACK, Items.BLACK_DYE), Map.entry(color.BLUE, Items.BLUE_DYE), Map.entry(color.BROWN, Items.BROWN_DYE), Map.entry(color.CYAN, Items.CYAN_DYE), Map.entry(color.GREEN, Items.GREEN_DYE), Map.entry(color.GREY, Items.GRAY_DYE), Map.entry(color.LIGHTBLUE, Items.LIGHT_BLUE_DYE), Map.entry(color.LIGHTGREY, Items.LIGHT_GRAY_DYE), Map.entry(color.LIME, Items.LIME_DYE), Map.entry(color.MAGENTA, Items.MAGENTA_DYE), Map.entry(color.ORANGE, Items.ORANGE_DYE), Map.entry(color.PINK, Items.PINK_DYE), Map.entry(color.PURPLE, Items.PURPLE_DYE), Map.entry(color.RED, Items.RED_DYE), Map.entry(color.WHITE, Items.WHITE_DYE), Map.entry(color.YELLOW, Items.YELLOW_DYE));
        map.forEach((supplier, dye) -> this.colorBlock(out, (Block)supplier.get(), base, (Item)dye));
    }

    private void colorBlock(@NotNull RecipeOutput out, Block colored, Block base, Item dye) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)colored, (int)1).requires((ItemLike)base, 1).requires((ItemLike)dye, 1).unlockedBy(JSCraftingProvider.getHasName((ItemLike)base), JSCraftingProvider.has((ItemLike)base)).save(out, String.valueOf(RecipeBuilder.getDefaultRecipeId((ItemLike)colored)) + "_colored");
    }

    private void stairSlabColoredGroup(@NotNull RecipeOutput out, ColoredRegistries stairs, ColoredRegistries slabs, ColoredRegistries bases) {
        List.of((Block)stairs.BLACK.get(), (Block)stairs.BLUE.get(), (Block)stairs.BROWN.get(), (Block)stairs.CYAN.get(), (Block)stairs.GREEN.get(), (Block)stairs.GREY.get(), (Block)stairs.LIGHTBLUE.get(), (Block)stairs.LIGHTGREY.get(), (Block)stairs.LIME.get(), (Block)stairs.MAGENTA.get(), (Block)stairs.ORANGE.get(), (Block)stairs.PINK.get(), (Block)stairs.PURPLE.get(), (Block)stairs.RED.get(), (Block)stairs.WHITE.get(), (Block)stairs.YELLOW.get()).forEach(block -> {});
        this.stairSlabColored(out, (Block)stairs.BLACK.get(), (Block)slabs.BLACK.get(), (Block)bases.BLACK.get());
        this.stairSlabColored(out, (Block)stairs.BLUE.get(), (Block)slabs.BLUE.get(), (Block)bases.BLUE.get());
        this.stairSlabColored(out, (Block)stairs.BROWN.get(), (Block)slabs.BROWN.get(), (Block)bases.BROWN.get());
        this.stairSlabColored(out, (Block)stairs.CYAN.get(), (Block)slabs.CYAN.get(), (Block)bases.CYAN.get());
        this.stairSlabColored(out, (Block)stairs.GREEN.get(), (Block)slabs.GREEN.get(), (Block)bases.GREEN.get());
        this.stairSlabColored(out, (Block)stairs.GREY.get(), (Block)slabs.GREY.get(), (Block)bases.GREY.get());
        this.stairSlabColored(out, (Block)stairs.LIGHTBLUE.get(), (Block)slabs.LIGHTBLUE.get(), (Block)bases.LIGHTBLUE.get());
        this.stairSlabColored(out, (Block)stairs.LIGHTGREY.get(), (Block)slabs.LIGHTGREY.get(), (Block)bases.LIGHTGREY.get());
        this.stairSlabColored(out, (Block)stairs.LIME.get(), (Block)slabs.LIME.get(), (Block)bases.LIME.get());
        this.stairSlabColored(out, (Block)stairs.MAGENTA.get(), (Block)slabs.MAGENTA.get(), (Block)bases.MAGENTA.get());
        this.stairSlabColored(out, (Block)stairs.ORANGE.get(), (Block)slabs.ORANGE.get(), (Block)bases.ORANGE.get());
        this.stairSlabColored(out, (Block)stairs.PINK.get(), (Block)slabs.PINK.get(), (Block)bases.PINK.get());
        this.stairSlabColored(out, (Block)stairs.PURPLE.get(), (Block)slabs.PURPLE.get(), (Block)bases.PURPLE.get());
        this.stairSlabColored(out, (Block)stairs.RED.get(), (Block)slabs.RED.get(), (Block)bases.RED.get());
        this.stairSlabColored(out, (Block)stairs.WHITE.get(), (Block)slabs.WHITE.get(), (Block)bases.WHITE.get());
        this.stairSlabColored(out, (Block)stairs.YELLOW.get(), (Block)slabs.YELLOW.get(), (Block)bases.YELLOW.get());
    }

    private void stairSlabColored(@NotNull RecipeOutput out, Block stair, Block slab, Block base) {
        JSCraftingProvider.stairBuilder((ItemLike)stair, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base})).unlockedBy(JSCraftingProvider.getHasName((ItemLike)base), JSCraftingProvider.has((ItemLike)base)).save(out, String.valueOf(RecipeBuilder.getDefaultRecipeId((ItemLike)stair)) + "stair");
        JSCraftingProvider.slab((RecipeOutput)out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (ItemLike)base);
    }

    private void stoneFamily(@NotNull RecipeOutput out, StoneRegistries family) {
        this.stairSlabWallStonecutter(out, (Block)family.STAIRS.get(), (Block)family.WALL.get(), (Block)family.SLAB.get(), (Block)family.BLOCK.get());
    }

    private void basicFamily(@NotNull RecipeOutput out, BasicBlockSetRegistries family) {
        this.stairSlabWallStonecutter(out, (Block)family.STAIRS.get(), (Block)family.WALL.get(), (Block)family.SLAB.get(), (Block)family.BLOCK.get());
    }

    private void mossify(@NotNull RecipeOutput out, StoneRegistries base, StoneRegistries mossy) {
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)mossy.BLOCK.get(), 8, Map.of(((Block)base.BLOCK.get()).asItem(), 8), (ItemLike)((Block)base.BLOCK.get()).asItem(), List.of(Ingredient.of(JSItemTags.MOSS)));
        this.stoneFamily(out, mossy);
    }

    private void mossifyBasic(@NotNull RecipeOutput out, BasicBlockSetRegistries base, BasicBlockSetRegistries mossy) {
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)mossy.BLOCK.get(), 8, Map.of(((Block)base.BLOCK.get()).asItem(), 8), (ItemLike)((Block)base.BLOCK.get()).asItem(), List.of(Ingredient.of(JSItemTags.MOSS)));
        this.basicFamily(out, mossy);
    }

    private void mossySwap(@NotNull RecipeOutput out, StoneRegistries base, StoneRegistries mossy) {
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)mossy.BLOCK.get(), 8, Map.of(((Block)base.BLOCK.get()).asItem(), 8), (ItemLike)((Block)base.BLOCK.get()).asItem(), List.of(Ingredient.of(JSItemTags.MOSS)));
    }

    private void completeStoneGroup(@NotNull RecipeOutput out, StoneRegistries s) {
        JSCraftingProvider.pressurePlate((RecipeOutput)out, (ItemLike)((ItemLike)s.getPRESSURE_PLATE().get()), (ItemLike)((ItemLike)s.getBLOCK().get()));
        JSCraftingProvider.buttonBuilder((ItemLike)((ItemLike)s.BUTTON.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)s.BLOCK.get()})).unlockedBy(JSCraftingProvider.getHasName((ItemLike)((ItemLike)s.BLOCK.get())), JSCraftingProvider.has((ItemLike)((ItemLike)s.BLOCK.get()))).save(out);
        this.stairSlabWallStonecutter(out, (Block)s.STAIRS.get(), (Block)s.WALL.get(), (Block)s.SLAB.get(), (Block)s.BLOCK.get());
    }

    private void stairSlabWallStonecutter(@NotNull RecipeOutput out, Block stair, Block wall, Block slab, Block base) {
        JSCraftingProvider.stairBuilder((ItemLike)stair, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base})).unlockedBy(JSCraftingProvider.getHasName((ItemLike)base), JSCraftingProvider.has((ItemLike)base)).save(out, String.valueOf(RecipeBuilder.getDefaultRecipeId((ItemLike)stair)) + "stair");
        JSCraftingProvider.wall((RecipeOutput)out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall, (ItemLike)base);
        JSCraftingProvider.slab((RecipeOutput)out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (ItemLike)base);
        JSCraftingProvider.stonecutterResultFromBase((RecipeOutput)out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stair, (ItemLike)base);
        JSCraftingProvider.stonecutterResultFromBase((RecipeOutput)out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall, (ItemLike)base);
        JSCraftingProvider.stonecutterResultFromBase((RecipeOutput)out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (ItemLike)base, (int)2);
    }
}

