/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo.data.server.loot;

import java.util.Map;
import java.util.stream.Collectors;
import jp.jurassicsaga.server.base.block.JSBlocks;
import jp.jurassicsaga.server.base.block.obj.group.BasicBlockSetRegistries;
import jp.jurassicsaga.server.base.block.obj.group.ColoredRegistries;
import jp.jurassicsaga.server.base.block.obj.group.StoneRegistries;
import jp.jurassicsaga.server.base.block.obj.group.WoodRegistries;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.obj.PossibleResult;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class JSBlockLootTableProvider
extends VanillaBlockLoot {
    HolderLookup.RegistryLookup<Enchantment> registrylookup;

    public JSBlockLootTableProvider(HolderLookup.Provider registries) {
        super(registries);
        this.registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
    }

    protected void generate() {
        this.dropWhenSilkTouch((Block)JSBlocks.LARGE_NEST.get());
        this.dropWhenSilkTouch((Block)JSBlocks.MEDIUM_NEST.get());
        this.dropWhenSilkTouch((Block)JSBlocks.SMALL_NEST.get());
        this.dropSelf((Block)JSV1Blocks.CULTIVATOR.get());
        this.dropSelf((Block)JSV1Blocks.DNA_MODIFIER.get());
        this.dropSelf((Block)JSV1Blocks.GENETIC_ANALYZER.get());
        this.dropSelf((Block)JSV1Blocks.GENE_EXTRACTOR.get());
        this.dropSelf((Block)JSV1Blocks.INCUBATOR.get());
        this.dropSelf((Block)JSV1Blocks.BUG_ZAPPER.get());
        this.dropSelf((Block)JSV1Blocks.CARNIVORE_FEEDER.get());
        this.dropSelf((Block)JSV1Blocks.HERBIVORE_FEEDER.get());
        this.dropSelf((Block)JSV1Blocks.AQUATIC_FEEDER.get());
        this.add((Block)JSV1Blocks.GLASS_DOOR.get(), this.createDoorTable((Block)JSV1Blocks.GLASS_DOOR.get()));
        this.dropColoredDoor(JSV1Blocks.COLORED_GLASS_DOORS);
        this.dropSelf((Block)JSV1Blocks.CORRUGATED_IRON.get());
        this.dropSelf((Block)JSV1Blocks.CORRUGATED_IRON_SLAB.get());
        this.dropSelf((Block)JSV1Blocks.CORRUGATED_IRON_STAIR.get());
        this.dropColoredSelf(JSV1Blocks.COLORED_CORRUGATED_IRONS);
        this.dropColoredSelf(JSV1Blocks.COLORED_CORRUGATED_IRONS_SLAB);
        this.dropColoredSelf(JSV1Blocks.COLORED_CORRUGATED_IRONS_STAIR);
        this.dropSelf((Block)JSV1Blocks.ROOF_TILES.get());
        this.dropSelf((Block)JSV1Blocks.ROOF_TILES_SLAB.get());
        this.dropSelf((Block)JSV1Blocks.ROOF_TILES_STAIR.get());
        this.dropColoredSelf(JSV1Blocks.COLORED_ROOF_TILES);
        this.dropColoredSelf(JSV1Blocks.COLORED_ROOF_TILES_SLAB);
        this.dropColoredSelf(JSV1Blocks.COLORED_ROOF_TILES_STAIRS);
        this.dropSelf((Block)JSV1Blocks.THATCH.get());
        this.dropSelf((Block)JSV1Blocks.THATCH_SLAB.get());
        this.dropSelf((Block)JSV1Blocks.THATCH_STAIRS.get());
        this.dropSelf((Block)JSV1Blocks.IRON_PILLAR.get());
        this.dropSelf((Block)JSV1Blocks.BIG_TILE.get());
        this.dropSelf((Block)JSV1Blocks.BIG_TILE_SLAB.get());
        this.dropSelf((Block)JSV1Blocks.BIG_TILE_STAIR.get());
        this.dropSelf((Block)JSV1Blocks.MIXED_PATH.get());
        this.dropSelf((Block)JSV1Blocks.MIXED_PATH_SLAB.get());
        this.dropSelf((Block)JSV1Blocks.MIXED_PATH_STAIR.get());
        this.dropSelf((Block)JSV1Blocks.CAMO_NET.get());
        this.dropWhenSilkTouch((Block)JSV1Blocks.CLEAR_GLASS.get());
        this.dropSelf((Block)JSV1Blocks.REINFORCED_GLASS.get());
        this.dropSelf((Block)JSV1Blocks.HEAVY_DUTY_GRID.get());
        this.dropSelf((Block)JSV1Blocks.HEAVY_DUTY_GRID_SLAB.get());
        this.dropSelf((Block)JSV1Blocks.HEAVY_DUTY_GRID_STAIRS.get());
        this.dropSelf((Block)JSV1Blocks.HEAVY_DUTY_BARS.get());
        this.dropSelf((Block)JSV1Blocks.HEAVY_DUTY_BARS_SLAB.get());
        this.dropSelf((Block)JSV1Blocks.HEAVY_DUTY_BARS_STAIRS.get());
        this.dropWoodSet(JSV1Blocks.ARAUCARIOXYLON, (Block)JSV1Blocks.ARAUCARIOXYLON_SAPLING.get());
        this.dropWoodSet(JSV1Blocks.GORDONPTERIS, (Block)JSV1Blocks.GORDONPTERIS_SAPLING.get());
        this.dropWoodSet(JSV1Blocks.LEPIDODENDRON, (Block)JSV1Blocks.LEPIDODENDRON_SAPLING.get());
        this.dropWoodSet(JSV1Blocks.SPINIFRUCTUS, (Block)JSV1Blocks.SPINIFRUCTUS_SAPLING.get());
        this.dropSelf((Block)JSV1Blocks.ALETHOPTERIS.get());
        this.dropSelf((Block)JSV1Blocks.ARCHAEOMARASMIUS.get());
        this.dropSelf((Block)JSV1Blocks.CYCADEOIDEA.get());
        this.dropSelf((Block)JSV1Blocks.LADINA_SIMPLEX.get());
        this.dropSelf((Block)JSV1Blocks.SELAGINELLITES.get());
        this.dropSelf((Block)JSV1Blocks.ZINGIBEROPSIS_BASIC.get());
        this.dropSelf((Block)JSV1Blocks.ZINGIBEROPSIS_ORANGE.get());
        this.dropSelf((Block)JSV1Blocks.ZINGIBEROPSIS_PINK.get());
        this.dropSelf((Block)JSV1Blocks.ZINGIBEROPSIS_RED.get());
        this.dropSelf((Block)JSV1Blocks.ZINGIBEROPSIS_WHITE.get());
        this.dropSelf((Block)JSV1Blocks.ZINGIBEROPSIS_YELLOW.get());
        this.dropSelf((Block)JSV1Blocks.ROYAL_FERN.get());
        this.dropSelf((Block)JSV1Blocks.CAPRINA.get());
        this.dropSelf((Block)JSV1Blocks.CREMNOCERAMUS.get());
        this.dropSelf((Block)JSV1Blocks.HIPPURITELLA.get());
        this.dropSelf((Block)JSV1Blocks.INOCERAMUS.get());
        this.dropSelf((Block)JSV1Blocks.COBANNIA_CORRUGATA.get());
        this.dropSelf((Block)JSV1Blocks.NEOCALAMITES.get());
        this.dropSelf((Block)JSV1Blocks.OMPHALOPHLOIOS.get());
        this.dropSelf((Block)JSV1Blocks.RHAMNUS_SALICIFOLIUS.get());
        this.dropSelf((Block)JSV1Blocks.TEMPSKYA.get());
        this.add((Block)JSV1Blocks.NEUROPTERIS.get(), this.createDoublePlantDrop((Block)JSV1Blocks.NEUROPTERIS.get()));
        this.add((Block)JSV1Blocks.VERIFORMANS.get(), this.createDoublePlantDrop((Block)JSV1Blocks.VERIFORMANS.get()));
        this.add((Block)JSV1Blocks.SWISS_CHEESE_PLANT.get(), this.createDoublePlantDrop((Block)JSV1Blocks.SWISS_CHEESE_PLANT.get()));
        this.add((Block)JSV1Blocks.WEST_INDIAN_LILAC.get(), this.createDoublePlantDrop((Block)JSV1Blocks.WEST_INDIAN_LILAC.get()));
        this.add((Block)JSV1Blocks.HELICONIA.get(), this.createDoublePlantDrop((Block)JSV1Blocks.HELICONIA.get()));
        this.add((Block)JSV1Blocks.CLADOPHLEBIS.get(), this.createDoublePlantDrop((Block)JSV1Blocks.CLADOPHLEBIS.get()));
        this.add((Block)JSV1Blocks.SECURE_GRID_DOOR.get(), this.createDoorTable((Block)JSV1Blocks.SECURE_GRID_DOOR.get()));
        this.add((Block)JSV1Blocks.GRID_DOOR.get(), this.createDoorTable((Block)JSV1Blocks.GRID_DOOR.get()));
        this.add((Block)JSV2Blocks.LAB_DOOR.get(), this.createDoorTable((Block)JSV2Blocks.LAB_DOOR.get()));
        this.add((Block)JSV2Blocks.HIGH_SECURITY_DOOR.get(), this.createDoorTable((Block)JSV2Blocks.HIGH_SECURITY_DOOR.get()));
        this.dropSimpleSelf(JSV1Blocks.FACILITY_CONCRETE);
        this.dropSimpleSelf(JSV1Blocks.FACILITY_CONCRETE_BRICKS);
        this.dropSimpleSelf(JSV1Blocks.FACILITY_CONCRETE_BRICKS_CRACKED);
        this.dropSimpleSelf(JSV1Blocks.FACILITY_CONCRETE_BRICKS_MOSSY);
        this.dropSimpleSelf(JSV1Blocks.FACILITY_CONCRETE_CRACKED);
        this.dropSimpleSelf(JSV1Blocks.FACILITY_CONCRETE_MOSSY);
        this.dropSimpleSelf(JSV1Blocks.FACILITY_CONCRETE_PANEL);
        this.dropSimpleSelf(JSV1Blocks.FACILITY_CONCRETE_PANEL_MOSSY);
        this.dropSelf((Block)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get());
        this.dropSelf((Block)JSV1Blocks.FACILITY_CONCRETE_PILLAR_CRACKED.get());
        this.dropSelf((Block)JSV1Blocks.FACILITY_CONCRETE_PILLAR_MOSSY.get());
        this.dropSelf((Block)JSBlocks.BENCH_OAK_LOG.get());
        this.dropSelf((Block)JSBlocks.BENCH_SPRUCE_LOG.get());
        this.dropSelf((Block)JSBlocks.BENCH_BIRCH_LOG.get());
        this.dropSelf((Block)JSBlocks.BENCH_JUNGLE_LOG.get());
        this.dropSelf((Block)JSBlocks.BENCH_ACACIA_LOG.get());
        this.dropSelf((Block)JSBlocks.BENCH_DARK_OAK_LOG.get());
        this.dropSelf((Block)JSBlocks.BENCH_MANGROVE_LOG.get());
        this.dropSelf((Block)JSBlocks.BENCH_CHERRY_LOG.get());
        this.dropSelf((Block)JSBlocks.BENCH_CRIMSON_STEM.get());
        this.dropSelf((Block)JSBlocks.BENCH_WARPED_STEM.get());
        this.dropSelf((Block)JSV1Blocks.BENCH_ARAUCARIOXYLON.get());
        this.dropSelf((Block)JSV1Blocks.BENCH_GORDONOPTERIS.get());
        this.dropSelf((Block)JSV1Blocks.BENCH_LEPIDODENDRON.get());
        this.dropSelf((Block)JSV1Blocks.BENCH_SPINIFRUCTUS.get());
        this.initFossil();
        this.dropSelf((Block)JSV2Blocks.MUD.get());
        this.dropSelf((Block)JSV2Blocks.VOLCANIC_MAGMA.get());
        this.dropSelf((Block)JSV2Blocks.FUMAROLE.get());
        this.dropSelf((Block)JSV2Blocks.VOLCANIC_ROCK.get());
        this.dropSelf((Block)JSV2Blocks.GEYSER_BLOCK.get());
        this.add((Block)JSV2Blocks.DEAD_WOOD.get(), LootTable.lootTable().setParamSet(LootContextParamSets.BLOCK).withPool(LootPool.lootPool().when(this.hasSilkTouch().invert()).setRolls((NumberProvider)new ConstantValue(2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STICK))).withPool(LootPool.lootPool().when(this.hasSilkTouch()).setRolls((NumberProvider)new ConstantValue(1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)JSV2Blocks.DEAD_WOOD.get())))));
        this.add((Block)JSV2Blocks.BURNT_LOG.get(), LootTable.lootTable().setParamSet(LootContextParamSets.BLOCK).withPool(LootPool.lootPool().when(this.hasSilkTouch().invert()).setRolls((NumberProvider)new ConstantValue(3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CHARCOAL))).withPool(LootPool.lootPool().when(this.hasSilkTouch()).setRolls((NumberProvider)new ConstantValue(1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)JSV2Blocks.BURNT_LOG.get())))));
        this.add((Block)JSV2Blocks.BURNING_LOG.get(), LootTable.lootTable().setParamSet(LootContextParamSets.BLOCK).withPool(LootPool.lootPool().when(this.hasSilkTouch().invert()).setRolls((NumberProvider)new ConstantValue(2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CHARCOAL))).withPool(LootPool.lootPool().when(this.hasSilkTouch()).setRolls((NumberProvider)new ConstantValue(1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)JSV2Blocks.BURNT_LOG.get())))));
        this.dropSelf((Block)JSV2Blocks.ASH.get());
        this.add((Block)JSV2Blocks.SCORCHED_EARTH.get(), LootTable.lootTable().setParamSet(LootContextParamSets.BLOCK).withPool(LootPool.lootPool().when(this.hasSilkTouch().invert()).setRolls((NumberProvider)new ConstantValue(1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIRT))).withPool(LootPool.lootPool().when(this.hasSilkTouch()).setRolls((NumberProvider)new ConstantValue(1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)JSV2Blocks.SCORCHED_EARTH.get())))));
        this.dropSelf((Block)JSV2Blocks.BIN.get());
        this.dropStoneSet(JSV2Blocks.SHALE);
        this.dropStoneSet(JSV2Blocks.POLISHED_SHALE);
        this.dropStoneSet(JSV2Blocks.MOSSY_POLISHED_SHALE);
        this.dropStoneSet(JSV2Blocks.SHALE_BRICKS);
        this.dropStoneSet(JSV2Blocks.MOSSY_SHALE_BRICKS);
        this.dropStoneSet(JSV2Blocks.INTRICATE_SHALE_BRICKS);
        this.dropStoneSet(JSV2Blocks.MOSSY_INTRICATE_SHALE_BRICKS);
        this.dropStoneSet(JSV2Blocks.RHYOLITE);
        this.dropStoneSet(JSV2Blocks.POLISHED_RHYOLITE);
        this.dropStoneSet(JSV2Blocks.MOSSY_POLISHED_RHYOLITE);
        this.dropStoneSet(JSV2Blocks.RHYOLITE_BRICKS);
        this.dropStoneSet(JSV2Blocks.MOSSY_RHYOLITE_BRICKS);
        this.dropStoneSet(JSV2Blocks.INTRICATE_RHYOLITE_BRICKS);
        this.dropStoneSet(JSV2Blocks.MOSSY_INTRICATE_RHYOLITE_BRICKS);
        this.dropSelf((Block)JSV2Blocks.BRASENITES_KANSENSE_BASIC.get());
        this.dropSelf((Block)JSV2Blocks.BRASENITES_KANSENSE_BLUE.get());
        this.dropSelf((Block)JSV2Blocks.BRASENITES_KANSENSE_LIGHTBLUE.get());
        this.dropSelf((Block)JSV2Blocks.BRASENITES_KANSENSE_MAGENTA.get());
        this.dropSelf((Block)JSV2Blocks.BRASENITES_KANSENSE_ORANGE.get());
        this.dropSelf((Block)JSV2Blocks.BRASENITES_KANSENSE_PINK.get());
        this.dropSelf((Block)JSV2Blocks.BRASENITES_KANSENSE_RED.get());
        this.dropSelf((Block)JSV2Blocks.BRASENITES_KANSENSE_YELLOW.get());
        this.dropSelf((Block)JSV2Blocks.MONTSECHIA.get());
        this.dropSelf((Block)JSV2Blocks.NATHORSTIANA.get());
        this.dropSelf((Block)JSV2Blocks.ORONTIUM_MACKII.get());
        this.dropSelf((Block)JSV2Blocks.GONDWANAGARICITES.get());
        this.dropSelf((Block)JSV2Blocks.MABELIA_BASIC.get());
        this.dropSelf((Block)JSV2Blocks.MABELIA_LIGHTBLUE.get());
        this.dropSelf((Block)JSV2Blocks.MABELIA_ORANGE.get());
        this.dropSelf((Block)JSV2Blocks.MABELIA_PINK.get());
        this.dropSelf((Block)JSV2Blocks.MABELIA_RED.get());
        this.dropSelf((Block)JSV2Blocks.MABELIA_WHITE.get());
        this.dropSelf((Block)JSV2Blocks.MABELIA_YELLOW.get());
        this.add((Block)JSV2Blocks.PLEUROMEIA.get(), this.createDoublePlantDrop((Block)JSV2Blocks.PLEUROMEIA.get()));
        this.add((Block)JSV2Blocks.WILLIAMSONIA.get(), this.createDoublePlantDrop((Block)JSV2Blocks.PLEUROMEIA.get()));
        this.add((Block)JSV2Blocks.ZAMITES.get(), this.createDoublePlantDrop((Block)JSV2Blocks.PLEUROMEIA.get()));
        this.dropSelf((Block)JSV2Blocks.DICKSONIA.get());
        this.dropSelf((Block)JSV2Blocks.DICROIDIUM.get());
        this.dropSelf((Block)JSV2Blocks.SCALY_TREE_FERN.get());
        this.dropSelf((Block)JSV2Blocks.POLE.get());
        this.dropSelf((Block)JSV2Blocks.WIRE_BLOCK.get());
        this.dropWoodSet(JSV2Blocks.DOG_WOOD, (Block)JSV2Blocks.DOG_WOOD_SAPLING.get());
        this.dropSelf((Block)JSV2Blocks.AMBER_BLOCK.get());
    }

    private void dropWoodSet(WoodRegistries woodRegistries, Block sapling) {
        this.dropSelf((Block)woodRegistries.LOG.get());
        this.dropSelf((Block)woodRegistries.WOOD.get());
        this.dropSelf((Block)woodRegistries.STRIPPED_LOG.get());
        this.dropSelf((Block)woodRegistries.STRIPPED_WOOD.get());
        this.dropSelf((Block)woodRegistries.STAIRS.get());
        this.dropSelf((Block)woodRegistries.PRESSURE_PLATE.get());
        this.dropSelf((Block)woodRegistries.BUTTON.get());
        this.dropSelf((Block)woodRegistries.BLOCK.get());
        this.add((Block)woodRegistries.SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.add((Block)woodRegistries.DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
        this.dropWhenSilkTouch((Block)woodRegistries.LEAVES.get());
        this.dropSelf((Block)woodRegistries.FENCE.get());
        this.dropSelf((Block)woodRegistries.FENCE_GATE.get());
        this.dropSelf((Block)woodRegistries.TRAPDOOR.get());
        this.dropSelf((Block)woodRegistries.SIGN.get());
        this.dropSelf((Block)woodRegistries.WALL_SIGN.get());
        this.dropSelf((Block)woodRegistries.HANGING_SIGN.get());
        this.dropSelf((Block)woodRegistries.HANGING_SIGN_WALL.get());
        if (sapling != null) {
            this.dropSelf(sapling);
        }
    }

    private void dropStoneSet(StoneRegistries stoneRegistries) {
        this.dropSelf((Block)stoneRegistries.BLOCK.get());
        this.dropSelf((Block)stoneRegistries.WALL.get());
        this.dropSelf((Block)stoneRegistries.STAIRS.get());
        this.dropSelf((Block)stoneRegistries.SLAB.get());
        this.dropSelf((Block)stoneRegistries.PRESSURE_PLATE.get());
        this.dropSelf((Block)stoneRegistries.BUTTON.get());
    }

    private void dropSimpleSelf(BasicBlockSetRegistries blockSetRegistries) {
        this.dropSelf((Block)blockSetRegistries.getBLOCK().get());
        this.dropSelf((Block)blockSetRegistries.getSLAB().get());
        this.dropSelf((Block)blockSetRegistries.getSTAIRS().get());
        this.dropSelf((Block)blockSetRegistries.getWALL().get());
    }

    protected LootTable.Builder createDoublePlantDrop(Block sheared) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)sheared).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))));
    }

    private void initFossil() {
        for (Era value : Era.values()) {
            LootPool.Builder poolBuilder;
            if (value.isHasFossilOre()) {
                poolBuilder = LootPool.lootPool().when(this.hasSilkTouch().invert()).setRolls((NumberProvider)UniformGenerator.between((float)4.0f, (float)8.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE).setWeight(60)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COBBLESTONE).setWeight(70)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLINT).setWeight(80));
                value.getRegistryMap().forEach((possibleResult, itemDeferredItem) -> {
                    if (possibleResult != PossibleResult.MARINE_DEPOSIT) {
                        if (!possibleResult.isAmber()) {
                            poolBuilder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)itemDeferredItem.get())).setWeight(40).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.registrylookup.getOrThrow(Enchantments.FORTUNE))));
                        } else {
                            poolBuilder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)itemDeferredItem.get())).setWeight(50).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.registrylookup.getOrThrow(Enchantments.FORTUNE))));
                        }
                    }
                });
                this.add((Block)value.getFossilOre().get(), LootTable.lootTable().setParamSet(LootContextParamSets.BLOCK).withPool(LootPool.lootPool().when(this.hasSilkTouch()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)value.getFossilOre().get())))).withPool(poolBuilder));
            }
            if (!value.isHasMarineOre()) continue;
            poolBuilder = LootPool.lootPool().when(this.hasSilkTouch().invert()).setRolls((NumberProvider)UniformGenerator.between((float)4.0f, (float)8.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE).setWeight(60)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COBBLESTONE).setWeight(70)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLINT).setWeight(80));
            value.getRegistryMap().forEach((possibleResult, itemDeferredItem) -> {
                if (possibleResult == PossibleResult.MARINE_DEPOSIT) {
                    if (!possibleResult.isAmber()) {
                        poolBuilder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)itemDeferredItem.get())).setWeight(40).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.registrylookup.getOrThrow(Enchantments.FORTUNE))));
                    } else {
                        poolBuilder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)itemDeferredItem.get())).setWeight(50).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.registrylookup.getOrThrow(Enchantments.FORTUNE))));
                    }
                }
            });
            this.add((Block)value.getMarineOre().get(), LootTable.lootTable().setParamSet(LootContextParamSets.BLOCK).withPool(LootPool.lootPool().when(this.hasSilkTouch()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)value.getFossilOre().get())))).withPool(poolBuilder));
        }
    }

    private void dropColoredSelf(ColoredRegistries c) {
        this.dropSelf((Block)c.BLACK.get());
        this.dropSelf((Block)c.BLUE.get());
        this.dropSelf((Block)c.BROWN.get());
        this.dropSelf((Block)c.CYAN.get());
        this.dropSelf((Block)c.GREEN.get());
        this.dropSelf((Block)c.GREY.get());
        this.dropSelf((Block)c.LIGHTBLUE.get());
        this.dropSelf((Block)c.LIGHTGREY.get());
        this.dropSelf((Block)c.LIME.get());
        this.dropSelf((Block)c.MAGENTA.get());
        this.dropSelf((Block)c.ORANGE.get());
        this.dropSelf((Block)c.PINK.get());
        this.dropSelf((Block)c.PURPLE.get());
        this.dropSelf((Block)c.RED.get());
        this.dropSelf((Block)c.WHITE.get());
        this.dropSelf((Block)c.YELLOW.get());
    }

    private void dropColoredDoor(ColoredRegistries c) {
        this.add((Block)c.BLACK.get(), this.createDoorTable((Block)c.BLACK.get()));
        this.add((Block)c.BLUE.get(), this.createDoorTable((Block)c.BLUE.get()));
        this.add((Block)c.BROWN.get(), this.createDoorTable((Block)c.BROWN.get()));
        this.add((Block)c.CYAN.get(), this.createDoorTable((Block)c.CYAN.get()));
        this.add((Block)c.GREEN.get(), this.createDoorTable((Block)c.GREEN.get()));
        this.add((Block)c.GREY.get(), this.createDoorTable((Block)c.GREY.get()));
        this.add((Block)c.LIGHTBLUE.get(), this.createDoorTable((Block)c.LIGHTBLUE.get()));
        this.add((Block)c.LIGHTGREY.get(), this.createDoorTable((Block)c.LIGHTGREY.get()));
        this.add((Block)c.LIME.get(), this.createDoorTable((Block)c.LIME.get()));
        this.add((Block)c.MAGENTA.get(), this.createDoorTable((Block)c.MAGENTA.get()));
        this.add((Block)c.ORANGE.get(), this.createDoorTable((Block)c.ORANGE.get()));
        this.add((Block)c.PINK.get(), this.createDoorTable((Block)c.PINK.get()));
        this.add((Block)c.PURPLE.get(), this.createDoorTable((Block)c.PURPLE.get()));
        this.add((Block)c.RED.get(), this.createDoorTable((Block)c.RED.get()));
        this.add((Block)c.WHITE.get(), this.createDoorTable((Block)c.WHITE.get()));
        this.add((Block)c.YELLOW.get(), this.createDoorTable((Block)c.YELLOW.get()));
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.entrySet().stream().filter(e -> ((ResourceKey)e.getKey()).location().getNamespace().equals("jurassicsaga")).map(Map.Entry::getValue).collect(Collectors.toList());
    }
}

