/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.v1.animal.JSV1Animals;
import jp.jurassicsaga.server.v2.animal.JSV2Animals;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.TravelersAnimalRegistry;

public class JSAnimals {
    private static final HashMap<Era, ArrayList<JSAnimal<?>>> animalMap = new HashMap();
    private static ArrayList<JSAnimal<?>> animals;

    public static void init() {
        new JSV1Animals();
        new JSV2Animals();
    }

    public static JSAnimal<?> getAnimal(String animalName) {
        String modId = animalName.contains(":") ? animalName.split(":")[0] : "jurassicsaga";
        for (TravelersAnimal animal : (Set)TravelersAnimalRegistry.getANIMALS().get(modId)) {
            JSAnimal jsAnimal;
            if (!(animal instanceof JSAnimal) || !(jsAnimal = (JSAnimal)animal).getAnimalAttributes().getAnimalName().equalsIgnoreCase(animalName.contains(":") ? animalName.split(":")[1] : animalName)) continue;
            return jsAnimal;
        }
        return null;
    }

    public static ArrayList<JSAnimal<?>> getAnimals() {
        if (animals != null && !animals.isEmpty()) {
            return animals;
        }
        ArrayList newAnimalList = new ArrayList();
        TravelersAnimalRegistry.getANIMALS().forEach((string, travelersAnimals) -> {
            for (TravelersAnimal travelersAnimal : travelersAnimals) {
                if (!(travelersAnimal instanceof JSAnimal)) continue;
                JSAnimal jsAnimal = (JSAnimal)travelersAnimal;
                newAnimalList.add(jsAnimal);
            }
        });
        animals = newAnimalList;
        animals.sort(Comparator.comparing(jsAnimal -> jsAnimal.getAnimalAttributes().getAnimalName()));
        return newAnimalList;
    }

    public static boolean hasEra(Era era) {
        return animalMap.containsKey((Object)era);
    }

    public static void setEraEnabled(Era era, JSAnimal<?> animal) {
        if (!animalMap.containsKey((Object)era)) {
            animalMap.put(era, new ArrayList());
        }
        ArrayList<JSAnimal<?>> jsAnimals = animalMap.get((Object)era);
        jsAnimals.add(animal);
        jsAnimals.sort(Comparator.comparing(jsAnimal -> jsAnimal.getAnimalAttributes().getAnimalName()));
        animalMap.put(era, jsAnimals);
    }

    public static HashMap<Era, ArrayList<JSAnimal<?>>> getAnimalMap() {
        return animalMap;
    }
}

