/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.bases;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSFlyingNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGroundNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSLookControl;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.control.TravelersFlyingMoveControl;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;

public class JSAvianBase
extends JSAnimalBase {
    public static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(JSAvianBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DIVING = SynchedEntityData.defineId(JSAvianBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> WANTS_TO_LAND = SynchedEntityData.defineId(JSAvianBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> FLAPPING = SynchedEntityData.defineId(JSAvianBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> GLIDING = SynchedEntityData.defineId(JSAvianBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private JSFlyingNavigation flyingPathNavigation;
    private JSGroundNavigation groundPathNavigation;
    protected final TravelersFlyingMoveControl flyingMoveControl;
    protected final TravelersMoveControl animalMoveControl = new TravelersMoveControl((SmartAnimalBase)this, this.getAnimal());
    protected float stamina = 1.0f;
    protected float staminaDrainRate = 0.0015f;
    protected float staminaRegenRate = 0.0025f;
    private int takeoffCooldown = 0;
    private int landingCooldown = 0;

    public JSAvianBase(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.flyingMoveControl = new TravelersFlyingMoveControl((SmartAnimalBase)this, this.getAnimal(), this.hoversInPlace());
        this.moveController = this.animalMoveControl;
        this.lookControl = new JSLookControl(this);
    }

    public JSFlyingNavigation getFlyingPathNavigation() {
        if (this.flyingPathNavigation == null) {
            this.flyingPathNavigation = new JSFlyingNavigation(this, this.level());
        }
        return this.flyingPathNavigation;
    }

    public JSGroundNavigation getGroundPathNavigation() {
        if (this.groundPathNavigation == null) {
            this.groundPathNavigation = new JSGroundNavigation(this, this.level());
        }
        return this.groundPathNavigation;
    }

    @Override
    protected TravelersPathNavigation createNavigationController(Level level) {
        return this.getGroundPathNavigation();
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLYING, (Object)false);
        builder.define(DIVING, (Object)false);
        builder.define(WANTS_TO_LAND, (Object)true);
        builder.define(FLAPPING, (Object)false);
        builder.define(GLIDING, (Object)false);
    }

    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING);
    }

    public boolean wantsToLand() {
        return (Boolean)this.entityData.get(WANTS_TO_LAND);
    }

    public boolean isDiving() {
        return (Boolean)this.entityData.get(DIVING);
    }

    public void setDiving(boolean diving) {
        this.entityData.set(DIVING, (Object)diving);
    }

    public void travel(@NotNull Vec3 travelVector) {
        if (this.isFlying()) {
            if (this.isControlledByLocalInstance()) {
                if (this.isInLava()) {
                    this.moveRelative(0.02f, travelVector);
                    this.move(MoverType.SELF, this.getDeltaMovement());
                    this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
                } else {
                    float f = 0.95f;
                    float speed = this.getSpeed();
                    this.moveRelative(speed, travelVector);
                    this.move(MoverType.SELF, this.getDeltaMovement());
                    this.setDeltaMovement(this.getDeltaMovement().multiply((double)0.91f, (double)f, (double)0.91f));
                }
            }
        } else {
            super.travel(travelVector);
        }
    }

    @Override
    public float getSpeed() {
        return this.isFlying() ? (float)this.getAttributes().getBaseValue(Attributes.FLYING_SPEED) : super.getSpeed();
    }

    protected void checkFallDamage(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
        if (!this.isFlying()) {
            super.checkFallDamage(y, onGround, state, pos);
        }
    }

    @Override
    public boolean onClimbable() {
        return super.onClimbable() && !this.isFlying();
    }

    @Override
    public void jumpFromGround() {
        if (!this.isFlying()) {
            super.jumpFromGround();
        }
    }

    public void setJumping(boolean jumping) {
        if (!this.isFlying()) {
            super.setJumping(jumping);
        }
    }

    @NotNull
    public JumpControl getJumpControl() {
        return new FlyingJumpControl(this);
    }

    protected boolean hoversInPlace() {
        return false;
    }

    @Override
    public void aiStep() {
        if (this.takeoffCooldown > 0) {
            --this.takeoffCooldown;
        }
        if (this.landingCooldown > 0) {
            --this.landingCooldown;
        }
        this.handleStamina();
        super.aiStep();
        this.setNoGravity(this.hoversInPlace());
        if (this.isDead() && !this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.075, 0.0));
            return;
        }
        if (this.isSleeping() || this.isResting()) {
            if (!this.onGround() && this.isFlying()) {
                this.entityData.set(WANTS_TO_LAND, (Object)true);
            } else if (this.isFlying() && this.onGround()) {
                this.setFlying(false);
            }
            return;
        }
        if (this.disableFlyTransitions() || this.getModules().getMetabolismModule().isThirsty()) {
            if (!this.isFlying()) {
                this.setFlying(true);
            }
            return;
        }
        if (this.getDeltaMovement().y < -10.0 && !this.isFlying() || this.isInWater()) {
            this.setFlying(true);
        }
        if (this.isFlying()) {
            this.handleFlying();
            this.tryLanding();
        } else {
            this.tryTakeoff();
        }
    }

    private void handleStamina() {
        if (this.isFlying()) {
            this.stamina = Math.max(0.0f, this.stamina - this.staminaDrainRate);
            if (this.stamina <= 0.0f) {
                this.entityData.set(WANTS_TO_LAND, (Object)true);
            }
        } else if (this.onGround() || this.hasSolidBelow()) {
            this.stamina = Math.min(1.0f, this.stamina + this.staminaRegenRate);
        }
    }

    private void handleFlying() {
        boolean goingUpOrFlat;
        Vec3 motion = this.getDeltaMovement();
        boolean bl = this.getNavigationController().isDone() ? motion.y > (double)-0.06f : (goingUpOrFlat = motion.y >= -0.1);
        if (goingUpOrFlat) {
            this.setFlapping(true);
            this.setGliding(false);
        } else {
            this.setFlapping(false);
            this.setGliding(true);
        }
        if (this.getNavigationController().isDone()) {
            if (motion.y < 0.0) {
                Vec3 forward = this.getLookAngle().normalize().scale((double)this.getSpeed());
                this.setDeltaMovement(forward.add(0.0, -0.1, 0.0));
            } else if (!this.hoversInPlace()) {
                this.setDeltaMovement(motion.add(0.0, -0.005, 0.0));
            } else {
                this.setDeltaMovement(new Vec3(motion.x, 0.01, motion.z));
            }
        }
        if (!this.wantsToLand() && this.stamina < 0.5f && this.random.nextFloat() < 0.01f) {
            this.entityData.set(WANTS_TO_LAND, (Object)true);
        }
    }

    public boolean isFlapping() {
        return (Boolean)this.entityData.get(FLAPPING);
    }

    public boolean isGliding() {
        return (Boolean)this.entityData.get(GLIDING);
    }

    private void setFlapping(boolean val) {
        this.entityData.set(FLAPPING, (Object)val);
    }

    private void setGliding(boolean val) {
        this.entityData.set(GLIDING, (Object)val);
    }

    private void tryLanding() {
        if (this.landingCooldown > 0) {
            return;
        }
        if ((this.onGround() || this.hasSolidBelow()) && this.wantsToLand()) {
            this.setFlying(false);
            this.landingCooldown = 40;
        }
    }

    private void tryTakeoff() {
        if (this.takeoffCooldown > 0) {
            return;
        }
        if (this.stamina > 0.95f && this.random.nextFloat() < 0.02f) {
            this.setFlying(true);
            this.takeoffCooldown = 60;
        }
    }

    public void setFlying(boolean flying) {
        if (this.isFlying() == flying) {
            return;
        }
        this.entityData.set(FLYING, (Object)flying);
        this.entityData.set(WANTS_TO_LAND, (Object)(!flying ? 1 : 0));
        if (flying) {
            this.moveController = this.flyingMoveControl;
            if (this.getNavigationController() == this.getGroundPathNavigation()) {
                this.getGroundPathNavigation().stop();
                this.getGroundPathNavigation().setLookingForPath(false);
            }
            this.navigationController = this.getFlyingPathNavigation();
            if (this.isInWater()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.075, 0.0));
            } else {
                Vec3 mv = this.getDeltaMovement();
                this.setDeltaMovement(new Vec3(mv.x, 0.0, mv.z));
            }
        } else {
            this.moveController = this.animalMoveControl;
            this.navigationController = this.getGroundPathNavigation();
            this.setDeltaMovement(Vec3.ZERO);
            this.takeoffCooldown = 60;
        }
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("js.isFlying", this.isFlying());
        tag.putBoolean("js.isLanding", this.wantsToLand());
        tag.putFloat("js.stamina", this.stamina);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        boolean flying = tag.getBoolean("js.isFlying");
        this.entityData.set(WANTS_TO_LAND, (Object)tag.getBoolean("js.isLanding"));
        if (tag.contains("js.stamina")) {
            this.stamina = tag.getFloat("js.stamina");
        }
        this.setFlying(flying);
    }

    public boolean disableFlyTransitions() {
        return false;
    }

    public int getDistanceOfGround() {
        return -1;
    }

    private static class FlyingJumpControl
    extends JumpControl {
        private final JSAvianBase base;

        public FlyingJumpControl(JSAvianBase mob) {
            super((Mob)mob);
            this.base = mob;
        }

        public void jump() {
            this.jump = true;
        }

        public void tick() {
            if (this.base.isFlying()) {
                if (this.base.jumping) {
                    this.base.setJumping(false);
                    this.jump = false;
                }
            } else {
                this.base.setJumping(this.jump);
                this.jump = false;
            }
        }
    }
}

