/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.bases;

import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;

public abstract class JSEntityDataHolder
extends SmartAnimalBase {
    public static final EntityDataAccessor<Boolean> leaping = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> male = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> refreshData = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> panicking = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> resting = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> sleeping = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> stalking = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> observing = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> dead = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> onGround = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> additionalScale = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> aggression = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<String> textureVariant = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<CompoundTag> gene_data = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public static final EntityDataAccessor<CompoundTag> growth_data = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public static final EntityDataAccessor<CompoundTag> metabolism_data = SynchedEntityData.defineId(JSEntityDataHolder.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public int curInjuredTicks;
    public int curAttackTicks;
    public int curEatTicks;
    public int curDrinkTicks;
    public BlockPos lastDrankAtPos;
    public BlockPos lastAteAtPos;
    public LivingEntity lastHurtBy;

    protected JSEntityDataHolder(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(male, (Object)false);
        builder.define(panicking, (Object)false);
        builder.define(refreshData, (Object)false);
        builder.define(resting, (Object)false);
        builder.define(sleeping, (Object)false);
        builder.define(stalking, (Object)false);
        builder.define(observing, (Object)false);
        builder.define(dead, (Object)false);
        builder.define(onGround, (Object)false);
        builder.define(additionalScale, (Object)Float.valueOf(0.0f));
        builder.define(aggression, (Object)Float.valueOf(0.0f));
        builder.define(textureVariant, (Object)JSVariants.NONE.getName());
        builder.define(gene_data, (Object)new CompoundTag());
        builder.define(growth_data, (Object)new CompoundTag());
        builder.define(metabolism_data, (Object)new CompoundTag());
        builder.define(leaping, (Object)false);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        boolean grounded = this.checkOnGround();
        this.entityData.set(onGround, (Object)grounded);
    }

    public boolean hurt(DamageSource source, float amount) {
        return super.hurt(source, amount);
    }

    public boolean isLeaping() {
        return (Boolean)this.entityData.get(leaping);
    }

    public void setLeaping(boolean isLeaping) {
        this.entityData.set(leaping, (Object)isLeaping);
    }

    private boolean checkOnGround() {
        AABB box = this.getBoundingBox();
        double feetY = box.minY - 0.05;
        AABB groundCheck = new AABB(box.minX, feetY, box.minZ, box.maxX, box.minY + 0.05, box.maxZ);
        for (VoxelShape shape : this.level().getBlockCollisions((Entity)this, groundCheck)) {
            if (shape.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean onGround() {
        return (Boolean)this.entityData.get(onGround);
    }

    public void setOnGround(boolean onGround) {
    }

    public void setOnGroundWithMovement(boolean onGround, Vec3 movement) {
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("js.animal.dead", ((Boolean)this.entityData.get(dead)).booleanValue());
        this.saveBlockPos("js.lastdrankat", this.lastDrankAtPos, compound);
        this.saveBlockPos("js.lastateat", this.lastAteAtPos, compound);
    }

    private void saveBlockPos(String string, BlockPos pos, CompoundTag compound) {
        if (pos != null) {
            compound.putInt(string + ".x", pos.getX());
            compound.putInt(string + ".y", pos.getY());
            compound.putInt(string + ".z", pos.getZ());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(dead, (Object)compound.getBoolean("js.animal.dead"));
        this.lastDrankAtPos = this.readBlockPos(compound, "js.lastdrankat");
        this.lastAteAtPos = this.readBlockPos(compound, "js.lastateat");
    }

    private BlockPos readBlockPos(CompoundTag compound, String string) {
        if (!compound.contains(string + ".x")) {
            return null;
        }
        return new BlockPos(compound.getInt(string + ".x"), compound.getInt(string + ".y"), compound.getInt(string + ".z"));
    }

    void setDead(boolean aBoolean) {
        this.entityData.set(dead, (Object)aBoolean);
    }

    public void setIsPanicking(boolean isPanicking) {
        this.entityData.set(panicking, (Object)isPanicking);
    }

    public boolean isPanicking() {
        return (Boolean)this.entityData.get(panicking);
    }

    public void setResting(boolean isResting) {
        this.entityData.set(resting, (Object)isResting);
    }

    public boolean isResting() {
        return (Boolean)this.entityData.get(resting);
    }

    public void setSleeping(boolean isSleeping) {
        this.entityData.set(sleeping, (Object)isSleeping);
    }

    public boolean isSleeping() {
        return (Boolean)this.entityData.get(sleeping);
    }

    public void setStalking(boolean isStalking) {
        this.entityData.set(stalking, (Object)isStalking);
    }

    public void setObserving(boolean isObserving) {
        this.entityData.set(observing, (Object)isObserving);
    }

    public boolean isObserving() {
        return (Boolean)this.entityData.get(observing);
    }

    public float getAggression() {
        return ((Float)this.entityData.get(aggression)).floatValue();
    }

    public void setAggression(float aggresionValue) {
        this.entityData.set(aggression, (Object)Float.valueOf(aggresionValue));
    }

    public float maxUpStep() {
        return 1.0f;
    }

    public LivingEntity getLastHurtBy() {
        return this.lastHurtBy;
    }

    public void setLastHurtBy(LivingEntity lastHurtBy) {
        this.lastHurtBy = lastHurtBy;
    }
}

