/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.modules.obj;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.client.base.util.JSClientUtils;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSAnimalModuleBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.FeedbackType;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSMetabolismModule;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;

public class JSFeedbackModule
extends JSAnimalModuleBase {
    private FeedbackType currentFeedback = null;
    private int particleCooldown = 0;

    public JSFeedbackModule(JSAnimalBase owner) {
        super(owner);
    }

    @Override
    public void clientTick() {
        if (this.owner.level().isClientSide && this.currentFeedback != null && JSCommon.config.visibleFeedback) {
            JSClientUtils.spawnAtEntity(this.owner.level(), this.owner, (ParticleOptions)this.currentFeedback.getParticleTypeSupplier().get(), 0.5);
        }
        if (this.owner.tickCount % 20 != 0) {
            return;
        }
        if (this.owner.isPanicking() || this.owner.getFleeTarget() != null) {
            this.currentFeedback = FeedbackType.PANIC;
            return;
        }
        JSMetabolismModule metabolism = this.owner.getModules().getMetabolismModule();
        if (metabolism.isThirstEnabled() && metabolism.isThirsty()) {
            this.currentFeedback = FeedbackType.THIRSTY;
            return;
        }
        if (metabolism.isHungerEnabled() && metabolism.isHungry()) {
            this.currentFeedback = FeedbackType.HUNGRY;
            return;
        }
        ActiveTime sleeptime = this.owner.getAnimal().getAnimalAttributes().getMetabolismProperties().getActiveTime();
        if (!sleeptime.isActiveNow(this.owner.level().getDayTime())) {
            this.currentFeedback = FeedbackType.ZZZ;
        } else if (this.currentFeedback == FeedbackType.ZZZ) {
            this.currentFeedback = null;
        }
    }

    @Override
    public void saveNbt(CompoundTag nbt) {
    }

    @Override
    public void loadNbt(CompoundTag nbt) {
    }

    @Override
    public void init() {
    }
}

