/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.modules.obj;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSAnimalModuleBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSMetabolismModule;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import travelers.server.animal.entity.task.TaskGoal;

public class JSHerdModule
extends JSAnimalModuleBase {
    private JSAnimalBase herdLeader;
    private UUID herdLeaderUUID;
    private final Set<JSAnimalBase> followers = new HashSet<JSAnimalBase>();
    private boolean isMovingToLeader;
    private int checkCooldown;
    private int lookCooldown = 40;
    private int maxDistance;
    private int maxHerdSize;
    private double minLeaderDist;
    private JSSocialGroupProperties<?> socialProps;
    private Class<? extends LivingEntity>[] compatTypes;
    private int trueLeaderCooldown = 0;
    private JSAnimalBase cachedTrueLeader;
    private int leaderResolveCooldown = 0;
    private boolean herdStrengthDirty = true;
    private double cachedHerdStrength = 0.0;
    private CompletableFuture<Void> herdMergeFuture;

    public JSHerdModule(JSAnimalBase owner) {
        super(owner);
        if (owner.getAnimal().getAnimalAttributes().getSocialGroupProperties().getMaxHerdSize() < 1) {
            this.disable();
        }
    }

    public void setHerdLeader(JSAnimalBase leader) {
        this.herdLeader = leader;
        this.herdLeaderUUID = leader != null ? leader.getUUID() : null;
    }

    @Override
    public void saveNbt(CompoundTag nbt) {
        if (this.herdLeaderUUID != null) {
            nbt.putString("js.herd.herdleader", this.herdLeaderUUID.toString());
        }
    }

    @Override
    public void loadNbt(CompoundTag nbt) {
        String s = nbt.getString("js.herd.herdleader");
        if (!s.isEmpty()) {
            this.herdLeaderUUID = UUID.fromString(s);
        }
    }

    @Override
    public void init() {
        this.socialProps = this.owner.getAnimal().getAnimalAttributes().getSocialGroupProperties();
        this.maxDistance = (int)this.socialProps.getMaxDistanceToPackLeader();
        this.minLeaderDist = this.socialProps.getMinDistanceToPackLeader();
        this.maxHerdSize = this.socialProps.getMaxHerdSize();
        this.compatTypes = this.socialProps.getHerdCompatible().toArray(new Class[0]);
        this.checkCooldown = 0;
        this.lookCooldown = 40;
    }

    @Override
    public void serverAiStep() {
        this.resolveLeaderByUUID();
        if ((this.owner.tickCount + this.owner.getId()) % 40 == 0) {
            this.ensureTwoWayLink();
        }
        if ((this.owner.tickCount + this.owner.getId()) % 100 == 0) {
            this.cleanupFollowers();
        }
        if (this.isFollower()) {
            this.tickFollower();
        } else {
            this.tickLeader();
        }
    }

    private void tickFollower() {
        if (!this.isEntityValid(this.herdLeader)) {
            this.stopFollowing();
            return;
        }
        if (this.owner.getNavigationController().isDone() && this.isMovingToLeader) {
            this.isMovingToLeader = false;
        }
        if (!this.isMovingToLeader && this.owner.distanceToSqr((Entity)this.herdLeader) > this.minLeaderDist * this.minLeaderDist) {
            if (this.checkCooldown > 0) {
                --this.checkCooldown;
            } else {
                this.tryMoveToLeader();
            }
        }
    }

    private void tryMoveToLeader() {
        JSAvianBase av;
        if (this.owner.isDead()) {
            return;
        }
        if ((this.owner.tickCount + this.owner.getId()) % 5 != 0) {
            return;
        }
        JSAnimalBase jSAnimalBase = this.owner;
        if (jSAnimalBase instanceof JSAvianBase && (av = (JSAvianBase)jSAnimalBase).isDiving()) {
            return;
        }
        if (this.owner.getTarget() != null || this.owner.getFleeTarget() != null) {
            return;
        }
        JSMetabolismModule meta = this.owner.getModules().getMetabolismModule();
        if (meta.isHungry() || meta.isThirsty()) {
            return;
        }
        this.isMovingToLeader = true;
        this.owner.getTaskController().stopTask(TaskGoal.MOVEMENT);
        CompletableFuture moveTask = this.owner.getNavigationController().moveTo((Entity)this.herdLeader);
        if (moveTask != null) {
            moveTask.thenAccept(path -> {
                if (path == null) {
                    this.isMovingToLeader = false;
                    this.checkCooldown = 20;
                } else {
                    this.checkCooldown = 800;
                }
            });
        }
    }

    private void tickLeader() {
        AABB box;
        if (this.lookCooldown > 0) {
            --this.lookCooldown;
            return;
        }
        if (this.herdMergeFuture != null && !this.herdMergeFuture.isDone()) {
            return;
        }
        this.lookCooldown = 200 + this.owner.getRandom().nextInt(100);
        if (this.herdMergeFuture != null && !this.herdMergeFuture.isDone()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.owner.level();
        List candidates = level.getEntitiesOfClass(JSAnimalBase.class, box = this.owner.getBoundingBox().inflate(16.0), this::canHerdWith);
        if (candidates.isEmpty()) {
            return;
        }
        HashSet<JSAnimalBase> leaders = new HashSet<JSAnimalBase>();
        for (JSAnimalBase e : candidates) {
            JSAnimalBase tl = e.getModules().getHerdModule().getTrueLeader();
            if (!this.isEntityValid(tl)) continue;
            leaders.add(tl);
        }
        if (this.isLeader()) {
            leaders.add(this.owner);
        }
        if (leaders.isEmpty()) {
            this.lookCooldown = 200;
            return;
        }
        JSAnimalBase bestLeader = this.owner;
        int bestSize = this.getHerdSize();
        UUID bestId = this.owner.getUUID();
        for (JSAnimalBase l : leaders) {
            int size = l.getModules().getHerdModule().getHerdSize();
            if (size <= bestSize && (size != bestSize || l.getUUID().compareTo(bestId) >= 0)) continue;
            bestLeader = l;
            bestSize = size;
            bestId = l.getUUID();
        }
        JSHerdModule bestMod = bestLeader.getModules().getHerdModule();
        for (JSAnimalBase l : leaders) {
            if (l == bestLeader) continue;
            JSHerdModule lm = l.getModules().getHerdModule();
            if (!lm.followers.isEmpty()) {
                JSAnimalBase[] arr;
                for (JSAnimalBase f : arr = lm.followers.toArray(new JSAnimalBase[0])) {
                    if (bestMod.getHerdSize() >= this.maxHerdSize) break;
                    if (f == null || f.isDead()) continue;
                    f.getModules().getHerdModule().startFollowing(bestLeader);
                }
            }
            if (bestMod.getHerdSize() >= this.maxHerdSize) continue;
            l.getModules().getHerdModule().startFollowing(bestLeader);
        }
        this.lookCooldown = 40;
    }

    public void addFollowers(Stream<? extends JSAnimalBase> newFollowers) {
        newFollowers.forEach(f -> {
            JSHerdModule hm;
            if (f != null && f != this.owner && !f.isDead() && !(hm = f.getModules().getHerdModule()).isFollower()) {
                hm.startFollowing(this.owner);
            }
        });
    }

    public void startFollowing(JSAnimalBase leader) {
        if (leader == this.owner) {
            return;
        }
        JSHerdModule lm = leader.getModules().getHerdModule();
        if (!lm.canBeFollowed()) {
            return;
        }
        this.stopFollowing();
        this.setHerdLeader(leader);
        lm.addFollower(this.owner);
    }

    public void stopFollowing() {
        if (this.herdLeader != null) {
            this.herdLeader.getModules().getHerdModule().removeFollower(this.owner);
        }
        this.herdLeader = null;
        this.herdLeaderUUID = null;
        this.isMovingToLeader = false;
    }

    public void addFollower(JSAnimalBase a) {
        if (a != null && a != this.owner && this.followers.add(a)) {
            this.herdStrengthDirty = true;
        }
    }

    public void removeFollower(JSAnimalBase a) {
        if (this.followers.remove((Object)a)) {
            this.herdStrengthDirty = true;
        }
    }

    public int getHerdSize() {
        return this.isLeader() ? 1 + this.followers.size() : 1;
    }

    public boolean canBeFollowed() {
        return this.followers.size() < this.maxHerdSize;
    }

    public boolean isFollower() {
        return this.herdLeader != null || this.herdLeaderUUID != null;
    }

    public boolean isLeader() {
        return !this.isFollower();
    }

    public JSAnimalBase getTrueLeader() {
        Level level;
        if (this.trueLeaderCooldown > 0) {
            --this.trueLeaderCooldown;
            return this.cachedTrueLeader;
        }
        JSHerdModule cur = this;
        HashSet<UUID> visited = new HashSet<UUID>();
        while (cur.herdLeader == null && cur.herdLeaderUUID != null && (level = cur.owner.level()) instanceof ServerLevel) {
            JSAnimalBase b;
            ServerLevel sl = (ServerLevel)level;
            Entity e = sl.getEntity(cur.herdLeaderUUID);
            JSAnimalBase jSAnimalBase = cur.herdLeader = e instanceof JSAnimalBase && this.isEntityValid(b = (JSAnimalBase)e) ? b : null;
            if (cur.herdLeader != null) continue;
            break;
        }
        while (cur.herdLeader != null && cur.herdLeader != cur.owner) {
            UUID id = cur.herdLeader.getUUID();
            if (!visited.add(id)) {
                this.cachedTrueLeader = null;
                this.trueLeaderCooldown = 200;
                return null;
            }
            cur = cur.herdLeader.getModules().getHerdModule();
            if (cur.isFollower()) continue;
            break;
        }
        if (!this.isEntityValid(cur.owner)) {
            this.cachedTrueLeader = null;
            this.trueLeaderCooldown = 200;
            return null;
        }
        this.cachedTrueLeader = cur.owner;
        this.trueLeaderCooldown = 20;
        return this.cachedTrueLeader;
    }

    public double getHerdStrength() {
        if (!this.herdStrengthDirty) {
            return this.cachedHerdStrength;
        }
        if (this.owner == null || this.owner.isDead()) {
            this.cachedHerdStrength = 0.0;
            this.herdStrengthDirty = false;
            return 0.0;
        }
        double sum = JSHerdModule.getEntityStrength(this.owner);
        for (JSAnimalBase f : this.followers) {
            if (f == null || f.isDead()) continue;
            sum += JSHerdModule.getEntityStrength(f);
        }
        this.cachedHerdStrength = sum;
        this.herdStrengthDirty = false;
        return sum;
    }

    private static double getEntityStrength(JSAnimalBase e) {
        float w = e.getBbWidth();
        return w * w * e.getBbHeight();
    }

    private void resolveLeaderByUUID() {
        JSAnimalBase b;
        if (this.herdLeader != null || this.herdLeaderUUID == null) {
            return;
        }
        Level level = this.owner.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        if (this.leaderResolveCooldown > 0) {
            --this.leaderResolveCooldown;
            return;
        }
        this.leaderResolveCooldown = 10;
        Entity e = sl.getEntity(this.herdLeaderUUID);
        if (e instanceof JSAnimalBase && this.isEntityValid(b = (JSAnimalBase)e)) {
            this.herdLeader = b;
        }
    }

    private void ensureTwoWayLink() {
        if (this.herdLeader != null) {
            JSHerdModule lm = this.herdLeader.getModules().getHerdModule();
            if (!lm.followers.contains((Object)this.owner)) {
                lm.followers.add(this.owner);
            }
        }
    }

    private boolean isEntityValid(JSAnimalBase a) {
        return a != null && !a.isDead() && !a.isRemoved();
    }

    private void cleanupFollowers() {
        if (this.followers.isEmpty()) {
            return;
        }
        UUID myId = this.owner.getUUID();
        this.followers.removeIf(f -> {
            if (f == null || f.isDead() || f.isRemoved()) {
                return true;
            }
            JSHerdModule hm = f.getModules().getHerdModule();
            boolean pointsToUs = hm.herdLeader == this.owner || myId.equals(hm.herdLeaderUUID);
            return !pointsToUs;
        });
        this.herdStrengthDirty = true;
    }

    private boolean canHerdWith(JSAnimalBase other) {
        if (other == this.owner) {
            return false;
        }
        for (Class<? extends LivingEntity> compatType : this.compatTypes) {
            if (!compatType.isInstance((Object)other)) continue;
            return true;
        }
        return false;
    }

    public JSAnimalBase getHerdLeader() {
        return this.herdLeader;
    }

    public UUID getHerdLeaderUUID() {
        return this.herdLeaderUUID;
    }

    public Set<JSAnimalBase> getFollowers() {
        return this.followers;
    }

    public boolean isMovingToLeader() {
        return this.isMovingToLeader;
    }

    public int getCheckCooldown() {
        return this.checkCooldown;
    }

    public int getLookCooldown() {
        return this.lookCooldown;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public int getMaxHerdSize() {
        return this.maxHerdSize;
    }

    public double getMinLeaderDist() {
        return this.minLeaderDist;
    }

    public JSSocialGroupProperties<?> getSocialProps() {
        return this.socialProps;
    }

    public Class<? extends LivingEntity>[] getCompatTypes() {
        return this.compatTypes;
    }

    public int getTrueLeaderCooldown() {
        return this.trueLeaderCooldown;
    }

    public JSAnimalBase getCachedTrueLeader() {
        return this.cachedTrueLeader;
    }

    public int getLeaderResolveCooldown() {
        return this.leaderResolveCooldown;
    }

    public boolean isHerdStrengthDirty() {
        return this.herdStrengthDirty;
    }

    public double getCachedHerdStrength() {
        return this.cachedHerdStrength;
    }

    public CompletableFuture<Void> getHerdMergeFuture() {
        return this.herdMergeFuture;
    }
}

