/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.nav;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGenericNav;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.TravelersAmphibiousNodeEvaluator;

public class JSAmphibiousNavigation
extends TravelersPathNavigation {
    private final boolean shallow;
    private final JSAnimalBase base;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public JSAmphibiousNavigation(JSAnimalBase mob, Level level, boolean shallow) {
        super((SmartAnimalBase)mob, level);
        this.shallow = shallow;
        this.base = mob;
    }

    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        if (JSGenericNav.shouldTargetNextNodeInDirection(this.path, this.base)) {
            if (this.path.getNextNodeIndex() < this.path.getNodes().size()) {
                this.path.advance();
            } else {
                this.stop();
            }
        }
        this.checkStuckOnNode();
        if (this.path != null && this.getPath().isDone()) {
            this.stop();
        }
    }

    public boolean shouldTargetNextNodeInDirection(TravelersPath path, JSAnimalBase mob) {
        if (path == null) {
            return false;
        }
        int nextNodeIndex = path.getNextNodeIndex();
        if (nextNodeIndex >= path.getNodeCount()) {
            return false;
        }
        Vec3 nodeCenter = Vec3.atCenterOf((Vec3i)path.getNodePos(nextNodeIndex));
        Vec3 pos = mob.position();
        return nodeCenter.closerThan(pos, Math.max(0.75, (double)(mob.getBbWidth() / 2.0f)), (double)Math.max(0.75f, mob.getBbHeight()));
    }

    private void checkStuckOnNode() {
        if (this.path == null) {
            return;
        }
        int nodeIndex = this.path.getNextNodeIndex() - 1;
        if (nodeIndex >= 0) {
            if (nodeIndex > this.path.getNodeCount()) {
                return;
            }
            if (this.curNodeIndex == nodeIndex) {
                ++this.nodeStuckTime;
                if (this.nodeStuckTime > 200) {
                    this.stop();
                }
                return;
            }
            this.nodeStuckTime = 0;
            this.curNodeIndex = nodeIndex;
        }
    }

    public void stop() {
        super.stop();
        this.nodeStuckTime = 0;
        this.curNodeIndex = -1;
    }

    protected boolean canUpdatePath() {
        return true;
    }

    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), this.mob.getY(0.5), this.mob.getZ());
    }

    protected double getGroundY(Vec3 p_217794_) {
        return p_217794_.y;
    }

    public boolean isStableDestination(BlockPos p_217799_) {
        return !this.level.getBlockState(p_217799_.below()).isAir();
    }

    public void setCanFloat(boolean p_217801_) {
    }

    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new TravelersAmphibiousNodeEvaluator(this.shallow);
        this.nodeEvaluator.setCanPassDoors(true);
        this.nodeEvaluator.setCanFloat(true);
        return new TravelersPathFinder(this.nodeEvaluator);
    }
}

