/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.nav;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGenericNav;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;

public class JSGroundNavigation
extends TravelersPathNavigation {
    private final JSAnimalBase base;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public JSGroundNavigation(JSAnimalBase mob, Level level) {
        super((SmartAnimalBase)mob, level);
        this.base = mob;
    }

    protected boolean canUpdatePath() {
        return this.mob.onGround() || this.mob.isInLiquid() || this.mob.isPassenger();
    }

    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), (double)this.getSurfaceY(), this.mob.getZ());
    }

    private int getSurfaceY() {
        if (this.mob.isInWater() && !this.mob.onGround()) {
            int i = this.mob.getBlockY();
            BlockState blockstate = this.level.getBlockState(BlockPos.containing((double)this.mob.getX(), (double)i, (double)this.mob.getZ()));
            int j = 0;
            while (blockstate.is(Blocks.WATER)) {
                blockstate = this.level.getBlockState(BlockPos.containing((double)this.mob.getX(), (double)(++i), (double)this.mob.getZ()));
                if (++j <= 16) continue;
                return this.mob.getBlockY();
            }
            return i;
        }
        return Mth.floor((double)(this.mob.getY() + 0.5));
    }

    public boolean isStableDestination(BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState state = this.level.getBlockState(blockpos);
        if (this.base.isInWaterOrBubble()) {
            return true;
        }
        return state.isSolidRender((BlockGetter)this.level, blockpos);
    }

    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        if (JSGenericNav.shouldTargetNextNodeInDirection(this.path, this.base)) {
            if (this.path.getNodes().size() > this.path.getNextNodeIndex() - 1) {
                this.path.advance();
            } else {
                this.stop();
            }
        }
        this.checkStuckOnNode();
        if (this.path != null && this.getPath().isDone()) {
            this.stop();
        }
    }

    private void checkStuckOnNode() {
        if (this.path == null) {
            return;
        }
        int nodeIndex = this.path.getNextNodeIndex() - 1;
        if (nodeIndex >= 0) {
            if (nodeIndex > this.path.getNodeCount()) {
                return;
            }
            if (this.curNodeIndex == nodeIndex) {
                ++this.nodeStuckTime;
                if (this.nodeStuckTime > 200) {
                    this.stop();
                }
                return;
            }
            this.nodeStuckTime = 0;
            this.curNodeIndex = nodeIndex;
        }
    }

    public void stop() {
        super.stop();
        this.nodeStuckTime = 0;
        this.curNodeIndex = -1;
    }

    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new TravelersWalkNodeEvaluator();
        return new TravelersPathFinder(this.nodeEvaluator);
    }

    public void setCanOpenDoors(boolean canOpenDoors) {
        this.nodeEvaluator.setCanOpenDoors(canOpenDoors);
    }

    public boolean canPassDoors() {
        return this.nodeEvaluator.isCanPassDoors();
    }

    public void setCanPassDoors(boolean canPassDoors) {
        this.nodeEvaluator.setCanPassDoors(canPassDoors);
    }

    public boolean canOpenDoors() {
        return this.nodeEvaluator.isCanOpenDoors();
    }

    public void setCanWalkOverFences(boolean canWalkOverFences) {
        this.nodeEvaluator.setCanWalkOverFences(canWalkOverFences);
    }

    public boolean avoidsLight() {
        return ((TravelersWalkNodeEvaluator)this.nodeEvaluator).isTriesToAvoidLight();
    }

    public void setCanClimb(boolean b) {
        ((TravelersWalkNodeEvaluator)this.nodeEvaluator).setCanClimb(b);
    }
}

