/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;

public class JSFloatTask
extends JSTaskBase {
    public JSFloatTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.animal.getNavigationController().setCanFloat(true);
    }

    public boolean shouldRun() {
        if (this.animal.isDead()) {
            return false;
        }
        return this.animal.isInWater() || this.animal.isEyeInFluid(FluidTags.WATER);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void onStart() {
    }

    public void tick() {
        if (!this.animal.isInWater()) {
            return;
        }
        TravelersPathNavigation navigator = this.animal.getNavigationController();
        TravelersPath path = navigator.getPath();
        if (path != null && !this.animal.onGround() && !this.canReachWithoutCollision() && path.getNextNodeIndex() != path.getNodeCount()) {
            BlockPos nextPos = path.getNextNodePos();
            int y = nextPos.getY();
            if (y > this.animal.getBlockY()) {
                this.animal.setDeltaMovement(this.animal.getDeltaMovement().add(0.0, 0.1, 0.0));
            } else if (y < this.animal.getBlockY()) {
                this.animal.setDeltaMovement(this.animal.getDeltaMovement().add(0.0, -0.025, 0.0));
                float percentage = (float)this.animal.getAirSupply() / (float)this.animal.getMaxAirSupply();
                if (percentage > 0.5f) {
                    return;
                }
            }
        }
        if (this.animal.isEyeInFluid(FluidTags.WATER) && this.random.nextFloat() < 0.2f) {
            this.animal.setDeltaMovement(this.animal.getDeltaMovement().add(0.0, 0.02, 0.0));
        }
    }

    private boolean canReachWithoutCollision() {
        AABB aabb = this.animal.getBoundingBox();
        return !this.hasCollisions(aabb.inflate(0.5, 0.0, 0.5));
    }

    private boolean hasCollisions(AABB boundingBox) {
        return !this.animal.level().noBlockCollision((Entity)this.animal, boundingBox);
    }

    public void onStop() {
    }
}

