/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat;

import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatTaskBase;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import travelers.server.animal.entity.task.TaskGoal;

public class JSCombatFollowTask
extends JSCombatTaskBase {
    protected int recomputePathTicks = 10;
    protected int attackCooldown = 0;
    protected boolean triedStalking = false;
    protected boolean shouldStalk;
    protected int attackResetTime = 10;

    public JSCombatFollowTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.ATTACK);
    }

    public JSCombatFollowTask setAttackResetTime(int attackResetTime) {
        this.attackResetTime = attackResetTime;
        return this;
    }

    public JSCombatFollowTask stalk() {
        this.shouldStalk = true;
        return this;
    }

    public boolean shouldRun() {
        Player player;
        LivingEntity livingEntity;
        if (this.animal.isDead() || this.animal.isStaticCreature() || this.animal.isFrozenInPlace() || this.animal.isResting() || this.animal.isSleeping()) {
            return false;
        }
        if (this.animal.getTarget() != null && (livingEntity = this.animal.getTarget()) instanceof Player && (player = (Player)livingEntity).isCreative()) {
            return false;
        }
        return this.animal.getTarget() != null;
    }

    public void onStart() {
        CompletableFuture future;
        LivingEntity target = this.animal.getTarget();
        if (target == null) {
            this.stop();
        }
        if ((future = this.animal.getNavigationController().moveTo((Entity)target)) != null) {
            future.thenAccept(travelersPath -> {
                if (travelersPath != null) {
                    this.animal.setAggressive(true);
                    travelersPath.advance();
                }
            });
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.animal.getTarget() == null) {
            this.stop();
            return;
        }
        if (this.animal.getNavigationController().isDone() || this.recomputePathTicks == 0) {
            CompletableFuture moveTo = this.animal.getNavigationController().moveTo((Entity)this.animal.getTarget());
            if (moveTo != null) {
                moveTo.thenAccept(travelersPath -> {
                    if (travelersPath == null) {
                        this.recomputePathTicks += 10;
                    } else {
                        travelersPath.advance();
                    }
                });
            } else {
                this.recomputePathTicks += 10;
            }
            this.recomputePathTicks += this.random.nextInt(5, 15);
            if (this.attackCooldown == 0) {
                if (this.animal.getTarget().distanceToSqr((Entity)this.animal) <= (double)this.animal.getAttackReach()) {
                    this.animal.attack(this.animal.getTarget());
                    this.recomputePathTicks += 5;
                    this.attackResetTime = this.attackCooldown;
                }
            } else {
                --this.attackCooldown;
            }
        } else if (this.recomputePathTicks > 0) {
            --this.recomputePathTicks;
        }
    }

    public void onStop() {
        this.animal.setAggressive(false);
        this.recomputePathTicks = 10;
    }
}

