/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatTaskBase;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ProcompsognathusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CompsognathusEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskGoal;

public class JSCompyCombatTask
extends JSCombatTaskBase {
    protected int recomputePathTicks = 10;
    protected int attackCooldown = 0;
    protected int attackResetTime = 10;

    public JSCompyCombatTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.ATTACK);
    }

    public boolean shouldRun() {
        if (this.animal.isDead() || this.animal.isStaticCreature() || this.animal.isFrozenInPlace() || this.animal.isResting() || this.animal.isSleeping()) {
            return false;
        }
        List players = this.animal.level().getEntitiesOfClass(LivingEntity.class, this.animal.getBoundingBox().inflate(16.0), a -> this.animal.getModules().getMetabolismModule().canTarget(false, false, (LivingEntity)a));
        LivingEntity closest = null;
        double minDist = Double.MAX_VALUE;
        for (LivingEntity p : players) {
            double dist;
            Player player;
            if (p instanceof Player && (player = (Player)p).isCreative() || !((dist = this.animal.distanceToSqr((Entity)p)) < minDist)) continue;
            minDist = dist;
            closest = p;
        }
        if (closest != null) {
            this.animal.setTarget(closest);
            return true;
        }
        return false;
    }

    public void tick() {
        LivingEntity target = this.animal.getTarget();
        if (target == null) {
            this.stop();
            return;
        }
        this.handleMoveTowards(target, 1.0);
        if (target instanceof LivingEntity) {
            LivingEntity player = target;
            List nearbyCompys = this.animal.level().getEntitiesOfClass(JSAnimalBase.class, this.animal.getBoundingBox().inflate(2.0), animalBase -> animalBase instanceof CompsognathusEntity || animalBase instanceof ProcompsognathusEntity);
            int packSize = (int)((float)nearbyCompys.size() * this.animal.getHealth());
            float playerHealth = player.getHealth();
            this.animal.lookAt((Entity)player, 10.0f, 30.0f);
            if ((float)packSize > playerHealth && this.attackCooldown == 0) {
                this.animal.setAggressive(true);
                if (target.distanceToSqr((Entity)this.animal) <= (double)this.animal.getAttackReach()) {
                    this.animal.attack(target);
                    this.attackCooldown = 20;
                }
            }
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    private void handleMoveTowards(LivingEntity target, double speed) {
        if (this.animal.getNavigationController().isDone() || this.recomputePathTicks == 0) {
            Vec3 targetPos = target.position();
            Vec3 targetLook = target.getLookAngle().normalize();
            double distanceAhead = 1.0;
            Vec3 aheadPos = targetPos.add(targetLook.scale(distanceAhead));
            CompletableFuture moveTo = this.animal.getNavigationController().moveTo(aheadPos.x, aheadPos.y, aheadPos.z);
            if (moveTo != null) {
                moveTo.thenAccept(path -> {
                    if (path == null) {
                        this.recomputePathTicks += 10;
                    } else {
                        int size = path.getNodes().size();
                        for (int i = 0; i < 2; ++i) {
                            path.setNextNodeIndex(Math.min(size, path.getNextNodeIndex() + i));
                        }
                    }
                });
            } else {
                this.recomputePathTicks += 10;
            }
            this.recomputePathTicks += this.random.nextInt(20, 40);
        } else {
            --this.recomputePathTicks;
        }
    }

    public void onStart() {
        LivingEntity target = this.animal.getTarget();
        if (target == null) {
            this.stop();
            return;
        }
        this.handleMoveTowards(target, 1.0);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void onStop() {
        this.animal.setAggressive(false);
        this.animal.setTarget(null);
        this.recomputePathTicks = 10;
    }
}

