/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diet;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import jp.jurassicsaga.server.base.entity.obj.other.IJSEdibleEntity;
import jp.jurassicsaga.server.base.entity.obj.physics.HaybaleEntity;
import jp.jurassicsaga.server.base.entity.obj.physics.MeatEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSFindFoodTask
extends JSTaskBase {
    protected volatile Entity targetEntity;
    private volatile boolean shouldMoveToLastKnown;
    protected boolean setTargetTypes = true;
    protected boolean targetMeatCubes;
    protected boolean targetHayCubes;
    private static final AtomicInteger GLOBAL_PENDING_PATHS = new AtomicInteger();
    private static final int MAX_GLOBAL_CONCURRENT_PATHS = 64;
    private static final int SEARCH_INTERVAL = 20;
    private static final int MAX_CANDIDATES = 16;
    private static final int MAX_REQS_PER_SEARCH = 3;
    private static final int MAX_CONCURRENT_PATHS = 4;
    private static final int CACHE_EXPIRY = 40;
    private static final int MAX_RANGE = 96;
    private static final int VISIBILITY_BUDGET = 8;
    private static final double JITTER = 0.25;
    private final AtomicInteger pendingPathChecks = new AtomicInteger();
    private final List<Entity> candidateCache = Collections.synchronizedList(new ArrayList(32));
    private int cacheTick = -9999;
    private int ticks;
    private int checkCooldown;

    public JSFindFoodTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.METABOLISM);
        this.getGoals().add(TaskGoal.MOVEMENT);
    }

    public TaskPriority getPriority() {
        if (this.animal.isDead()) {
            return TaskPriority.NONE;
        }
        double h = this.animal.getModules().getMetabolismModule().hungerPercentage();
        if (h > 0.8) {
            return TaskPriority.LOW;
        }
        if (h > 0.6) {
            return TaskPriority.MEDIUM;
        }
        if (h > 0.4) {
            return TaskPriority.HIGH;
        }
        if (h > 0.2) {
            return TaskPriority.VERY_HIGH;
        }
        return TaskPriority.DIRECT;
    }

    public boolean shouldRun() {
        if (this.animal.isDead() || this.animal.getModules().getMetabolismModule().getDiet() == null) {
            return false;
        }
        if (!this.animal.getAnimal().getAnimalAttributes().getMetabolismProperties().isHungerEnabled()) {
            return false;
        }
        if (!this.animal.getModules().getMetabolismModule().isHungry()) {
            return false;
        }
        if (this.setTargetTypes) {
            Diet diet = this.animal.getModules().getMetabolismModule().getDiet();
            this.targetMeatCubes = diet.isCanEatMeatCube();
            this.targetHayCubes = diet.isCanEatHaybale();
            this.setTargetTypes = false;
        }
        if (this.targetEntity != null && !this.targetEntity.isAlive()) {
            this.targetEntity = null;
        }
        if (this.targetEntity == null && this.ticks - this.cacheTick >= 20) {
            this.findTargets(128.0f, null);
            this.cacheTick = this.ticks;
        }
        ++this.ticks;
        return this.targetEntity != null || this.shouldMoveToLastKnown;
    }

    public boolean canInterrupt() {
        return this.targetEntity == null;
    }

    public void onStart() {
        if (!this.shouldMoveToLastKnown && this.targetEntity != null && !this.animal.getNavigationController().isLookingForPath()) {
            this.submitPathRequest(this.targetEntity.blockPosition());
        }
    }

    public boolean requiresUpdateEveryTick() {
        return this.targetEntity != null || this.shouldMoveToLastKnown;
    }

    public void tick() {
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
        }
        if (this.shouldMoveToLastKnown) {
            this.shouldMoveToLastKnown = false;
        }
        if (this.isCloseToTarget()) {
            this.eatTarget();
            return;
        }
        if (this.targetEntity != null && this.animal.getNavigationController().isDone() && this.checkCooldown <= 0) {
            this.submitPathRequest(this.targetEntity.blockPosition());
            this.checkCooldown = 40;
        }
    }

    public void cleanUp() {
        super.cleanUp();
        this.shouldMoveToLastKnown = false;
        this.pendingPathChecks.set(0);
        this.candidateCache.clear();
    }

    public void onStop() {
        this.targetEntity = null;
        this.animal.setAggressive(false);
    }

    private void submitPathRequest(BlockPos dest) {
        if (this.pendingPathChecks.get() >= 4) {
            return;
        }
        if (GLOBAL_PENDING_PATHS.get() >= 64) {
            return;
        }
        CompletableFuture future = this.animal.getNavigationController().createPath(dest, 0.0);
        if (future == null) {
            return;
        }
        this.pendingPathChecks.incrementAndGet();
        GLOBAL_PENDING_PATHS.incrementAndGet();
        future.thenAccept(jsPath -> JSFindFoodTask.runOnMainThread(this.animal.level(), () -> {
            try {
                if (jsPath != null) {
                    this.animal.getNavigationController().moveTo(jsPath);
                    this.animal.setAggressive(true);
                }
            }
            finally {
                this.pendingPathChecks.decrementAndGet();
                GLOBAL_PENDING_PATHS.decrementAndGet();
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    private void eatTarget() {
        block6: {
            block8: {
                block7: {
                    this.animal.getNavigationController().stop();
                    if (this.animal.curEatTicks == 0) {
                        this.animal.curEatTicks = 20;
                    }
                    if (this.targetEntity != null) {
                        this.animal.lookAt(EntityAnchorArgument.Anchor.EYES, this.targetEntity.position());
                    }
                    if (this.animal.curEatTicks > 5) break block6;
                    var4_1 = this.targetEntity;
                    if (!(var4_1 instanceof IJSEdibleEntity)) break block7;
                    edible = (IJSEdibleEntity)var4_1;
                    this.animal.getModules().getMetabolismModule().setHunger(this.animal.getModules().getMetabolismModule().getMaxHunger());
                    break block8;
                }
                var4_1 = this.targetEntity;
                if (!(var4_1 instanceof JSAnimalBase)) ** GOTO lbl-1000
                corpse = (JSAnimalBase)var4_1;
                if (this.animal.getModules().getMetabolismModule().canEatCorpse(corpse)) {
                    this.animal.getModules().getMetabolismModule().eatCorpse(corpse);
                } else if ((var4_1 = this.targetEntity) instanceof ItemEntity) {
                    item = (ItemEntity)var4_1;
                    if (this.animal.getModules().getMetabolismModule().eatItem(item.getItem())) {
                        item.discard();
                    }
                }
            }
            this.targetEntity = null;
        }
    }

    public boolean isCloseToTarget() {
        return this.targetEntity != null && JSTaskUtils.isCloseEnough(this.animal, this.targetEntity.blockPosition().getCenter(), 2.0f);
    }

    public void findTargets(float range, Vec3 pos) {
        range = Math.min(Math.max(range, 2.0f), 96.0f);
        Level level = this.animal.level();
        if (this.ticks - this.cacheTick < 40 && !this.candidateCache.isEmpty()) {
            if (ThreadLocalRandom.current().nextDouble() < 0.15) {
                Collections.shuffle(this.candidateCache, ThreadLocalRandom.current());
            }
            return;
        }
        this.candidateCache.clear();
        this.cacheTick = this.ticks;
        AABB box = this.animal.getBoundingBox().inflate((double)range, (double)range * 4.0, (double)range);
        if (pos != null) {
            box = box.move(pos);
        }
        ArrayList<Entity> found = new ArrayList<Entity>(32);
        if (this.targetMeatCubes) {
            found.addAll(level.getEntitiesOfClass(JSAnimalBase.class, box, e -> e.isDead() && !this.animal.is((Entity)e)));
            found.addAll(level.getEntitiesOfClass(MeatEntity.class, box, Entity::isAlive));
        }
        if (this.targetHayCubes) {
            found.addAll(level.getEntitiesOfClass(HaybaleEntity.class, box, Entity::isAlive));
        }
        found.addAll(level.getEntitiesOfClass(ItemEntity.class, box, e -> this.animal.getModules().getMetabolismModule().getDiet().canEatItem(e.getItem())));
        if (found.isEmpty()) {
            return;
        }
        Vec3 aPos = this.animal.position();
        found.removeIf(e -> e == null || !e.isAlive());
        if (found.isEmpty()) {
            return;
        }
        found.sort((a, b) -> {
            double d1 = aPos.distanceToSqr(a.position()) * (1.0 + ThreadLocalRandom.current().nextDouble() * 0.25);
            double d2 = aPos.distanceToSqr(b.position()) * (1.0 + ThreadLocalRandom.current().nextDouble() * 0.25);
            return Double.compare(d1, d2);
        });
        if (found.size() > 16) {
            found = new ArrayList(found.subList(0, 16));
        }
        int visCount = 0;
        for (int i = 0; i < found.size() && visCount < 8; ++i) {
            Entity e2 = (Entity)found.get(i);
            if (!this.cheapCanSee(level, e2)) continue;
            this.candidateCache.add(e2);
            ++visCount;
        }
        if (this.candidateCache.isEmpty()) {
            return;
        }
        int pathReqs = 0;
        for (Entity targ : this.candidateCache) {
            if (this.targetEntity != null || pathReqs >= 3 || this.pendingPathChecks.get() >= 4 || GLOBAL_PENDING_PATHS.get() >= 64) break;
            double distSqr = aPos.distanceToSqr(targ.position());
            if (distSqr > (double)(range * range) * 1.5) continue;
            ++pathReqs;
            this.submitCompetitivePathRequest(level, targ);
        }
        if (pathReqs == 0 && this.targetEntity == null) {
            this.shouldMoveToLastKnown = true;
        }
    }

    private void submitCompetitivePathRequest(Level level, Entity targ) {
        CompletableFuture future = this.animal.getNavigationController().createPath(targ.blockPosition(), 0.0);
        if (future == null) {
            return;
        }
        this.pendingPathChecks.incrementAndGet();
        GLOBAL_PENDING_PATHS.incrementAndGet();
        future.thenAccept(jsPath -> JSFindFoodTask.runOnMainThread(level, () -> {
            try {
                if (jsPath != null && targ.isAlive() && this.cheapCanSee(level, targ)) {
                    if (this.targetEntity == null) {
                        this.targetEntity = targ;
                    } else {
                        double cur = this.animal.position().distanceToSqr(this.targetEntity.position());
                        double neu = this.animal.position().distanceToSqr(targ.position());
                        if (neu + 1.0E-6 < cur && ThreadLocalRandom.current().nextDouble() < 0.65) {
                            this.targetEntity = targ;
                        }
                    }
                }
            }
            finally {
                this.pendingPathChecks.decrementAndGet();
                GLOBAL_PENDING_PATHS.decrementAndGet();
            }
        }));
    }

    private boolean cheapCanSee(Level level, Entity e) {
        Vec3 to;
        if (e == null) {
            return false;
        }
        Vec3 from = this.animal.getEyePosition();
        BlockHitResult res = level.clip(new ClipContext(from, to = e.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.animal));
        return res.getType() != HitResult.Type.BLOCK;
    }

    private static void runOnMainThread(Level level, Runnable r) {
        MinecraftServer srv = level.getServer();
        Objects.requireNonNullElseGet(srv, Minecraft::getInstance).execute(r);
    }
}

