/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSFindWaterTask
extends JSTaskBase {
    private Vec3 targetPos;
    private Vec3 targetWater;
    private int drinkingTicks;
    private int ticks;
    private int lastSearchTick = -9999;
    private int checkCooldown;
    private boolean pathStarted;
    private boolean scanning;
    private final AtomicInteger pendingPaths = new AtomicInteger();
    private final List<Candidate> candidates = Collections.synchronizedList(new ArrayList(32));
    private final Deque<BlockPos> pendingProbes = new ArrayDeque<BlockPos>();
    private static final int SEARCH_INTERVAL = 20;
    private static final int MAX_CANDIDATES = 24;
    private static final int MAX_REQS_PER_SEARCH = 3;
    private static final int MAX_CONCURRENT_PATHS = 4;
    private static final int PROBE_BUDGET_PER_TICK = 64;
    private static final int GRID_STEP = 5;
    private static final int MAX_LAST_DRANK_DIST = 512;
    private boolean requiresShore = false;
    private int range = 64;

    public JSFindWaterTask(JSAnimalBase animal) {
        super(animal);
        this.getGoals().add(TaskGoal.METABOLISM);
        this.getGoals().add(TaskGoal.MOVEMENT);
    }

    public JSFindWaterTask noShore() {
        this.requiresShore = false;
        return this;
    }

    public JSFindWaterTask setRange(int r) {
        this.range = r;
        return this;
    }

    public TaskPriority getPriority() {
        if (this.animal.isDead()) {
            return TaskPriority.NONE;
        }
        double t = this.animal.getModules().getMetabolismModule().thirstPercentage();
        if (t > 0.8) {
            return TaskPriority.LOW;
        }
        if (t > 0.6) {
            return TaskPriority.MEDIUM;
        }
        if (t > 0.4) {
            return TaskPriority.HIGH;
        }
        if (t > 0.2) {
            return TaskPriority.VERY_HIGH;
        }
        return TaskPriority.DIRECT;
    }

    public boolean shouldRun() {
        if (this.checkCooldown < 0) {
            this.checkCooldown = 0;
        }
        if (this.checkCooldown-- != 0 || this.animal.isDead()) {
            return false;
        }
        if (!this.animal.getModules().getMetabolismModule().isThirsty()) {
            return false;
        }
        if (!this.animal.getAnimal().getAnimalAttributes().getMetabolismProperties().isThirstEnabled()) {
            return false;
        }
        if (this.animal.lastDrankAtPos != null && this.animal.lastDrankAtPos.distSqr((Vec3i)this.animal.blockPosition()) > 262144.0) {
            this.animal.lastDrankAtPos = null;
        }
        if (this.ticks - this.lastSearchTick >= 20 && !this.scanning && this.candidates.isEmpty() && this.pendingProbes.isEmpty()) {
            this.lastSearchTick = this.ticks;
            this.scanning = true;
            BlockPos center = this.animal.blockPosition();
            int half = Math.max(2, Math.min(this.range, 96));
            CompletableFuture.runAsync(() -> {
                ArrayDeque<BlockPos> toProbe = new ArrayDeque<BlockPos>();
                for (int x = center.getX() - half; x <= center.getX() + half; x += 5) {
                    for (int z = center.getZ() - half; z <= center.getZ() + half; z += 5) {
                        toProbe.add(new BlockPos(x, 0, z));
                    }
                }
                JSFindWaterTask.runOnMainThread(this.animal.level(), () -> {
                    this.pendingProbes.addAll(toProbe);
                    this.scanning = false;
                });
            });
        }
        if (!this.pendingProbes.isEmpty()) {
            this.consumeProbeBudget();
        }
        if (this.targetPos != null && this.targetWater != null) {
            return true;
        }
        if (!this.candidates.isEmpty()) {
            this.requestPaths();
        }
        ++this.ticks;
        return this.scanning || !this.pendingProbes.isEmpty() || this.targetPos != null && this.targetWater != null;
    }

    public boolean canContinueRunning() {
        if (this.animal.isDead()) {
            return false;
        }
        if (!this.animal.getModules().getMetabolismModule().isThirstEnabled()) {
            return false;
        }
        return this.scanning || !this.pendingProbes.isEmpty() || this.pendingPaths.get() > 0 || !this.candidates.isEmpty() || this.targetPos != null && this.targetWater != null;
    }

    public boolean canInterrupt() {
        return this.targetPos == null;
    }

    public void onStart() {
        this.animal.getNavigationController().stop();
        this.animal.setAggressive(true);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.scanning) {
            return;
        }
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
        }
        ++this.drinkingTicks;
        if (this.drinkingTicks > 200 && this.animal.getNavigationController().isDone() && this.animal.getNavigationController().isStuck()) {
            this.stop();
            this.checkCooldown = 5;
            return;
        }
        if (this.reachedWater()) {
            this.drink();
            return;
        }
        if (this.targetPos == null && !this.candidates.isEmpty()) {
            Candidate next = this.candidates.remove(0);
            this.targetPos = Vec3.atCenterOf((Vec3i)next.land);
            this.targetWater = Vec3.atCenterOf((Vec3i)next.water);
            this.pathStarted = false;
        }
        if (this.targetPos != null && (!this.pathStarted || this.animal.getNavigationController().isDone()) && this.pendingPaths.get() < 4) {
            CompletableFuture future = this.animal.getNavigationController().createPath(this.targetPos.x, this.targetPos.y, this.targetPos.z, 1);
            if (future != null) {
                this.pendingPaths.incrementAndGet();
                future.thenAccept(path -> JSFindWaterTask.runOnMainThread(this.animal.level(), () -> {
                    try {
                        if (path != null) {
                            this.animal.getNavigationController().moveTo(path);
                            this.pathStarted = true;
                        } else {
                            this.clearTarget();
                        }
                    }
                    finally {
                        this.pendingPaths.decrementAndGet();
                    }
                }));
            } else {
                this.clearTarget();
            }
        }
        ++this.ticks;
    }

    public void onStop() {
        this.animal.setAggressive(false);
    }

    public void cleanUp() {
        this.clearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeProbeBudget() {
        BlockPos base;
        Level lvl = this.animal.level();
        Vec3 origin = this.animal.position();
        int budget = 64;
        ArrayList<Candidate> batch = new ArrayList<Candidate>(budget);
        while (budget-- > 0 && !this.pendingProbes.isEmpty() && (base = this.pendingProbes.pollFirst()) != null) {
            int surfaceY = lvl.getHeight(Heightmap.Types.WORLD_SURFACE, base.getX(), base.getZ());
            BlockPos waterPos = new BlockPos(base.getX(), surfaceY - 1, base.getZ());
            if (!lvl.getFluidState(waterPos).is(FluidTags.WATER) || !lvl.getBlockState(waterPos.above()).isAir()) continue;
            if (this.requiresShore) {
                boolean added = false;
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    BlockPos land = waterPos.relative(dir);
                    if (!lvl.getBlockState(land).isAir() || !lvl.getBlockState(land.above()).isAir() || !lvl.getBlockState(land.below()).isSolidRender((BlockGetter)lvl, land.below())) continue;
                    batch.add(new Candidate(land.immutable(), waterPos.immutable(), origin.distanceToSqr(Vec3.atCenterOf((Vec3i)land))));
                    added = true;
                    break;
                }
                if (added) continue;
                continue;
            }
            batch.add(new Candidate(waterPos.immutable(), waterPos.immutable(), origin.distanceToSqr(Vec3.atCenterOf((Vec3i)waterPos))));
        }
        if (!batch.isEmpty()) {
            batch.sort(Comparator.comparingDouble(a -> a.dist * (1.0 + ThreadLocalRandom.current().nextDouble() * 0.25)));
            List<Candidate> list = this.candidates;
            synchronized (list) {
                this.candidates.removeIf(this::isInvalid);
                this.candidates.addAll(batch);
                if (this.candidates.size() > 24) {
                    this.candidates.sort((a, b) -> Double.compare(a.dist, b.dist));
                    this.candidates.subList(24, this.candidates.size()).clear();
                }
            }
        }
    }

    private void requestPaths() {
        int reqs = 0;
        for (Candidate c : new ArrayList<Candidate>(this.candidates)) {
            if (reqs >= 3 || this.pendingPaths.get() >= 4 || this.targetPos != null) break;
            CompletableFuture future = this.animal.getNavigationController().createPath(c.land, 0.0);
            if (future == null) continue;
            this.targetPos = Vec3.atCenterOf((Vec3i)c.land);
            this.targetWater = Vec3.atCenterOf((Vec3i)c.water);
            this.pathStarted = false;
            this.pendingPaths.incrementAndGet();
            ++reqs;
            future.thenAccept(path -> JSFindWaterTask.runOnMainThread(this.animal.level(), () -> {
                try {
                    if (path != null) {
                        this.animal.getNavigationController().moveTo(path);
                        this.pathStarted = true;
                    } else {
                        this.clearTarget();
                    }
                }
                finally {
                    this.pendingPaths.decrementAndGet();
                }
            }));
        }
    }

    private boolean isInvalid(Candidate c) {
        Level lvl = this.animal.level();
        if (!lvl.getFluidState(c.water).is(FluidTags.WATER)) {
            return true;
        }
        if (!lvl.getBlockState(c.water.above()).isAir()) {
            return true;
        }
        if (this.requiresShore) {
            if (!lvl.getBlockState(c.land).isAir()) {
                return true;
            }
            if (!lvl.getBlockState(c.land.above()).isAir()) {
                return true;
            }
            return !lvl.getBlockState(c.land.below()).isSolidRender((BlockGetter)lvl, c.land.below());
        }
        return false;
    }

    private void drink() {
        this.animal.getNavigationController().stop();
        if (this.targetWater != null) {
            this.animal.lookAt(EntityAnchorArgument.Anchor.FEET, this.targetWater);
        }
        this.animal.getModules().getMetabolismModule().setThirst(this.animal.getModules().getMetabolismModule().getMaxThirst());
        this.animal.curDrinkTicks = 5;
        if (this.targetWater != null) {
            this.animal.lastDrankAtPos = BlockPos.containing((Position)this.targetWater);
        }
        this.clearTarget();
        this.drinkingTicks = 0;
        this.checkCooldown = 10;
    }

    private boolean reachedWater() {
        return this.targetPos != null && JSTaskUtils.isCloseEnough(this.animal, this.targetPos, 3.0f) || this.animal.isInWater();
    }

    private void clearTarget() {
        this.targetWater = null;
        this.targetPos = null;
        this.pathStarted = false;
    }

    private void clearAll() {
        this.clearTarget();
        this.checkCooldown = 0;
        this.ticks = 0;
        this.drinkingTicks = 0;
        this.pendingPaths.set(0);
        this.scanning = false;
        this.pendingProbes.clear();
        this.candidates.clear();
    }

    private static void runOnMainThread(Level level, Runnable r) {
        MinecraftServer srv = level.getServer();
        if (srv != null) {
            srv.execute(r);
        } else {
            Minecraft.getInstance().execute(r);
        }
    }

    private record Candidate(BlockPos land, BlockPos water, double dist) {
    }
}

