/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSGrazeTask
extends JSTaskBase {
    private Vec3 targetPos;
    private int grazeTicks = 0;

    public JSGrazeTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.METABOLISM);
        this.getGoals().add(TaskGoal.MOVEMENT);
    }

    public TaskPriority getPriority() {
        if (this.animal.isDead()) {
            return TaskPriority.NONE;
        }
        if (!this.animal.getModules().getMetabolismModule().isHungry()) {
            return TaskPriority.NONE;
        }
        return TaskPriority.MEDIUM;
    }

    public boolean shouldRun() {
        if (!this.animal.getModules().getMetabolismModule().isHungry()) {
            return false;
        }
        BlockPos base = this.animal.blockPosition();
        int range = 8;
        for (int dx = -range; dx <= range; ++dx) {
            for (int dz = -range; dz <= range; ++dz) {
                BlockPos pos = base.offset(dx, 0, dz);
                if (!this.animal.level().getBlockState(pos).is(Blocks.GRASS_BLOCK) || !this.animal.level().isEmptyBlock(pos.above())) continue;
                this.targetPos = Vec3.atCenterOf((Vec3i)pos.above());
                return true;
            }
        }
        return false;
    }

    public boolean canContinueRunning() {
        return this.targetPos != null && this.animal.getModules().getMetabolismModule().isHungry();
    }

    public void onStart() {
        if (this.targetPos != null) {
            this.animal.getNavigationController().moveTo(this.targetPos.x, this.targetPos.y, this.targetPos.z);
        }
    }

    public void tick() {
        if (this.targetPos != null && JSTaskUtils.isCloseEnough(this.animal, this.targetPos, 2.0f)) {
            ++this.grazeTicks;
            if (this.grazeTicks > 40) {
                BlockPos grassPos = BlockPos.containing((Position)this.targetPos).below();
                if (this.animal.level().getBlockState(grassPos).is(Blocks.GRASS_BLOCK)) {
                    this.animal.level().setBlock(grassPos, Blocks.DIRT.defaultBlockState(), 3);
                }
                this.animal.getModules().getMetabolismModule().addFood((int)JSUtils.toTickMinutes(20.0f));
                this.targetPos = null;
                this.grazeTicks = 0;
            }
        }
    }

    public void onStop() {
        this.targetPos = null;
        this.grazeTicks = 0;
    }

    public void cleanUp() {
        this.targetPos = null;
        this.grazeTicks = 0;
    }
}

