/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;

public class JSRestTask
extends JSTaskBase {
    private int restTime = 0;

    public JSRestTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    public boolean shouldRun() {
        if (this.animal.isDead()) {
            return false;
        }
        if (this.animal.isSleeping()) {
            return false;
        }
        if (this.animal.getModules().getMetabolismModule().isHungry() || this.animal.isInWaterOrBubble() || this.animal.getModules().getMetabolismModule().isInterrupted() || this.animal.getModules().getMetabolismModule().isThirsty() || this.animal.isDead() || this.animal.isDead() || this.animal.getTarget() != null || this.animal.shouldSleep() || this.animal.isSleeping() || !this.animal.onGround()) {
            return false;
        }
        if (this.random.nextDouble() > 0.975 || this.animal.isResting()) {
            return this.animal.getNavigationController().isDone();
        }
        return false;
    }

    public boolean canContinueRunning() {
        if (this.animal.isSleeping()) {
            return false;
        }
        if (this.animal.getModules().getMetabolismModule().isHungry() || this.animal.isInWaterOrBubble() || this.animal.getModules().getMetabolismModule().isInterrupted() || this.animal.getModules().getMetabolismModule().isThirsty() || this.animal.isDead() || this.animal.isDead() || this.animal.getTarget() != null || this.animal.shouldSleep() || this.animal.isSleeping() || !this.animal.onGround()) {
            return false;
        }
        return this.restTime > 0;
    }

    public boolean canInterrupt() {
        return this.restTime == 0;
    }

    public void onStart() {
        this.restTime = 200 + this.random.nextInt(600);
        this.animal.setResting(true);
        this.animal.getNavigationController().stop();
        this.animal.getNavigationController().setLookingForPath(true);
    }

    public boolean requiresUpdateEveryTick() {
        return this.restTime > 0;
    }

    public void tick() {
        --this.restTime;
        if (this.restTime <= 0) {
            this.stop();
        }
        if (this.animal.isMoving()) {
            this.animal.getModules().getMetabolismModule().interrupt(20);
        }
    }

    public void onStop() {
        this.restTime = 0;
        this.animal.getModules().getMetabolismModule().interrupt(20);
        this.animal.setResting(false);
        this.animal.getNavigationController().setLookingForPath(false);
    }
}

