/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation;

import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskPriority;

public class JSRandomStrollTask
extends JSTaskBase {
    private Vec3 foundTargetPos;
    private int xRange = 8;
    private int yRange = 4;
    private int yVariation = 4;

    public JSRandomStrollTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    public TaskPriority getPriority() {
        return TaskPriority.LOW;
    }

    public JSRandomStrollTask setYVariation(int yVariation) {
        this.yVariation = yVariation;
        return this;
    }

    public JSRandomStrollTask setRange(int xRange, int yRange) {
        this.xRange = xRange;
        this.yRange = yRange;
        return this;
    }

    public boolean canInterrupt() {
        return this.animal.shouldSleep() || this.animal.getFleeTarget() != null;
    }

    public boolean shouldRun() {
        JSAvianBase base;
        if (this.animal.isSleeping() || this.animal.isResting()) {
            return false;
        }
        if (this.animal.isDead() || this.animal.isStaticCreature() || this.animal.isFrozenInPlace()) {
            return false;
        }
        JSAnimalBase jSAnimalBase = this.animal;
        if (jSAnimalBase instanceof JSAvianBase && ((base = (JSAvianBase)jSAnimalBase).isDiving() || base.getTarget() != null)) {
            return false;
        }
        return this.animal.getNavigationController().isDone();
    }

    public boolean canContinueRunning() {
        JSAvianBase base;
        if (this.animal.isSleeping() || this.animal.isResting()) {
            return false;
        }
        if (this.animal.isDead() || this.animal.getTarget() != null || this.animal.getFleeTarget() != null) {
            return false;
        }
        JSAnimalBase jSAnimalBase = this.animal;
        if (jSAnimalBase instanceof JSAvianBase && ((base = (JSAvianBase)jSAnimalBase).isDiving() || base.getTarget() != null)) {
            return false;
        }
        return this.animal.getNavigationController().isInProgress();
    }

    public void onStart() {
        for (int i = 0; i < 5; ++i) {
            this.foundTargetPos = JSTaskUtils.findTargetPos(this.animal, this.xRange, this.yRange, this.yVariation);
            if (this.foundTargetPos != null) break;
        }
        if (this.foundTargetPos == null) {
            this.stop();
            return;
        }
        CompletableFuture pathFuture = this.animal.getNavigationController().createPath(this.foundTargetPos.x, this.foundTargetPos.y, this.foundTargetPos.z, 1);
        if (pathFuture == null) {
            this.stop();
            return;
        }
        pathFuture.thenAccept(path -> {
            if (path != null) {
                this.animal.getNavigationController().moveTo(path);
            } else {
                this.stop();
            }
        });
    }

    public void tick() {
    }

    public void onStop() {
        this.animal.getNavigationController().stop();
        this.foundTargetPos = null;
    }
}

