/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.util;

import jp.jurassicsaga.server.base.animal.entity.util.JSGoalUtils;
import jp.jurassicsaga.server.base.animal.entity.util.JSRandomPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;

public class JSAirAndWaterRandomPos {
    @Nullable
    public static Vec3 getPos(SmartAnimalBase mob, int maxDistance, int yRange, int maxDistanceOfGround) {
        boolean restricted = JSGoalUtils.mobRestricted(mob, maxDistance);
        return JSRandomPos.generateBestRandomPos(() -> JSAirAndWaterRandomPos.generateRandomPos(mob, maxDistance, yRange, maxDistanceOfGround, restricted), arg_0 -> ((SmartAnimalBase)mob).getWalkTargetValue(arg_0));
    }

    @Nullable
    private static BlockPos generateRandomPos(SmartAnimalBase mob, int maxDistance, int yRange, int maxDistanceOfGround, boolean restricted) {
        RandomSource rng = mob.getRandom();
        BlockPos base = mob.blockPosition();
        int dx = rng.nextInt(maxDistance * 2 + 1) - maxDistance;
        int dy = rng.nextInt(yRange * 2 + 1) - yRange;
        int dz = rng.nextInt(maxDistance * 2 + 1) - maxDistance;
        int x = base.getX() + dx;
        int y = base.getY() + dy;
        int z = base.getZ() + dz;
        if (maxDistanceOfGround != -1) {
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos(x, base.getY(), z);
            while (cursor.getY() > mob.level().getMinBuildHeight() && mob.level().isEmptyBlock((BlockPos)cursor)) {
                cursor.move(Direction.DOWN);
            }
            int groundY = cursor.getY();
            int minY = groundY + 1;
            int maxY = groundY + maxDistanceOfGround;
            y = Mth.clamp((int)y, (int)minY, (int)maxY);
        } else {
            y = Mth.clamp((int)y, (int)(mob.level().getMinBuildHeight() + 1), (int)(mob.level().getMaxBuildHeight() - 1));
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (JSGoalUtils.isOutsideLimits(pos, mob)) {
            return null;
        }
        if (JSGoalUtils.isRestricted(restricted, mob, pos)) {
            return null;
        }
        if (JSGoalUtils.hasMalus(mob, pos)) {
            return null;
        }
        return pos;
    }
}

