/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.FluidTags;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersGroundNavigation;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;

public class JSGoalUtils {
    public static boolean hasGroundPathNavigation(SmartAnimalBase mob) {
        return mob.getNavigationController() instanceof TravelersGroundNavigation;
    }

    public static boolean mobRestricted(SmartAnimalBase mob, int radius) {
        return mob.hasRestriction() && mob.getRestrictCenter().closerToCenterThan((Position)mob.position(), (double)(mob.getRestrictRadius() + (float)radius) + 1.0);
    }

    public static boolean isOutsideLimits(BlockPos pos, SmartAnimalBase mob) {
        return pos.getY() < mob.level().getMinBuildHeight() || pos.getY() > mob.level().getMaxBuildHeight();
    }

    public static boolean isRestricted(boolean shortCircuit, SmartAnimalBase mob, BlockPos pos) {
        return shortCircuit && !mob.isWithinRestriction(pos);
    }

    public static boolean isNotStable(TravelersPathNavigation navigation, BlockPos pos) {
        boolean isStable = !navigation.isStableDestination(pos);
        return isStable;
    }

    public static boolean isWater(SmartAnimalBase mob, BlockPos pos) {
        return mob.level().getFluidState(pos).is(FluidTags.WATER);
    }

    public static boolean hasMalus(SmartAnimalBase mob, BlockPos pos) {
        return mob.getPathfindingMalus(TravelersWalkNodeEvaluator.getPathTypeStatic((SmartAnimalBase)mob, (BlockPos)pos)) != 0.0f;
    }

    public static boolean isSolid(SmartAnimalBase mob, BlockPos pos) {
        return mob.level().getBlockState(pos).isSolid();
    }
}

