/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.util;

import java.util.Random;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSAmphibiousNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSAquaticNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSFlyingNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGroundNavigation;
import jp.jurassicsaga.server.base.animal.entity.util.JSAirAndWaterRandomPos;
import jp.jurassicsaga.server.base.animal.entity.util.JSDefaultRandomPos;
import jp.jurassicsaga.server.base.animal.entity.util.JSLandRandomPos;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.SmartAnimalBase;

public class JSTaskUtils {
    private static final Random rng = new Random();

    public static Vec3 findTargetPos(JSAnimalBase animal, int xRange, int yRange, int heightVariation) {
        boolean isFlyingAnimal = animal.getNavigationController() instanceof JSFlyingNavigation;
        boolean isAquaticAnimal = animal.getNavigationController() instanceof JSAquaticNavigation;
        boolean isAmphibious = animal.getNavigationController() instanceof JSAmphibiousNavigation;
        if (isAmphibious) {
            isAquaticAnimal = rng.nextBoolean();
        }
        if (isFlyingAnimal && animal instanceof JSAvianBase) {
            JSAvianBase flying = (JSAvianBase)animal;
            boolean bl = isFlyingAnimal = flying.isFlying() && !flying.wantsToLand();
        }
        if (!isFlyingAnimal && !isAquaticAnimal) {
            if (animal.isInWaterOrBubble()) {
                Vec3 vec3 = JSLandRandomPos.getPos(animal, xRange, yRange);
                return vec3 == null ? JSDefaultRandomPos.getPos(animal, xRange, yRange) : vec3;
            }
            if (animal.avoidsLight()) {
                int attempts = 10;
                while (attempts != 0) {
                    Vec3 pos;
                    Vec3 vec3 = pos = (double)rng.nextFloat() >= 0.6 ? JSLandRandomPos.getPos(animal, xRange * 2, yRange) : JSDefaultRandomPos.getPos(animal, xRange, yRange);
                    if (pos != null) {
                        int blockLight;
                        Level level = animal.level();
                        boolean isDay = level.getDayTime() % 24000L < 12000L;
                        BlockPos blockPos = new BlockPos((int)pos.x, (int)pos.y, (int)pos.z);
                        if (!level.getBlockState(blockPos).isAir() && !level.getBlockState(blockPos = blockPos.above()).isAir()) continue;
                        int skyLight = isDay ? level.getBrightness(LightLayer.SKY, blockPos) : 0;
                        int totalLight = Math.min(15, skyLight + (blockLight = level.getBrightness(LightLayer.BLOCK, blockPos)));
                        if (totalLight < 14) {
                            return pos;
                        }
                    }
                    --attempts;
                }
            }
            return (double)rng.nextFloat() >= 0.5 ? JSLandRandomPos.getPos(animal, xRange * 2, yRange) : JSDefaultRandomPos.getPos(animal, xRange, yRange);
        }
        if (isFlyingAnimal) {
            int maxDistance = -1;
            if (animal instanceof JSAvianBase) {
                JSAvianBase avianBase = (JSAvianBase)animal;
                maxDistance = avianBase.getDistanceOfGround();
            }
            return JSAirAndWaterRandomPos.getPos(animal, xRange, yRange, maxDistance);
        }
        Vec3 target = null;
        Vec3 baseTarget = JSTaskUtils.getRandomSwimmablePos(animal, xRange, yRange);
        if (baseTarget != null) {
            double baseY = baseTarget.y - 1.0 - (double)rng.nextInt(heightVariation);
            double newY = Math.max((double)animal.level().getMinBuildHeight(), baseY);
            BlockPos checkPos = new BlockPos((int)baseTarget.x, (int)newY, (int)baseTarget.z);
            if (animal.level().getFluidState(checkPos).is(FluidTags.WATER)) {
                target = new Vec3(baseTarget.x, newY, baseTarget.z);
            }
        }
        return target;
    }

    private static Vec3 getRandomSwimmablePos(SmartAnimalBase pathfinder, int radius, int verticalDistance) {
        Vec3 vec3 = JSDefaultRandomPos.getPos(pathfinder, radius, verticalDistance);
        int i = 0;
        while (vec3 != null && !pathfinder.level().getFluidState(new BlockPos((int)vec3.x, (int)vec3.y, (int)vec3.z)).is(FluidTags.WATER) && i++ < 10) {
            vec3 = JSDefaultRandomPos.getPos(pathfinder, radius, verticalDistance);
        }
        return vec3;
    }

    public static boolean hasGroundPathNavigation(SmartAnimalBase mob) {
        return mob.getNavigationController() instanceof JSGroundNavigation;
    }

    public static boolean isCloseEnough(JSAnimalBase animal, Vec3 target, float mul) {
        return JSUtils.isWithinDistanceSqr(target, animal.position(), (double)(Math.max(0.5f, animal.getBbWidth()) * mul));
    }
}

