/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj;

import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Set;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.obj.DroppableItem;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.animal.obj.JSTravelersAttributes;
import jp.jurassicsaga.server.base.generic.obj.PossibleResult;
import jp.jurassicsaga.server.base.item.JSItems;
import jp.jurassicsaga.server.base.item.obj.animal.AnimalItem;
import jp.jurassicsaga.server.base.item.obj.animal.AnimalRemains;
import jp.jurassicsaga.server.base.item.obj.egg.BasicSpawnEgg;
import jp.jurassicsaga.server.base.item.obj.egg.GenderSpawnEgg;
import jp.jurassicsaga.server.base.item.obj.egg.HatchedEgg;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.TravelersAnimalAttributes;
import travelers.server.animal.obj.TravelersItemInterface;
import travelers.server.animal.obj.misc.DropObject;

public class JSTravelersItems<T extends JSAnimalBase>
implements TravelersItemInterface<T> {
    private final HashMap<DroppableItem, Supplier<Item>> custom_items = new HashMap();
    private Supplier<Item> spawnEgg;
    private JSTravelersAttributes<T> attributes;
    private HashMap<ItemLike, DropObject> drops = new HashMap();
    private Supplier<Item> rawMeat;
    private Supplier<Item> cookedMeat;
    private Supplier<Item> coin;
    private Supplier<Item> fossil_remains;
    private Supplier<Item> hatched_egg;
    private Supplier<Item> bucket;

    public void init(TravelersAnimalAttributes<T> attribz, TravelersAnimal<T> travelersAnimal) {
        this.attributes = (JSTravelersAttributes)attribz;
        JSAnimal animal = (JSAnimal)travelersAnimal;
        String name = this.attributes.getAnimalName().toLowerCase();
        if (animal.getAnimalAttributes().getItemProperties().isHasMeat()) {
            this.rawMeat = JSItems.ITEMS.register(name + "_raw", () -> new AnimalItem(animal, true, new Item.Properties().food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.3f).effect(new MobEffectInstance(MobEffects.HUNGER, 600, 0), 0.3f).build())));
            this.cookedMeat = JSItems.ITEMS.register(name + "_cooked", () -> new AnimalItem(animal, false, new Item.Properties().food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.3f).build())));
        }
        if (animal.getAnimalAttributes().getMiscProperties().isExtinct() || animal.getAnimalAttributes().getItemProperties().isHasCoin()) {
            this.coin = JSItems.ITEMS.register(name + "_coin", () -> new DnaItem(animal, new Item.Properties()));
        }
        if (animal.getAnimalAttributes().getMiscProperties().isExtinct() && animal.getAnimalAttributes().getItemProperties().isHasFossil()) {
            this.fossil_remains = JSItems.ITEMS.register(name + "_fossil_remains", () -> new AnimalRemains(animal, new Item.Properties(), animal.getAnimalAttributes().getMiscProperties().getEra(), PossibleResult.REMAINS));
        }
        for (DroppableItem additionalItem : this.attributes.getItemProperties().getAdditionalItems()) {
            this.custom_items.put(additionalItem, JSItems.registerItem(name + "_" + additionalItem.name(), (Supplier<Item>)((Supplier)() -> new Item(new Item.Properties()))));
        }
        this.drops = animal.getItems().initDrops(this, this.drops);
    }

    public void initSpawnEgg(TravelersAnimalAttributes<?> attribz, TravelersAnimal<?> travelersAnimal) {
        this.attributes = (JSTravelersAttributes)attribz;
        JSAnimal animal = (JSAnimal)travelersAnimal;
        if (this.attributes.getItemProperties().isHasDrops()) {
            if (this.attributes.getItemProperties().isBucketable()) {
                this.bucket = JSItems.ITEMS.register(this.attributes.getAnimalName().toLowerCase() + "_bucket", () -> new MobBucketItem((EntityType)animal.getEntityType().get(), (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_FISH, new Item.Properties().stacksTo(1)));
            }
            this.spawnEgg = this.attributes.getItemProperties().getSpawnEggColoursMale() != null ? JSItems.registerItem(this.attributes.getAnimalName().toLowerCase() + "_spawn_egg", (Supplier<Item>)((Supplier)() -> new GenderSpawnEgg(animal, () -> (EntityType)animal.getEntityType().get(), this.attributes.getItemProperties().getSpawnEggColours()[0], this.attributes.getItemProperties().getSpawnEggColours()[1], this.attributes.getItemProperties().getSpawnEggColoursMale()[0], this.attributes.getItemProperties().getSpawnEggColoursMale()[1], new Item.Properties()))) : JSItems.registerItem(this.attributes.getAnimalName().toLowerCase() + "_spawn_egg", (Supplier<Item>)((Supplier)() -> new BasicSpawnEgg(animal, () -> (EntityType)animal.getEntityType().get(), this.attributes.getItemProperties().getSpawnEggColours()[0], this.attributes.getItemProperties().getSpawnEggColours()[1], new Item.Properties())));
            if (this.attributes.getItemProperties().isHasEgg()) {
                this.hatched_egg = JSItems.registerItem(this.attributes.getAnimalName().toLowerCase() + "_hatch_egg", (Supplier<Item>)((Supplier)() -> new HatchedEgg(this.attributes.getGeneticProperties().getDefaultGenetics())));
            }
        }
    }

    public HashMap<ItemLike, DropObject> initDrops(TravelersItemInterface<T> travelersItemInterface, HashMap<ItemLike, DropObject> hashMap) {
        return new HashMap<ItemLike, DropObject>();
    }

    @Nullable
    public ItemStack getPickItem(SmartAnimalBase smartAnimalBase) {
        return ((Item)this.spawnEgg.get()).getDefaultInstance();
    }

    public ItemStack getBucketItem() {
        return this.bucket != null ? ((Item)this.bucket.get()).getDefaultInstance() : ItemStack.EMPTY;
    }

    public Set<java.util.function.Supplier<Item>> spawnEggs() {
        return super.spawnEggs();
    }

    public HashMap<DroppableItem, Supplier<Item>> getCustom_items() {
        return this.custom_items;
    }

    public Supplier<Item> getSpawnEgg() {
        return this.spawnEgg;
    }

    public JSTravelersAttributes<T> getAttributes() {
        return this.attributes;
    }

    public HashMap<ItemLike, DropObject> getDrops() {
        return this.drops;
    }

    public Supplier<Item> getRawMeat() {
        return this.rawMeat;
    }

    public Supplier<Item> getCookedMeat() {
        return this.cookedMeat;
    }

    public Supplier<Item> getCoin() {
        return this.coin;
    }

    public Supplier<Item> getFossil_remains() {
        return this.fossil_remains;
    }

    public Supplier<Item> getHatched_egg() {
        return this.hatched_egg;
    }

    public Supplier<Item> getBucket() {
        return this.bucket;
    }
}

