/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj.attributes;

import java.util.ArrayList;
import java.util.Arrays;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.obj.DroppableItem;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.SampleColour;

public class JSItemProperties<T extends JSAnimalBase> {
    private final ArrayList<DroppableItem> additionalItems = new ArrayList();
    private final int[] spawnEggColours = new int[2];
    private int[] spawnEggColoursMale = null;
    private EggType eggtype = EggType.CHICKEN;
    private SampleColour sampleColour = SampleColour.RED;
    private boolean hasCoin = false;
    private boolean hasMeat = true;
    private boolean hasDrops = true;
    private boolean hasFossil = true;
    private boolean hasEgg = true;
    private boolean bucketable = false;

    public JSItemProperties<T> setSpawnEggColors(int color1, int color2) {
        this.spawnEggColours[0] = color1;
        this.spawnEggColours[1] = color2;
        return this;
    }

    public JSItemProperties<T> setSpawnEggColorsMale(int color1, int color2) {
        this.spawnEggColoursMale = new int[2];
        this.spawnEggColoursMale[0] = color1;
        this.spawnEggColoursMale[1] = color2;
        return this;
    }

    public JSItemProperties<T> enableCoin() {
        this.hasCoin = true;
        return this;
    }

    public JSItemProperties<T> disableMeat() {
        this.hasMeat = false;
        return this;
    }

    public JSItemProperties<T> disableDrops() {
        this.hasDrops = false;
        return this;
    }

    public JSItemProperties<T> disableEgg() {
        this.hasEgg = false;
        return this;
    }

    public JSItemProperties<T> setBucketable() {
        this.bucketable = true;
        return this;
    }

    public JSItemProperties<T> addAdditionalItems(DroppableItem ... items) {
        this.additionalItems.addAll(Arrays.asList(items));
        return this;
    }

    public ArrayList<DroppableItem> getAdditionalItems() {
        return this.additionalItems;
    }

    public int[] getSpawnEggColours() {
        return this.spawnEggColours;
    }

    public int[] getSpawnEggColoursMale() {
        return this.spawnEggColoursMale;
    }

    public EggType getEggtype() {
        return this.eggtype;
    }

    public SampleColour getSampleColour() {
        return this.sampleColour;
    }

    public boolean isHasCoin() {
        return this.hasCoin;
    }

    public boolean isHasMeat() {
        return this.hasMeat;
    }

    public boolean isHasDrops() {
        return this.hasDrops;
    }

    public boolean isHasFossil() {
        return this.hasFossil;
    }

    public boolean isHasEgg() {
        return this.hasEgg;
    }

    public boolean isBucketable() {
        return this.bucketable;
    }

    public JSItemProperties<T> setSpawnEggColoursMale(int[] spawnEggColoursMale) {
        this.spawnEggColoursMale = spawnEggColoursMale;
        return this;
    }

    public JSItemProperties<T> setEggtype(EggType eggtype) {
        this.eggtype = eggtype;
        return this;
    }

    public JSItemProperties<T> setSampleColour(SampleColour sampleColour) {
        this.sampleColour = sampleColour;
        return this;
    }

    public JSItemProperties<T> setHasCoin(boolean hasCoin) {
        this.hasCoin = hasCoin;
        return this;
    }

    public JSItemProperties<T> setHasMeat(boolean hasMeat) {
        this.hasMeat = hasMeat;
        return this;
    }

    public JSItemProperties<T> setHasDrops(boolean hasDrops) {
        this.hasDrops = hasDrops;
        return this;
    }

    public JSItemProperties<T> setHasFossil(boolean hasFossil) {
        this.hasFossil = hasFossil;
        return this;
    }

    public JSItemProperties<T> setHasEgg(boolean hasEgg) {
        this.hasEgg = hasEgg;
        return this;
    }

    public JSItemProperties<T> setBucketable(boolean bucketable) {
        this.bucketable = bucketable;
        return this;
    }
}

