/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj.locator;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import net.minecraft.resources.ResourceLocation;
import travelers.server.animal.obj.locator.ResourceLocator;

public class JSAnimalBaseLocator<T extends JSAnimalBase>
extends ResourceLocator<T> {
    private final boolean hasGenders;
    private boolean adultOnly;
    protected final Map<String, ResourceLocation> cache = Collections.synchronizedMap(new WeakHashMap());

    public JSAnimalBaseLocator() {
        this(true);
    }

    public JSAnimalBaseLocator(boolean gendered) {
        this.hasGenders = gendered;
    }

    public JSAnimalBaseLocator<T> setAdultOnly() {
        this.adultOnly = true;
        return this;
    }

    public ResourceLocation getTextureLocation(T entity) {
        Object key = this.makeCacheKey(entity, "texture");
        if (entity.hasCustomName()) {
            key = (String)key + "|name=" + entity.getCustomName().getString().toLowerCase(Locale.ROOT);
        }
        return this.cache.computeIfAbsent((String)key, k -> this.buildTextureLocation(entity));
    }

    public ResourceLocation getLuxLocation(T entity) {
        String key = this.makeCacheKey(entity, "lux");
        return this.cache.computeIfAbsent(key, k -> {
            String name = this.getEntityName(entity);
            String growthStage = this.getGrowthStage(entity);
            String version = this.getVersion(entity);
            return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + "_lux.png");
        });
    }

    public ResourceLocation getModelLocation(T entity) {
        String key = this.makeCacheKey(entity, "model");
        return this.cache.computeIfAbsent(key, k -> {
            String name = this.getEntityName(entity);
            String growthStage = this.getGrowthStage(entity);
            String version = this.getVersion(entity);
            return JSCommon.createId("geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + ".geo.json");
        });
    }

    public ResourceLocation getDefaultModelLocation(T entity) {
        String key = this.makeCacheKey(entity, "default_model");
        return this.cache.computeIfAbsent(key, k -> {
            String name = this.getEntityName(entity);
            String version = this.getVersion(entity);
            return JSCommon.createId("geo/animal/" + version + "/" + name + "/" + name + "_adult.geo.json");
        });
    }

    public ResourceLocation getAnimationLocation(T entity) {
        String key = this.makeCacheKey(entity, "anim");
        return this.cache.computeIfAbsent(key, k -> {
            String name = this.getEntityName(entity);
            String version = this.getVersion(entity);
            boolean baby = !this.adultOnly && entity.getAnimal().getAnimalAttributes().getMiscProperties().isBabyAnimations() && entity.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.BABY;
            return JSCommon.createId("animations/animal/" + version + "/" + name + "/" + name + (baby ? "_baby.animation.json" : ".animation.json"));
        });
    }

    protected ResourceLocation buildTextureLocation(T entity) {
        String name = this.getEntityName(entity);
        String growthStage = this.getGrowthStage(entity);
        String version = this.getVersion(entity);
        if (((JSAnimalBase)((Object)entity)).getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT) {
            return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + ".png");
        }
        JSVariants.JSVariant variant = JSVariants.fromLocation((String)entity.getEntityData().get(JSEntityDataHolder.textureVariant));
        boolean extinct = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().isExtinct();
        if (variant == JSVariants.NONE || !extinct) {
            if (!this.hasGenders) {
                return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + ".png");
            }
            String suffix = ((JSAnimalBase)((Object)entity)).getModules().getGeneticModule().isMale() ? "male" : "female";
            return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + growthStage + "_" + suffix + ".png");
        }
        ResourceLocation variantLoc = variant.location();
        String path = variantLoc.getPath();
        boolean genderedVariants = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().isGenderedVariants();
        if (variant.ignoresGenders()) {
            return ResourceLocation.fromNamespaceAndPath((String)variantLoc.getNamespace(), (String)("textures/geo/animal/" + version + "/" + name + "/variants/" + name + "_adult_" + path + ".png"));
        }
        if (genderedVariants) {
            String suffix = ((JSAnimalBase)((Object)entity)).getModules().getGeneticModule().isMale() ? "_male" : "_female";
            return ResourceLocation.fromNamespaceAndPath((String)variantLoc.getNamespace(), (String)("textures/geo/animal/" + version + "/" + name + "/variants/" + name + "_adult_" + path + suffix + ".png"));
        }
        return ResourceLocation.fromNamespaceAndPath((String)variantLoc.getNamespace(), (String)("textures/geo/animal/" + version + "/" + name + "/variants/" + name + "_adult_" + path + ".png"));
    }

    protected String getEntityName(T entity) {
        return ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
    }

    private String getGrowthStage(T entity) {
        if (this.adultOnly) {
            return "adult";
        }
        return ((JSAnimalBase)((Object)entity)).getModules().getGrowthStageModule().getGrowthStage().getGrowthStageName();
    }

    public String getVersion(T entity) {
        float version = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().getVersion();
        return "v" + version;
    }

    protected String makeCacheKey(T entity, String type) {
        return type + ":" + ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName() + ":" + ((JSAnimalBase)((Object)entity)).getModules().getGrowthStageModule().getGrowthStage().name() + ":" + ((JSAnimalBase)((Object)entity)).getModules().getGeneticModule().isMale() + ":" + (String)entity.getEntityData().get(JSEntityDataHolder.textureVariant);
    }
}

