/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj.locator;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import net.minecraft.resources.ResourceLocation;
import travelers.server.animal.obj.locator.ResourceLocator;

public class JSGenderTextureLocator<T extends JSAnimalBase>
extends ResourceLocator<T> {
    protected final Map<String, ResourceLocation> cache = Collections.synchronizedMap(new WeakHashMap());

    public ResourceLocation getTextureLocation(T entity) {
        String key = this.makeKey(entity, "texture", ((JSAnimalBase)((Object)entity)).getModules().getGeneticModule().isMale());
        return this.cache.computeIfAbsent(key, k -> {
            String name = this.getEntityName(entity);
            String version = this.getVersion(entity);
            String gender = entity.getModules().getGeneticModule().isMale() ? "male" : "female";
            return ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + gender + ".png"));
        });
    }

    public ResourceLocation getModelLocation(T entity) {
        String key = this.makeKey(entity, "model");
        return this.cache.computeIfAbsent(key, k -> {
            String name = this.getEntityName(entity);
            String version = this.getVersion(entity);
            return ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)("geo/animal/" + version + "/" + name + "/" + name + ".geo.json"));
        });
    }

    public ResourceLocation getAnimationLocation(T entity) {
        String key = this.makeKey(entity, "anim");
        return this.cache.computeIfAbsent(key, k -> {
            String name = this.getEntityName(entity);
            String version = this.getVersion(entity);
            return ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)("animations/animal/" + version + "/" + name + "/" + name + ".animation.json"));
        });
    }

    private String getEntityName(T entity) {
        return ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
    }

    public String getVersion(T entity) {
        float version = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().getVersion();
        return "v" + (version % 1.0f == 0.0f ? (float)((int)version) : version);
    }

    private String makeKey(T entity, String type) {
        return type + ":" + ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName();
    }

    protected String makeKey(T entity, String type, boolean male) {
        return type + ":" + ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName() + ":" + male;
    }
}

