/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.obj.locator;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import net.minecraft.resources.ResourceLocation;
import travelers.server.animal.obj.locator.ResourceLocator;

public class JSVariantLocator<T extends JSAnimalBase>
extends ResourceLocator<T> {
    private final Map<String, ResourceLocation> cache = Collections.synchronizedMap(new WeakHashMap());

    public ResourceLocation getTextureLocation(T entity) {
        String key = this.makeKey(entity, "texture");
        return this.cache.computeIfAbsent(key, k -> this.buildTexture(entity));
    }

    private ResourceLocation buildTexture(T entity) {
        String name = this.getEntityName(entity);
        String version = this.getVersion(entity);
        String gender = ((JSAnimalBase)((Object)entity)).getModules().getGeneticModule().isMale() ? "male" : "female";
        JSVariants.JSVariant variant = ((JSAnimalBase)((Object)entity)).getModules().getGeneticModule().getGeneData().getVariant();
        boolean extinct = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().isExtinct();
        if (variant == JSVariants.NONE || !extinct) {
            return JSCommon.createId("textures/geo/animal/" + version + "/" + name + "/" + name + "_" + gender + ".png");
        }
        String basePath = "textures/geo/animal/" + version + "/" + name + "/variants/" + name + "_" + variant.getName();
        if (variant.ignoresGenders()) {
            return JSCommon.createId(basePath + ".png");
        }
        return JSCommon.createId(basePath + "_" + gender + ".png");
    }

    public ResourceLocation getModelLocation(T entity) {
        String key = this.makeKey(entity, "model");
        return this.cache.computeIfAbsent(key, k -> {
            String name = this.getEntityName(entity);
            String version = this.getVersion(entity);
            return JSCommon.createId("geo/animal/" + version + "/" + name + "/" + name + ".geo.json");
        });
    }

    public ResourceLocation getAnimationLocation(T entity) {
        String key = this.makeKey(entity, "anim");
        return this.cache.computeIfAbsent(key, k -> {
            String name = this.getEntityName(entity);
            String version = this.getVersion(entity);
            return JSCommon.createId("animations/animal/" + version + "/" + name + "/" + name + ".animation.json");
        });
    }

    private String getEntityName(T entity) {
        return ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
    }

    public String getVersion(T entity) {
        float version = ((JSAnimalBase)((Object)entity)).getAnimal().getAnimalAttributes().getMiscProperties().getVersion();
        return "v" + (version % 1.0f == 0.0f ? (float)((int)version) : version);
    }

    private String makeKey(T entity, String type) {
        JSVariants.JSVariant variant = ((JSAnimalBase)((Object)entity)).getModules().getGeneticModule().getGeneData().getVariant();
        boolean male = ((JSAnimalBase)((Object)entity)).getModules().getGeneticModule().isMale();
        return type + ":" + this.getEntityName(entity) + ":" + this.getVersion(entity) + ":" + variant.getName() + ":" + male;
    }
}

