/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.entity;

import com.google.common.base.Supplier;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.types.Type;
import jp.jurassicsaga.server.base.block.JSBlocks;
import jp.jurassicsaga.server.base.block.entity.obj.LargeNestBlockEntity;
import jp.jurassicsaga.server.base.block.entity.obj.MediumNestBlockEntity;
import jp.jurassicsaga.server.base.block.entity.obj.SmallNestBlockEntity;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.vanilla.JSHangingSignBlockEntity;
import jp.jurassicsaga.server.v1.block.entity.vanilla.JSSignBlockEntity;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import jp.jurassicsaga.server.v2.block.entity.JSV2BlockEntities;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import travelers.util.helper.TravelersRegistry;

public class JSBlockEntities {
    public static final TravelersRegistry<BlockEntityType<?>> BLOCK_ENTITIES = new TravelersRegistry(BuiltInRegistries.BLOCK_ENTITY_TYPE, "jurassicsaga");
    public static final Supplier<BlockEntityType<?>> HANGING_SIGN = BLOCK_ENTITIES.register("hanging_sign", () -> BlockEntityType.Builder.of(JSHangingSignBlockEntity::new, (Block[])new Block[]{(Block)JSV1Blocks.ARAUCARIOXYLON.HANGING_SIGN_WALL.get(), (Block)JSV1Blocks.ARAUCARIOXYLON.HANGING_SIGN.get(), (Block)JSV1Blocks.GORDONPTERIS.HANGING_SIGN_WALL.get(), (Block)JSV1Blocks.GORDONPTERIS.HANGING_SIGN.get(), (Block)JSV1Blocks.LEPIDODENDRON.HANGING_SIGN_WALL.get(), (Block)JSV1Blocks.LEPIDODENDRON.HANGING_SIGN.get(), (Block)JSV1Blocks.SPINIFRUCTUS.HANGING_SIGN_WALL.get(), (Block)JSV1Blocks.SPINIFRUCTUS.HANGING_SIGN.get(), (Block)JSV2Blocks.DOG_WOOD.HANGING_SIGN_WALL.get(), (Block)JSV2Blocks.DOG_WOOD.HANGING_SIGN.get()}).build(JSBlockEntities.type("hanging_sign")));
    public static final Supplier<BlockEntityType<?>> SIGN = BLOCK_ENTITIES.register("sign", () -> BlockEntityType.Builder.of(JSSignBlockEntity::new, (Block[])new Block[]{(Block)JSV1Blocks.ARAUCARIOXYLON.SIGN.get(), (Block)JSV1Blocks.ARAUCARIOXYLON.WALL_SIGN.get(), (Block)JSV1Blocks.GORDONPTERIS.SIGN.get(), (Block)JSV1Blocks.GORDONPTERIS.WALL_SIGN.get(), (Block)JSV1Blocks.LEPIDODENDRON.SIGN.get(), (Block)JSV1Blocks.LEPIDODENDRON.WALL_SIGN.get(), (Block)JSV1Blocks.SPINIFRUCTUS.SIGN.get(), (Block)JSV1Blocks.SPINIFRUCTUS.WALL_SIGN.get(), (Block)JSV2Blocks.DOG_WOOD.SIGN.get(), (Block)JSV2Blocks.DOG_WOOD.WALL_SIGN.get()}).build(JSBlockEntities.type("sign")));
    public static final Supplier<BlockEntityType<?>> SMALL_NEST = BLOCK_ENTITIES.register("small_nest", () -> BlockEntityType.Builder.of(SmallNestBlockEntity::new, (Block[])new Block[]{(Block)JSBlocks.SMALL_NEST.get()}).build(JSBlockEntities.type("small_nest")));
    public static final Supplier<BlockEntityType<?>> NEST = BLOCK_ENTITIES.register("nest", () -> BlockEntityType.Builder.of(MediumNestBlockEntity::new, (Block[])new Block[]{(Block)JSBlocks.MEDIUM_NEST.get()}).build(JSBlockEntities.type("nest")));
    public static final Supplier<BlockEntityType<?>> LARGE_NEST = BLOCK_ENTITIES.register("large_nest", () -> BlockEntityType.Builder.of(LargeNestBlockEntity::new, (Block[])new Block[]{(Block)JSBlocks.LARGE_NEST.get()}).build(JSBlockEntities.type("large_nest")));

    public static Type<?> type(String name) {
        return Util.fetchChoiceType((DSL.TypeReference)References.BLOCK_ENTITY, (String)name);
    }

    public static void init() {
        new JSV1BlockEntities();
        new JSV2BlockEntities();
    }
}

