/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.entity.obj;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.block.JSBlocks;
import jp.jurassicsaga.server.base.block.entity.JSBlockEntities;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import jp.jurassicsaga.server.base.item.obj.egg.FertileEggItem;
import jp.jurassicsaga.server.base.menu.obj.SmallNestMenu;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmallNestBlockEntity
extends GenericMachineEntity {
    private final int maxProgress = 60000;
    private int progress1 = 0;
    private int progress2 = 0;
    private int progress3 = 0;
    private int progress4 = 0;
    private int progress5 = 0;
    private final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 1 -> SmallNestBlockEntity.this.progress1;
                case 2 -> SmallNestBlockEntity.this.progress2;
                case 3 -> SmallNestBlockEntity.this.progress3;
                case 4 -> SmallNestBlockEntity.this.progress4;
                case 5 -> SmallNestBlockEntity.this.progress5;
                default -> 60000;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 1: {
                    SmallNestBlockEntity.this.progress1 = value;
                    break;
                }
                case 2: {
                    SmallNestBlockEntity.this.progress2 = value;
                    break;
                }
                case 3: {
                    SmallNestBlockEntity.this.progress3 = value;
                    break;
                }
                case 4: {
                    SmallNestBlockEntity.this.progress4 = value;
                    break;
                }
                case 5: {
                    SmallNestBlockEntity.this.progress5 = value;
                }
            }
        }

        public int getCount() {
            return 6;
        }
    };

    public SmallNestBlockEntity(BlockPos pos, BlockState state) {
        super(5, (Block)JSBlocks.SMALL_NEST.get(), (BlockEntityType)JSBlockEntities.SMALL_NEST.get(), pos, state);
    }

    private void tickItem(int slot, Level lvl, SmallNestBlockEntity be) {
        ItemStack slot1 = (ItemStack)be.items.get(slot);
        if (lvl.isClientSide) {
            return;
        }
        Item item = slot1.getItem();
        if (item instanceof FertileEggItem) {
            FertileEggItem eggItem = (FertileEggItem)item;
            int speed = this.level.getGameRules().getInt(JSCommon.MACHINE_SPEED);
            int progressCur = switch (slot) {
                case 0 -> be.progress1;
                case 1 -> be.progress2;
                case 2 -> be.progress3;
                case 3 -> be.progress4;
                case 4 -> be.progress5;
                default -> 0;
            };
            CompoundTag animal = (CompoundTag)slot1.get((DataComponentType)JSDataComponents.GENE_DATA.get());
            if (animal == null) {
                return;
            }
            JSGeneData geneData = JSGeneUtil.fromCompound(animal);
            ResourceLocation name = ResourceLocation.bySeparator((String)geneData.getDataOwnerName(), (char)':');
            JSAnimal<?> animal1 = JSAnimals.getAnimal(name.getPath());
            if (animal1 == null || animal1.getItems().getHatched_egg() == null) {
                return;
            }
            if ((progressCur += speed) >= be.maxProgress) {
                JSGeneData data = JSGeneUtil.readFromStack(slot1);
                ItemStack output = ((Item)animal1.getItems().getHatched_egg().get()).getDefaultInstance();
                int failChance = 0;
                int roll = this.level.getRandom().nextInt(0, 100);
                if (roll < failChance) {
                    be.items.set(slot, (Object)((Item)JSV1Items.FAILED_EGG.get()).getDefaultInstance());
                } else {
                    if (data.isValid()) {
                        JSGeneUtil.writeToStack(output, data);
                    }
                    be.items.set(slot, (Object)output);
                }
                progressCur = 0;
            }
            switch (slot) {
                case 0: {
                    be.progress1 = progressCur;
                    break;
                }
                case 1: {
                    be.progress2 = progressCur;
                    break;
                }
                case 2: {
                    be.progress3 = progressCur;
                    break;
                }
                case 3: {
                    be.progress4 = progressCur;
                    break;
                }
                case 4: {
                    be.progress5 = progressCur;
                }
            }
        } else {
            switch (slot) {
                case 0: {
                    be.progress1 = 0;
                    break;
                }
                case 1: {
                    be.progress2 = 0;
                    break;
                }
                case 2: {
                    be.progress3 = 0;
                    break;
                }
                case 3: {
                    be.progress4 = 0;
                    break;
                }
                case 4: {
                    be.progress5 = 0;
                }
            }
        }
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("js.egg.0", this.progress1);
        tag.putInt("js.egg.1", this.progress2);
        tag.putInt("js.egg.2", this.progress3);
        tag.putInt("js.egg.3", this.progress4);
        tag.putInt("js.egg.4", this.progress5);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.progress1 = tag.getInt("js.egg.0");
        this.progress2 = tag.getInt("js.egg.1");
        this.progress3 = tag.getInt("js.egg.2");
        this.progress4 = tag.getInt("js.egg.3");
        this.progress5 = tag.getInt("js.egg.4");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putInt("js.egg.0", this.progress1);
        tag.putInt("js.egg.1", this.progress2);
        tag.putInt("js.egg.2", this.progress3);
        tag.putInt("js.egg.3", this.progress4);
        tag.putInt("js.egg.4", this.progress5);
        return tag;
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    @Override
    public void workTick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (!(be instanceof SmallNestBlockEntity)) {
            return;
        }
        SmallNestBlockEntity e = (SmallNestBlockEntity)be;
        this.localTick(level, e);
    }

    public void localTick(Level lvl, SmallNestBlockEntity be) {
        be.tickItem(0, lvl, be);
        be.tickItem(1, lvl, be);
        be.tickItem(2, lvl, be);
        be.tickItem(3, lvl, be);
        be.tickItem(4, lvl, be);
        be.setChanged();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new SmallNestMenu(i, inventory, this, this.data);
    }
}

