/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class JSTransparentBlock
extends TransparentBlock {
    private final boolean clearSides;

    public JSTransparentBlock(BlockBehaviour.Properties props, boolean clearSides) {
        super(props);
        this.clearSides = clearSides;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        if (!this.clearSides) {
            return state.getBlock() instanceof HalfTransparentBlock || state.getBlock() instanceof LeavesBlock;
        }
        return true;
    }

    public boolean shouldHideAdjacentFluidFace(BlockState state, Direction selfFace, FluidState adjacentFluid) {
        if (!this.clearSides) {
            return state.getFluidState().getType().isSame(adjacentFluid.getType());
        }
        return selfFace != Direction.UP || !adjacentFluid.isEmpty();
    }

    protected boolean isOcclusionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        if (!this.clearSides) {
            return super.isOcclusionShapeFullBlock(state, level, pos);
        }
        return false;
    }
}

