/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.fence;

import java.util.stream.Stream;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PoleBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty CONNECTED = BooleanProperty.create((String)"attached");
    public static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");
    public static final VoxelShape SHAPE_NORTH = PoleBlock.getShape();
    public static final VoxelShape SHAPE_EAST = JSUtils.rotateShape(SHAPE_NORTH, Rotation.CLOCKWISE_90);
    public static final VoxelShape SHAPE_SOUTH = JSUtils.rotateShape(SHAPE_NORTH, Rotation.CLOCKWISE_180);
    public static final VoxelShape SHAPE_WEST = JSUtils.rotateShape(SHAPE_NORTH, Rotation.COUNTERCLOCKWISE_90);

    public PoleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, CONNECTED, POWERED});
    }

    @NotNull
    protected VoxelShape getShape(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        switch ((Direction)pState.getValue((Property)FACING)) {
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    @NotNull
    protected BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(false));
    }

    public static VoxelShape getShape() {
        return Stream.of(Block.box((double)5.25, (double)0.0, (double)10.0, (double)10.75, (double)16.0, (double)12.0), Block.box((double)5.25, (double)0.0, (double)20.0, (double)10.75, (double)16.0, (double)22.0), Block.box((double)6.25, (double)0.0, (double)12.0, (double)9.75, (double)16.0, (double)20.0), Block.box((double)7.75, (double)11.5, (double)9.0, (double)8.25, (double)12.5, (double)10.5), Block.box((double)7.75, (double)11.0, (double)7.0, (double)8.25, (double)13.0, (double)9.0), Block.box((double)7.75, (double)3.5, (double)9.0, (double)8.25, (double)4.5, (double)10.5), Block.box((double)7.75, (double)3.0, (double)7.0, (double)8.25, (double)5.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    }
}

