/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.furniture;

import java.util.List;
import java.util.stream.Stream;
import jp.jurassicsaga.server.base.entity.obj.other.SeatEntity;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BenchBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape shape_north = BenchBlock.north();
    public static final VoxelShape shape_east = JSUtils.rotateShape(shape_north, Rotation.CLOCKWISE_90);
    public static final VoxelShape shape_south = JSUtils.rotateShape(shape_north, Rotation.CLOCKWISE_180);
    public static final VoxelShape shape_west = JSUtils.rotateShape(shape_north, Rotation.COUNTERCLOCKWISE_90);

    public BenchBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.WOOD).noOcclusion().isValidSpawn((pState, pLevel, pPos, pValue) -> false).isSuffocating((pState, pLevel, pPos) -> false).isViewBlocking((pState, pLevel, pPos) -> false).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor((pState, pLevel, pPos) -> false));
    }

    public void destroy(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
        super.destroy(level, pos, state);
        List passengers = level.getEntitiesOfClass(SeatEntity.class, new AABB(pos).inflate(1.0), e -> true);
        for (SeatEntity passenger : passengers) {
            passenger.discard();
        }
    }

    @NotNull
    public MutableComponent getName() {
        return super.getName();
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if (player.isPassenger()) {
                return InteractionResult.PASS;
            }
            List passengers = level.getEntitiesOfClass(SeatEntity.class, new AABB(pos).inflate(1.0), e -> true);
            Vec3 pos2 = null;
            if (!passengers.isEmpty()) {
                if (passengers.size() < 2) {
                    Direction direction = (Direction)state.getValue((Property)FACING);
                    pos2 = switch (direction) {
                        case Direction.WEST, Direction.EAST -> new Vec3((double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)pos.getZ());
                        default -> new Vec3((double)pos.getX(), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f));
                    };
                    SeatEntity seat = new SeatEntity(level, pos2, false);
                    level.addFreshEntity((Entity)seat);
                    seat.setPos(pos2);
                    player.startRiding((Entity)seat);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            Direction direction = (Direction)state.getValue((Property)FACING);
            pos2 = switch (direction) {
                case Direction.WEST, Direction.EAST -> new Vec3((double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 1.0f));
                default -> new Vec3((double)((float)pos.getX() + 1.0f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f));
            };
            SeatEntity seat = new SeatEntity(level, pos2, false);
            level.addFreshEntity((Entity)seat);
            seat.lerpTo(pos2.x, pos2.y, pos2.z, 0.0f, 0.0f, 0);
            player.startRiding((Entity)seat);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    protected VoxelShape getShape(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        switch ((Direction)pState.getValue((Property)FACING)) {
            case EAST: {
                return shape_east;
            }
            case SOUTH: {
                return shape_south;
            }
            case WEST: {
                return shape_west;
            }
        }
        return shape_north;
    }

    public static VoxelShape north() {
        return Stream.of(Block.box((double)-8.9, (double)-0.7000000000000002, (double)1.0, (double)-2.5, (double)6.2, (double)16.0), Block.box((double)18.5, (double)-0.7000000000000002, (double)1.0, (double)24.9, (double)6.2, (double)16.0), Block.box((double)-14.5, (double)6.2, (double)5.100000000000001, (double)30.4, (double)7.6000000000000005, (double)16.0), Block.box((double)18.89999999999999, (double)6.2, (double)0.1000000000000636, (double)24.79999999999999, (double)11.8, (double)4.299999999999994), Block.box((double)-8.79999999999999, (double)10.0, (double)-1.8999999999999346, (double)-2.8999999999999915, (double)16.400000000000002, (double)2.2999999999999936), Block.box((double)-8.79999999999999, (double)6.2, (double)0.1000000000000636, (double)-2.8999999999999915, (double)11.8, (double)4.299999999999994), Block.box((double)-14.79999999999999, (double)8.2, (double)4.299999999999994, (double)30.10000000000001, (double)11.8, (double)5.299999999999994), Block.box((double)-14.79999999999999, (double)11.199999999999989, (double)2.5, (double)30.10000000000001, (double)14.79999999999999, (double)3.5), Block.box((double)-14.79999999999999, (double)14.599999999999977, (double)1.3000000000000043, (double)30.10000000000001, (double)18.200000000000017, (double)2.3000000000000043), Block.box((double)18.89999999999999, (double)10.0, (double)-1.8999999999999346, (double)24.79999999999999, (double)16.400000000000002, (double)2.2999999999999936)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    }

    @NotNull
    protected BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }
}

