/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.plant;

import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import jp.jurassicsaga.JSCommon;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class JSPlantBlock
extends BushBlock
implements BonemealableBlock {
    protected final int spreadRadius = 5;
    protected final int spreadHeight = 2;
    protected final int maxSamePlant = 3;
    protected final boolean requiresLight;
    protected final boolean spreadsAtDay;
    protected final int spreadChance = 50;
    public MapCodec<JSPlantBlock> codec = JSPlantBlock.simpleCodec(JSPlantBlock::new);

    public JSPlantBlock(BlockBehaviour.Properties props, boolean requiresLight, boolean spreadsAtDay) {
        super(props.randomTicks());
        this.requiresLight = requiresLight;
        this.spreadsAtDay = spreadsAtDay;
    }

    public JSPlantBlock(BlockBehaviour.Properties props, boolean requiresLight) {
        this(props.randomTicks(), requiresLight, true);
    }

    public JSPlantBlock(BlockBehaviour.Properties props) {
        this(props.randomTicks(), true, true);
    }

    @NotNull
    protected MapCodec<? extends BushBlock> codec() {
        return this.codec;
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(@NotNull Level level, RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return random.nextInt(7) == 0;
    }

    public void performBonemeal(@NotNull ServerLevel level, RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        for (int i = 0; i < random.nextInt(1, 4); ++i) {
            if (!level.isLoaded(pos)) {
                return;
            }
            if (!this.isSpreadSuccess((Level)level, random, pos, state)) continue;
            this.performSpread((Level)level, random, pos, state);
        }
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.randomTick(state, level, pos, random);
        if (!level.isLoaded(pos)) {
            return;
        }
        if (!level.getGameRules().getBoolean(JSCommon.PLANT_SPREADING)) {
            return;
        }
        if ((float)random.nextInt(100) > 75.0f) {
            return;
        }
        if (this.isSpreadSuccess((Level)level, random, pos, state)) {
            this.performSpread((Level)level, random, pos, state);
        }
    }

    public boolean isSpreadSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        if (this.requiresLight ? !this.spreadsAtDay || level.isDay() && level.getMaxLocalRawBrightness(pos.above()) >= 9 : !this.spreadsAtDay || level.isDay() && level.getMaxLocalRawBrightness(pos.above()) <= 8) {
            return this.getNumberOfNeibours(level, pos) < 6 && this.isWaterInRange(level, pos);
        }
        return false;
    }

    public void performSpread(Level level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos spreadTo = this.getSpreadPosition(level, random, pos, state, 5, 2);
        BlockState spr = level.getBlockState(spreadTo);
        if (spr.getBlock() != this && spr.isAir() && level.getBlockState(spreadTo.below()).is(BlockTags.DIRT)) {
            level.setBlockAndUpdate(spreadTo, this.defaultBlockState());
        }
    }

    public BlockPos getSpreadPosition(Level level, RandomSource random, BlockPos pos, BlockState state, int radius, int verticalDistance) {
        return pos.offset(random.nextInt(radius * 2) - radius, random.nextInt(verticalDistance * 2) - verticalDistance, random.nextInt(radius * 2) - radius);
    }

    public int getNumberOfNeibours(Level worldIn, BlockPos originalPos) {
        int spreadxz = 2;
        int y = 1;
        Stream e = BlockPos.MutableBlockPos.betweenClosedStream((AABB)AABB.of((BoundingBox)new BoundingBox(-spreadxz, -y, -spreadxz, spreadxz, y, spreadxz)).move(originalPos));
        Stream<BlockPos> filtered = e.filter(blockPos -> worldIn.getBlockState(blockPos).getBlock() == this);
        return (int)filtered.count() - 1;
    }

    public boolean isWaterInRange(Level worldIn, BlockPos pos) {
        int spreadxz = 5;
        int y = 1;
        Stream e = BlockPos.MutableBlockPos.betweenClosedStream((AABB)AABB.of((BoundingBox)new BoundingBox(-spreadxz, -y, -spreadxz, spreadxz, y, spreadxz)).move(pos));
        return e.anyMatch(blockPos -> worldIn.getBlockState(blockPos).getFluidState().is(FluidTags.WATER));
    }
}

