/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.other.vehicle;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jp.jurassicsaga.server.base.entity.obj.other.SeatEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class JSVehicleEntity
extends Entity {
    private static final EntityDataAccessor<Float> CURRENT_SPEED = SynchedEntityData.defineId(JSVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private float yHeadRotO;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private final List<SeatEntity> seats = new LinkedList<SeatEntity>();
    private float maxSpeed = 2.0f;
    private float maxSpeedBackwards = 0.5f;
    private float acceleration = 0.1f;
    private float liftOffSpeed = 0.05f;
    private float liftOffTurn = 0.05f;
    private float turnSpeed = 0.1f;
    private float maxTurnSpeed = 5.0f;
    private float currentTurn = 0.0f;
    private final SeatEntity driverSeat;
    private boolean hasDriver = true;

    public JSVehicleEntity(EntityType<? extends JSVehicleEntity> entityType, Level level) {
        super(entityType, level);
        this.initializeSeats();
        this.driverSeat = this.seats.getFirst();
        for (SeatEntity seat : this.seats) {
            level.addFreshEntity((Entity)seat);
            Vec3 relative = seat.getRelativePos();
            seat.teleportTo(relative.x, relative.y, relative.z);
        }
    }

    protected abstract void initializeSeats();

    protected void addSeat(double x, double y, double z) {
        this.seats.add(new SeatEntity(this.level(), new Vec3(x, y, z), true));
    }

    public boolean canUsePortal(boolean allowPassengers) {
        return false;
    }

    public boolean mayInteract(Level level, BlockPos pos) {
        return true;
    }

    public boolean skipAttackInteraction(Entity entity) {
        return false;
    }

    public void disableDriver() {
        this.hasDriver = false;
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        SeatEntity closestSeat = null;
        double closestDistance = Double.MAX_VALUE;
        for (SeatEntity seat : this.seats) {
            double distance;
            if (seat == null || !((distance = player.position().distanceTo(seat.position())) < closestDistance)) continue;
            closestSeat = seat;
            closestDistance = distance;
        }
        if (closestSeat != null && closestSeat.hasNoPassenger()) {
            player.startRiding((Entity)closestSeat);
            return InteractionResult.SUCCESS;
        }
        return super.interactAt(player, vec, hand);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean canCollideWith(Entity entity) {
        return Boat.canVehicleCollide((Entity)this, (Entity)entity);
    }

    public boolean isPushable() {
        return true;
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
    }

    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        SeatEntity closestSeat = null;
        double closestDistance = Double.MAX_VALUE;
        for (SeatEntity seat : this.seats) {
            double distance;
            if (seat == null || !((distance = player.position().distanceTo(seat.position())) < closestDistance)) continue;
            closestSeat = seat;
            closestDistance = distance;
        }
        if (closestSeat != null && closestSeat.hasNoPassenger()) {
            player.startRiding((Entity)closestSeat);
            return InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    public boolean canBeHitByProjectile() {
        return true;
    }

    public boolean canSprint() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(CURRENT_SPEED, (Object)Float.valueOf(0.0f));
    }

    public boolean isAlwaysTicking() {
        return (double)this.getCurrentSpeed() > 0.0;
    }

    public void tick() {
        this.yHeadRotO = this.getYHeadRot();
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        super.tick();
        this.tickLerp();
        if (!this.level().isClientSide) {
            if (this.hasDriver && this.driverSeat != null) {
                Player driver = (Player)this.driverSeat.getFirstPassenger();
                float currentSpeed = this.getCurrentSpeed();
                if (driver instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)driver;
                    currentSpeed = (float)Math.round(currentSpeed * 10.0f) / 10.0f;
                    if ((double)serverPlayer.zza > 0.0) {
                        currentSpeed = Math.min(currentSpeed + this.acceleration, this.maxSpeed);
                    }
                    if ((double)serverPlayer.zza < 0.0) {
                        currentSpeed = Math.max(currentSpeed - this.acceleration, -this.maxSpeedBackwards);
                    }
                    if ((double)serverPlayer.zza == 0.0) {
                        currentSpeed = this.approachZero(currentSpeed, this.liftOffSpeed);
                    }
                    this.currentTurn = (double)serverPlayer.xxa < 0.0 ? Math.min(this.currentTurn + this.turnSpeed, this.maxTurnSpeed) : (serverPlayer.xxa > 0.0f ? Math.max(this.currentTurn - this.turnSpeed, -this.maxTurnSpeed) : this.approachZero(this.currentTurn, this.turnSpeed));
                    if ((double)Math.abs(this.currentTurn) > 0.001) {
                        this.setYRot(this.getYRot() + this.currentTurn);
                    }
                    if ((double)Math.abs(currentSpeed) > 0.001) {
                        double dx = -Math.sin(Math.toRadians(this.getYRot())) * (double)currentSpeed;
                        double dz = Math.cos(Math.toRadians(this.getYRot())) * (double)currentSpeed;
                        Vec3 movementVec = this.applyGravityToVec(dx, dz);
                        this.move(MoverType.SELF, movementVec);
                    }
                } else {
                    currentSpeed = this.approachZero(currentSpeed, this.liftOffSpeed);
                    this.currentTurn = this.approachZero(this.currentTurn, this.turnSpeed);
                    if ((double)Math.abs(this.currentTurn) > 0.001) {
                        this.setYRot(this.getYRot() + this.currentTurn);
                    }
                    if ((double)Math.abs(currentSpeed) > 0.001) {
                        double dx = -Math.sin(Math.toRadians(this.getYRot())) * (double)currentSpeed;
                        double dz = Math.cos(Math.toRadians(this.getYRot())) * (double)currentSpeed;
                        Vec3 movementVec = this.applyGravityToVec(dx, dz);
                        this.move(MoverType.SELF, movementVec);
                    }
                }
                this.setCurrentSpeed(currentSpeed);
            } else {
                float currentSpeed = this.getCurrentSpeed();
                currentSpeed = this.approachZero(currentSpeed, this.liftOffSpeed);
                this.currentTurn = this.approachZero(this.currentTurn, this.turnSpeed);
                if ((double)Math.abs(this.currentTurn) > 0.001) {
                    this.setYRot(this.getYRot() + this.currentTurn);
                }
                if ((double)Math.abs(currentSpeed) > 0.001) {
                    double dx = -Math.sin(Math.toRadians(this.getYRot())) * (double)currentSpeed;
                    double dz = Math.cos(Math.toRadians(this.getYRot())) * (double)currentSpeed;
                    Vec3 movementVec = this.applyGravityToVec(dx, dz);
                    this.move(MoverType.SELF, movementVec);
                }
                this.setCurrentSpeed(currentSpeed);
            }
            this.applyGravity();
            this.handleCollision();
            this.checkForClimbingBlocks();
            this.updateSeats(this.getYRot());
        }
    }

    private Vec3 applyGravityToVec(double dx, double dz) {
        return new Vec3(dx, -1.0, dz);
    }

    private void checkForClimbingBlocks() {
        double forwardSin = Math.sin(Math.toRadians(this.getYRot()));
        double forwardCos = Math.cos(Math.toRadians(this.getYRot()));
        for (int i = -1; i <= 1; ++i) {
            double frontX = this.getX() - forwardSin * 3.0 + (double)i * forwardCos;
            double frontZ = this.getZ() + forwardCos * 3.0 + (double)i * forwardSin;
            BlockPos frontPos = new BlockPos((int)Math.floor(frontX), (int)Math.floor(this.getY()), (int)Math.floor(frontZ));
            BlockState state = this.level().getBlockState(frontPos);
            if (!state.isSolid()) continue;
            if (this.getY() % 1.0 == 0.0 && this.level().getBlockState(frontPos.above()).isAir()) {
                Vec3 pos = this.position();
                this.setPos(new Vec3(pos.x - forwardSin * 0.5, pos.y + 1.1, pos.z + forwardCos * 0.5));
                return;
            }
            this.setCurrentSpeed(0.0f);
            return;
        }
    }

    private void handleCollision() {
        if ((double)Math.abs(this.getCurrentSpeed()) < 0.1) {
            return;
        }
        AABB boundingBox = this.getBoundingBox().inflate(0.2);
        List collidedEntities = this.level().getEntities((Entity)this, boundingBox, entity -> {
            ArrayList<Entity> entities = new ArrayList<Entity>();
            for (SeatEntity seat : this.seats) {
                if (seat.getFirstPassenger() == null) continue;
                entities.add(seat.getFirstPassenger());
            }
            return !entities.contains(entity) && this.canCollideWith((Entity)entity);
        });
        Vec3 movementDirection = new Vec3(-Math.sin(Math.toRadians(this.getYRot())), 0.0, Math.cos(Math.toRadians(this.getYRot()))).normalize();
        for (Entity entity2 : collidedEntities) {
            Vec3 entityDirection;
            double dotProduct;
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity2;
            if (entity2 == this.getFirstPassenger() || !((dotProduct = movementDirection.dot(entityDirection = entity2.position().subtract(this.position()).normalize())) > 0.5)) continue;
            float damage = Math.abs(this.getCurrentSpeed()) * 5.0f;
            livingEntity.hurt(this.level().damageSources().cramming(), damage);
        }
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.lerpXRot = xRot;
        this.lerpSteps = 10;
        this.yHeadRotO = this.getYHeadRot();
    }

    public float getCurrentSpeed() {
        return ((Float)this.getEntityData().get(CURRENT_SPEED)).floatValue();
    }

    public void setCurrentSpeed(float speed) {
        this.getEntityData().set(CURRENT_SPEED, (Object)Float.valueOf(speed));
    }

    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    private void tickLerp() {
        if (this.lerpSteps > 0) {
            this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            --this.lerpSteps;
        }
    }

    private float approachZero(float value, float step) {
        if (value > 0.0f) {
            return Math.max(value - step, 0.0f);
        }
        if (value < 0.0f) {
            return Math.min(value + step, 0.0f);
        }
        return 0.0f;
    }

    private void updateSeats(float yRot) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        double cosRot = Math.cos(Math.toRadians(yRot));
        double sinRot = Math.sin(Math.toRadians(yRot));
        for (SeatEntity seat : this.seats) {
            if (seat.getRelativePos() == null) continue;
            double relativeX = seat.getRelativePos().x;
            double relativeZ = seat.getRelativePos().z;
            double rotatedX = relativeX * cosRot - relativeZ * sinRot;
            double rotatedZ = relativeX * sinRot + relativeZ * cosRot;
            seat.setYRot(yRot);
            seat.setPos(new Vec3(x + rotatedX, y + seat.getRelativePos().y, z + rotatedZ));
        }
    }

    public float getYHeadRotO() {
        return this.yHeadRotO;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(float maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public float getMaxSpeedBackwards() {
        return this.maxSpeedBackwards;
    }

    public void setMaxSpeedBackwards(float maxSpeedBackwards) {
        this.maxSpeedBackwards = maxSpeedBackwards;
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(float acceleration) {
        this.acceleration = acceleration;
    }

    public float getLiftOffSpeed() {
        return this.liftOffSpeed;
    }

    public void setLiftOffSpeed(float liftOffSpeed) {
        this.liftOffSpeed = liftOffSpeed;
    }

    public float getLiftOffTurn() {
        return this.liftOffTurn;
    }

    public void setLiftOffTurn(float liftOffTurn) {
        this.liftOffTurn = liftOffTurn;
    }

    public float getTurnSpeed() {
        return this.turnSpeed;
    }

    public void setTurnSpeed(float turnSpeed) {
        this.turnSpeed = turnSpeed;
    }

    public float getMaxTurnSpeed() {
        return this.maxTurnSpeed;
    }

    public void setMaxTurnSpeed(float maxTurnSpeed) {
        this.maxTurnSpeed = maxTurnSpeed;
    }

    public float getCurrentTurn() {
        return this.currentTurn;
    }
}

