/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.vanilla;

import jp.jurassicsaga.server.base.entity.JSEntities;
import jp.jurassicsaga.server.base.entity.obj.vanilla.JSBoatEntity;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public class JSChestBoatEntity
extends JSBoatEntity
implements HasCustomInventoryScreen,
ContainerEntity {
    private NonNullList<ItemStack> itemStacks = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private ResourceKey<LootTable> lootTable;
    private long lootTableSeed;

    public JSChestBoatEntity(EntityType<? extends Boat> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public JSChestBoatEntity(Level pLevel, double pX, double pY, double pZ) {
        this((EntityType<? extends Boat>)((EntityType)JSEntities.BOAT_CHEST.get()), pLevel);
        this.setPos(pX, pY, pZ);
        this.xo = pX;
        this.yo = pY;
        this.zo = pZ;
    }

    protected float getSinglePassengerXOffset() {
        return 0.15f;
    }

    protected int getMaxPassengers() {
        return 1;
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        this.addChestVehicleSaveData(pCompound, (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.readChestVehicleSaveData(pCompound, (HolderLookup.Provider)this.registryAccess());
    }

    public void destroy(@NotNull DamageSource pDamageSource) {
        super.destroy(pDamageSource);
        this.chestVehicleDestroyed(pDamageSource, this.level(), (Entity)this);
    }

    public void remove(@NotNull Entity.RemovalReason pReason) {
        if (!this.level().isClientSide && pReason.shouldDestroy()) {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this);
        }
        super.remove(pReason);
    }

    @NotNull
    public InteractionResult interact(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (this.canAddPassenger((Entity)pPlayer) && !pPlayer.isSecondaryUseActive()) {
            return super.interact(pPlayer, pHand);
        }
        InteractionResult interactionresult = this.interactWithContainerVehicle(pPlayer);
        if (interactionresult.consumesAction()) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)pPlayer);
            PiglinAi.angerNearbyPiglins((Player)pPlayer, (boolean)true);
        }
        return interactionresult;
    }

    public void openCustomInventoryScreen(Player pPlayer) {
        pPlayer.openMenu((MenuProvider)this);
        if (!pPlayer.level().isClientSide) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)pPlayer);
            PiglinAi.angerNearbyPiglins((Player)pPlayer, (boolean)true);
        }
    }

    @Override
    @NotNull
    public Item getDropItem() {
        return switch (this.getNWBoatEntityType()) {
            case JSBoatEntity.CustomType.ARAUCARIOXYLON -> (Item)JSV1Items.ARAUCARIOXYLON_CHEST_BOAT.get();
            case JSBoatEntity.CustomType.GORDONPTERIS -> (Item)JSV1Items.GORDONOPTERIS_CHEST_BOAT.get();
            case JSBoatEntity.CustomType.LEPIDODENDRON -> (Item)JSV1Items.LEPIDODENDRON_CHEST_BOAT.get();
            case JSBoatEntity.CustomType.SPINIFRUCTUS -> (Item)JSV1Items.SPINIFRUCTUS_CHEST_BOAT.get();
            default -> Items.OAK_CHEST_BOAT;
        };
    }

    public void clearContent() {
        this.clearChestVehicleContent();
    }

    public int getContainerSize() {
        return 27;
    }

    @NotNull
    public ItemStack getItem(int pSlot) {
        return this.getChestVehicleItem(pSlot);
    }

    @NotNull
    public ItemStack removeItem(int pSlot, int pAmount) {
        return this.removeChestVehicleItem(pSlot, pAmount);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int pSlot) {
        return this.removeChestVehicleItemNoUpdate(pSlot);
    }

    public void setItem(int pSlot, @NotNull ItemStack pStack) {
        this.setChestVehicleItem(pSlot, pStack);
    }

    @NotNull
    public SlotAccess getSlot(int pSlot) {
        return this.getChestVehicleSlot(pSlot);
    }

    public void setChanged() {
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return this.isChestVehicleStillValid(pPlayer);
    }

    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        if (this.lootTable != null && pPlayer.isSpectator()) {
            return null;
        }
        this.unpackLootTable(pPlayerInventory.player);
        return ChestMenu.threeRows((int)pContainerId, (Inventory)pPlayerInventory, (Container)this);
    }

    public void unpackLootTable(Player pPlayer) {
        this.unpackChestVehicleLootTable(pPlayer);
    }

    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(ResourceKey<LootTable> pLootTable) {
        this.lootTable = pLootTable;
    }

    @NotNull
    public NonNullList<ItemStack> getItemStacks() {
        return this.itemStacks;
    }

    public void clearItemStacks() {
        this.itemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    }

    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setLootTableSeed(long lootTableSeed) {
        this.lootTableSeed = lootTableSeed;
    }
}

